/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.EventListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerListener;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksNodeTree;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTable;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTableModel;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class BookmarksView
extends TopComponent
implements BookmarkManagerListener,
PropertyChangeListener,
ExplorerManager.Provider {
    private static final String HELP_ID = "bookmarks_window_csh";
    private static final ActionListener OPEN_ACTION = e -> BookmarksView.openView();
    private final transient BookmarksNodeTree nodeTree = new BookmarksNodeTree();
    private final transient ExplorerManager explorerManager = new ExplorerManager();
    private transient boolean treeViewShowing;
    private transient JSplitPane splitPane;
    private transient BookmarksTableView tableView;
    private transient BeanTreeView treeView;
    private transient JPanel previewPanel;
    private transient boolean dividerLocationUpdating;
    private transient JToggleButton bookmarksTreeButton;
    private transient JToggleButton bookmarksTableButton;
    private transient JToggleButton showPreviewButton;
    private transient BookmarkInfo displayedBookmarkInfo;
    private transient boolean initialTreeSelectionDone;
    private static final String PREFS_NODE = "BookmarksProperties";
    private static final Preferences prefs = NbPreferences.forModule(BookmarksView.class).node("BookmarksProperties");
    private static final String TREE_VIEW_VISIBLE_PREF = "treeViewVisible";
    private static final String PREVIEW_VISIBLE_PREF = "previewVisible";
    private static final String DIVIDER_LOCATION_PREF = "dividerLocation";

    public static TopComponent create() {
        return new BookmarksView();
    }

    public static BookmarksView openView() {
        BookmarksView bookmarksView = (BookmarksView)WindowManager.getDefault().findTopComponent("bookmarks");
        if (bookmarksView == null) {
            bookmarksView = (BookmarksView)BookmarksView.create();
        }
        bookmarksView.open();
        bookmarksView.requestActive();
        return bookmarksView;
    }

    public static ActionListener openAction() {
        return OPEN_ACTION;
    }

    BookmarksView() {
        this.explorerManager.setRootContext(this.nodeTree.rootNode());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap));
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(84, 128), "toggle-view");
        actionMap.put("toggle-view", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksView.this.setTreeViewVisible(!BookmarksView.this.treeViewShowing);
            }
        });
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/editor/bookmarks/resources/bookmark_16.png"));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public String getName() {
        return NbBundle.getMessage(BookmarksView.class, (String)"LBL_BookmarksView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String preferredID() {
        return "bookmarks";
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getToolTipText() {
        return NbBundle.getMessage(BookmarksView.class, (String)"LBL_BookmarksViewToolTip");
    }

    private void initLayoutAndComponents() {
        if (this.previewPanel == null) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.add(this.createLeftToolBar(), gridBagConstraints);
            this.splitPane = new JSplitPane(1);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.addPropertyChangeListener(DIVIDER_LOCATION_PREF, pce -> {
                if (this.splitPane.getLeftComponent() != null && this.splitPane.getRightComponent() != null && !this.dividerLocationUpdating) {
                    prefs.putInt(DIVIDER_LOCATION_PREF, this.splitPane.getDividerLocation());
                }
            });
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new GridLayout(1, 1));
            BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this.previewPanel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add(this.splitPane, gridBagConstraints);
            this.setTreeViewVisible(prefs.getBoolean(TREE_VIEW_VISIBLE_PREF, true));
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                lockedBookmarkManager.addBookmarkManagerListener((BookmarkManagerListener)WeakListeners.create(BookmarkManagerListener.class, (EventListener)this, (Object)lockedBookmarkManager));
            }
            finally {
                lockedBookmarkManager.unlock();
            }
            this.updateSplitPane();
        }
    }

    @Override
    public void bookmarksChanged(BookmarkManagerEvent evt) {
        this.updateTreeRootContext(evt);
        if (!this.initialTreeSelectionDone) {
            SwingUtilities.invokeLater(() -> this.doInitialSelection());
        }
    }

    private void setTreeViewVisible(boolean treeViewVisible) {
        prefs.putBoolean(TREE_VIEW_VISIBLE_PREF, treeViewVisible);
        if (treeViewVisible != this.treeViewShowing) {
            this.treeViewShowing = treeViewVisible;
            this.updateSplitPane();
        }
    }

    private void updateSplitPane() {
        this.dividerLocationUpdating = true;
        try {
            TreeOrTableContainer container;
            boolean create;
            if (this.treeViewShowing) {
                boolean bl = create = this.treeView == null;
                if (create) {
                    container = new TreeOrTableContainer();
                    this.updateTreeRootContext(null);
                    this.treeView = new BeanTreeView();
                    container.add((Component)this.treeView);
                    BookmarksView.fixScrollPaneinSplitPaneJDKIssue((Component)this.treeView);
                    this.treeView.setRootVisible(false);
                    this.treeView.setDragSource(false);
                    this.treeView.setDropTarget(false);
                } else {
                    container = (TreeOrTableContainer)this.treeView.getParent();
                }
            } else {
                boolean bl = create = this.tableView == null;
                if (create) {
                    this.tableView = new BookmarksTableView();
                    container = new TreeOrTableContainer();
                    container.add(this.tableView);
                    this.rebuildTableEntries();
                    this.initTableView();
                } else {
                    container = (TreeOrTableContainer)this.tableView.getParent();
                }
            }
            this.splitPane.setLeftComponent(container);
            if (!this.treeViewShowing && create) {
                this.splitPane.getParent().doLayout();
                this.splitPane.validate();
                this.updateTableColumnSizes();
            }
            if (this.showPreviewButton.isSelected()) {
                this.splitPane.setRightComponent(this.previewPanel);
                this.splitPane.setDividerLocation(prefs.getInt(DIVIDER_LOCATION_PREF, 400));
            } else {
                this.splitPane.setRightComponent(null);
            }
            this.bookmarksTreeButton.setSelected(this.treeViewShowing);
            this.bookmarksTableButton.setSelected(!this.treeViewShowing);
            this.requestFocusTreeOrTable();
        }
        finally {
            this.dividerLocationUpdating = false;
        }
    }

    private void updateTreeRootContext(BookmarkManagerEvent evt) {
        boolean structureChange;
        boolean bl = structureChange = evt == null || evt.isStructureChange();
        if (structureChange) {
            this.updateNodeTree();
        } else {
            this.nodeTree.updateBookmarkNodes(evt);
            this.notifyTableEntriesChanged(evt);
        }
    }

    private void updateNodeTree() {
        this.nodeTree.updateNodeTree();
        SwingUtilities.invokeLater(this::rebuildTableEntries);
    }

    private void rebuildTableEntries() {
        if (this.tableView != null) {
            BookmarksTable table = this.tableView.getTable();
            int selectedIndex = Math.max(table.getSelectedRow(), 0);
            ((BookmarksTableModel)table.getModel()).setEntries(this.nodeTree.bookmarkNodes(false));
            selectedIndex = Math.min(selectedIndex, table.getRowCount() - 1);
            if (selectedIndex >= 0) {
                table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    private void notifyTableEntriesChanged(BookmarkManagerEvent evt) {
        if (this.tableView != null) {
            BookmarksTable table = this.tableView.getTable();
            BookmarksTableModel model = (BookmarksTableModel)table.getModel();
            for (int i = model.getEntryCount() - 1; i >= 0; --i) {
                if (evt.getChange(model.getEntry(i).getBookmarkInfo()) == null) continue;
                model.fireTableRowsUpdated(i, i);
            }
        }
    }

    private void initTableView() {
        BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this.tableView);
        this.tableView.getTable().getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkInfo selectedBookmark = BookmarksView.this.getTableSelectedBookmark();
                if (selectedBookmark != null) {
                    BookmarkUtils.postOpenEditor(selectedBookmark);
                }
            }
        });
        this.tableView.getTable().getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkInfo selectedBookmark = BookmarksView.this.getTableSelectedBookmark();
                if (selectedBookmark != null) {
                    BookmarkUtils.removeBookmarkUnderLock(selectedBookmark);
                }
            }
        });
        this.tableView.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.tableView.getTable().getSelectionModel().isSelectionEmpty()) {
                this.checkShowPreview();
            }
        });
    }

    private void updateTableColumnSizes() {
        BookmarksTable table = this.tableView.getTable();
        Font font = this.tableView.getFont();
        FontMetrics fm = this.tableView.getFontMetrics(font);
        int maxCharWidth = fm.charWidth('A');
        int editingBorder = 4;
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setPreferredWidth(8 * maxCharWidth + editingBorder);
        TableColumn keyColumn = columnModel.getColumn(1);
        keyColumn.setPreferredWidth(3 * maxCharWidth + editingBorder);
        keyColumn.setMinWidth(keyColumn.getPreferredWidth());
        TableColumn locationColumn = columnModel.getColumn(2);
        Insets insets = this.tableView.getBorder().getBorderInsets(this.tableView);
        int remainingWidth = this.tableView.getParent().getWidth() - insets.left - insets.right;
        remainingWidth -= 2 * columnModel.getColumnMargin();
        remainingWidth -= nameColumn.getPreferredWidth();
        locationColumn.setPreferredWidth(remainingWidth -= keyColumn.getPreferredWidth());
    }

    void requestFocusTreeOrTable() {
        Children rootChildren;
        if (this.treeViewShowing) {
            this.treeView.requestFocusInWindow();
        } else if (this.tableView != null) {
            this.tableView.getTable().requestFocusInWindow();
        }
        Node selectedNode = this.getTreeSelectedNode();
        if (selectedNode == null && (rootChildren = this.explorerManager.getRootContext().getChildren()).getNodesCount() > 0) {
            try {
                this.explorerManager.setSelectedNodes(new Node[]{rootChildren.getNodeAt(0)});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this.requestFocusTreeOrTable();
        return this.isFocusable();
    }

    void refreshView() {
        this.updateTreeRootContext(null);
        this.requestFocusTreeOrTable();
    }

    protected void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.requestFocusTreeOrTable();
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        super.componentDeactivated();
    }

    protected void componentShowing() {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            lockedBookmarkManager.keepOpenProjectsBookmarksLoaded();
        }
        finally {
            lockedBookmarkManager.unlock();
        }
        this.initLayoutAndComponents();
        this.doInitialSelection();
        super.componentShowing();
    }

    void checkShowPreview() {
        FileObject fo;
        BookmarkInfo bookmark;
        BookmarkInfo selectedBookmark = null;
        if (this.treeViewShowing) {
            Node selectedNode = this.getTreeSelectedNode();
            if (selectedNode instanceof BookmarkNode) {
                BookmarkNode bmNode = (BookmarkNode)selectedNode;
                selectedBookmark = bmNode.getBookmarkInfo();
            }
        } else {
            selectedBookmark = this.getTableSelectedBookmark();
        }
        if (selectedBookmark != null && (bookmark = selectedBookmark) != this.displayedBookmarkInfo && (fo = bookmark.getFileBookmarks().getFileObject()) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.getDocument();
                    if (doc == null) {
                        RequestProcessor.getDefault().post(() -> {
                            try {
                                StyledDocument d = ec.openDocument();
                                SwingUtilities.invokeLater(() -> this.showPreview(fo, d, bookmark));
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        });
                    } else {
                        this.showPreview(fo, doc, bookmark);
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    void showPreview(FileObject fo, Document doc, BookmarkInfo bookmarkInfo) {
        if (bookmarkInfo != this.displayedBookmarkInfo) {
            int lineIndex = bookmarkInfo.getCurrentLineIndex();
            String mimeType = (String)doc.getProperty("mimeType");
            if (mimeType != null) {
                JEditorPane pane = new JEditorPane();
                EditorKit editorKit = (EditorKit)MimeLookup.getLookup((String)mimeType).lookup(EditorKit.class);
                pane.setEditorKit(editorKit);
                pane.setDocument(doc);
                pane.setEditable(false);
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)pane);
                JComponent editorComponent = editorUI != null ? editorUI.getExtComponent() : new JScrollPane(pane);
                this.previewPanel.removeAll();
                this.previewPanel.add(editorComponent);
                int offset = BookmarkUtils.lineIndex2Offset(doc, lineIndex);
                pane.setCaretPosition(offset);
                this.displayedBookmarkInfo = bookmarkInfo;
                this.previewPanel.revalidate();
            }
        }
    }

    Node getTreeSelectedNode() {
        Node[] selectedNodes;
        Node selectedNode = null;
        if (this.treeViewShowing && (selectedNodes = this.explorerManager.getSelectedNodes()).length > 0) {
            selectedNode = selectedNodes[0];
        }
        return selectedNode;
    }

    BookmarkInfo getTableSelectedBookmark() {
        BookmarksTable table = this.tableView.getTable();
        int selectedRowIndex = table.convertRowIndexToModel(table.getSelectedRow());
        if (selectedRowIndex != -1 && selectedRowIndex < table.getRowCount()) {
            return ((BookmarksTableModel)table.getModel()).getEntry(selectedRowIndex).getBookmarkInfo();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doInitialSelection() {
        if (this.initialTreeSelectionDone || !this.treeViewShowing) return;
        Node selectedNode = this.getTreeSelectedNode();
        if (selectedNode instanceof BookmarkNode) {
            this.initialTreeSelectionDone = true;
            return;
        } else {
            FileObject selectedFileObject = (FileObject)org.openide.util.Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (selectedFileObject != null) {
                BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                try {
                    ProjectBookmarks projectBookmarks = lockedBookmarkManager.getProjectBookmarks(selectedFileObject);
                    Node bNode = this.nodeTree.findFirstBookmarkNode(projectBookmarks, selectedFileObject);
                    if (bNode == null) return;
                    this.initialTreeSelectionDone = true;
                    try {
                        this.explorerManager.setSelectedNodes(new Node[]{bNode});
                        return;
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return;
                }
                finally {
                    lockedBookmarkManager.unlock();
                }
            } else {
                final Lookup.Result result = org.openide.util.Utilities.actionsGlobalContext().lookupResult(FileObject.class);
                LookupListener onFirstFocus = new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        result.removeLookupListener((LookupListener)this);
                        BookmarksView.this.doInitialSelection();
                    }
                };
                result.addLookupListener(onFirstFocus);
            }
        }
    }

    private JToolBar createLeftToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setOrientation(1);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorderPainted(true);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        JButton refreshButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/refresh.png", (boolean)false));
        refreshButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarRefreshButtonToolTip"));
        refreshButton.addActionListener(e -> this.refreshView());
        toolBar.add(refreshButton);
        toolBar.addSeparator();
        this.bookmarksTreeButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/bookmarksTree.png", (boolean)false));
        this.bookmarksTreeButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarTreeViewButtonToolTip"));
        this.bookmarksTreeButton.addActionListener(e -> {
            if (!this.treeViewShowing) {
                this.setTreeViewVisible(true);
            } else {
                this.bookmarksTableButton.doClick();
            }
        });
        toolBar.add(this.bookmarksTreeButton);
        this.bookmarksTableButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/bookmarksTable.png", (boolean)false));
        this.bookmarksTableButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarTableViewButtonToolTip"));
        this.bookmarksTableButton.addActionListener(e -> {
            if (this.treeViewShowing) {
                this.setTreeViewVisible(false);
            } else {
                this.bookmarksTreeButton.doClick();
            }
        });
        toolBar.add(this.bookmarksTableButton);
        toolBar.addSeparator();
        this.showPreviewButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/preview.png", (boolean)false));
        this.showPreviewButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarShowPreviewButtonToolTip"));
        this.showPreviewButton.setSelected(prefs.getBoolean(PREVIEW_VISIBLE_PREF, true));
        this.showPreviewButton.addActionListener(e -> {
            prefs.putBoolean(PREVIEW_VISIBLE_PREF, this.showPreviewButton.isSelected());
            this.updateSplitPane();
        });
        toolBar.add(this.showPreviewButton);
        return toolBar;
    }

    private static void fixScrollPaneinSplitPaneJDKIssue(Component c) {
        c.setMinimumSize(new Dimension(10, 10));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.checkShowPreview();
        }
    }

    private final class TreeOrTableContainer
    extends JPanel {
        TreeOrTableContainer() {
            this.setLayout(new GridLayout(1, 1));
            BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this);
        }
    }

    private static final class BookmarksTableView
    extends JScrollPane {
        BookmarksTableView() {
            this.setViewportView((Component)((Object)new BookmarksTable()));
        }

        BookmarksTable getTable() {
            return (BookmarksTable)((Object)this.getViewport().getView());
        }
    }
}

