/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.BmcResponse;
import org.netbeans.modules.cloud.oracle.adm.AuditException;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

class ErrorUtils {
    ErrorUtils() {
    }

    private static String getErrorDescription(int code) {
        switch (code) {
            case 400: {
                return Bundle.MSG_Error_400();
            }
            case 401: {
                return Bundle.MSG_Error_401();
            }
            case 404: {
                return Bundle.MSG_Error_404();
            }
            case 412: {
                return Bundle.MSG_Error_412();
            }
            case 429: {
                return Bundle.MSG_Error_429();
            }
            case 500: {
                return Bundle.MSG_Error_429();
            }
        }
        return "Unknown";
    }

    public static void processError(AuditException exc, String errorMessage) {
        StringBuilder sb = new StringBuilder(errorMessage);
        sb.append('\n').append(Bundle.MSG_Error_Code(exc.getStatusCode()));
        sb.append(ErrorUtils.getErrorDescription(exc.getStatusCode()));
        sb.append('\n').append(exc.getMessage());
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)sb.toString()));
    }

    public static void processError(BmcResponse reqest, String errorMessage) {
        StringBuilder sb = new StringBuilder(errorMessage);
        sb.append('\n').append(Bundle.MSG_Error_Code(reqest.get__httpStatusCode__()));
        sb.append(ErrorUtils.getErrorDescription(reqest.get__httpStatusCode__()));
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)sb.toString()));
    }

    public static void processError(BmcException exc, String errorMessage) {
        StringBuilder sb = new StringBuilder(errorMessage);
        sb.append('\n').append(Bundle.MSG_Error_Code(exc.getStatusCode()));
        sb.append(ErrorUtils.getErrorDescription(exc.getStatusCode()));
        sb.append('\n').append(exc.getMessage());
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)sb.toString()));
    }
}

