/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.web.browser.api.ResizeOption;
import org.netbeans.modules.web.browser.api.ResizeOptions;
import org.netbeans.modules.web.browser.ui.BrowserResizeButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class ResizeOptionsCustomizer
extends JPanel {
    private final TableModel model;
    private final ArrayList<ResizeOption> options = new ArrayList<ResizeOption>(ResizeOptions.getDefault().loadAll());
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnNew;
    private JButton btnRemove;
    private JLabel lblTable;
    private JScrollPane scrollTable;
    private JTable tblOptions;

    public ResizeOptionsCustomizer() {
        this.initComponents();
        this.model = new TableModel();
        this.tblOptions.setModel(this.model);
        this.tblOptions.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResizeOptionsCustomizer.this.enableButtons();
            }
        });
        this.tblOptions.getSelectionModel().setSelectionMode(0);
        this.enableButtons();
        DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value instanceof ResizeOption) {
                    Icon icon = BrowserResizeButton.toIcon((ResizeOption)value);
                    this.setIcon(icon);
                    this.setHorizontalAlignment(0);
                }
            }
        };
        this.tblOptions.setDefaultRenderer(ResizeOption.class, colorRenderer);
        JComboBox<Object> combo = new JComboBox<Object>();
        combo.addItem((Object)ResizeOption.Type.DESKTOP);
        combo.addItem((Object)ResizeOption.Type.TABLET_LANDSCAPE);
        combo.addItem((Object)ResizeOption.Type.SMARTPHONE_PORTRAIT);
        combo.addItem((Object)ResizeOption.Type.SMARTPHONE_LANDSCAPE);
        combo.addItem((Object)ResizeOption.Type.SMARTPHONE_PORTRAIT);
        combo.addItem((Object)ResizeOption.Type.WIDESCREEN);
        combo.addItem((Object)ResizeOption.Type.NETBOOK);
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component res = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(null);
                this.setIcon(BrowserResizeButton.toIcon((ResizeOption.Type)((Object)value)));
                this.setHorizontalAlignment(0);
                return res;
            }
        });
        this.tblOptions.setDefaultEditor(ResizeOption.class, new DefaultCellEditor(combo));
        this.tblOptions.setRowHeight(combo.getPreferredSize().height);
    }

    private void initComponents() {
        this.lblTable = new JLabel();
        this.scrollTable = new JScrollPane();
        this.tblOptions = new JTable();
        this.btnNew = new JButton();
        this.btnRemove = new JButton();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.lblTable.setText(NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"ResizeOptionsCustomizer.lblTable.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lblTable, gridBagConstraints);
        this.scrollTable.setViewportView(this.tblOptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollTable, gridBagConstraints);
        this.btnNew.setText(NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"ResizeOptionsCustomizer.btnNew.text"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResizeOptionsCustomizer.this.btnNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)this.btnNew, gridBagConstraints);
        this.btnRemove.setText(NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"ResizeOptionsCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResizeOptionsCustomizer.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 15, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnMoveUp.setText(NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"ResizeOptionsCustomizer.btnMoveUp.text"));
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResizeOptionsCustomizer.this.btnMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.add((Component)this.btnMoveUp, gridBagConstraints);
        this.btnMoveDown.setText(NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"ResizeOptionsCustomizer.btnMoveDown.text"));
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResizeOptionsCustomizer.this.btnMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 15, 0, 0);
        this.add((Component)this.btnMoveDown, gridBagConstraints);
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        ResizeOption newOption = ResizeOption.create(ResizeOption.Type.CUSTOM, NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Lbl_DefaultResizeDisplayName"), 1024, 768, true, false);
        this.options.add(newOption);
        this.model.fireTableRowsInserted(this.options.size() - 1, this.options.size() - 1);
        this.tblOptions.getSelectionModel().setSelectionInterval(this.options.size() - 1, this.options.size() - 1);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        int selIndex = this.tblOptions.getSelectedRow();
        if (selIndex < 0) {
            return;
        }
        ResizeOption ro = this.options.get(selIndex);
        if (ro.isDefault()) {
            return;
        }
        this.options.remove(selIndex);
        this.model.fireTableRowsDeleted(selIndex, selIndex);
        selIndex = Math.min(selIndex, this.options.size() - 1);
        this.tblOptions.getSelectionModel().setSelectionInterval(selIndex, selIndex);
    }

    private void btnMoveUpActionPerformed(ActionEvent evt) {
        this.switchRows(-1);
    }

    private void btnMoveDownActionPerformed(ActionEvent evt) {
        this.switchRows(1);
    }

    private void switchRows(int direction) {
        int selIndex = this.tblOptions.getSelectedRow();
        if (selIndex < 0) {
            return;
        }
        ResizeOption current = this.options.get(selIndex);
        ResizeOption next = this.options.get(selIndex + direction);
        this.options.set(selIndex + direction, current);
        this.options.set(selIndex, next);
        int index1 = direction < 0 ? selIndex + direction : selIndex;
        int index2 = direction < 0 ? selIndex : selIndex + direction;
        this.model.fireTableRowsUpdated(index1, index2);
        this.tblOptions.getSelectionModel().setSelectionInterval(selIndex + direction, selIndex + direction);
    }

    public boolean showCustomizer() {
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Title_CUSTOMIZE_WINDOW_SETTINGS"), true, -1, null, null);
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.web.browser.ui.ResizeOptionsCustomizer"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.setVisible(true);
        return descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    List<ResizeOption> getResizeOptions() {
        return new ArrayList<ResizeOption>(this.options);
    }

    private void enableButtons() {
        int selIndex = this.tblOptions.getSelectedRow();
        ResizeOption ro = selIndex < 0 ? null : this.options.get(selIndex);
        this.btnRemove.setEnabled(null != ro && !ro.isDefault());
        this.btnMoveUp.setEnabled(selIndex > 0);
        this.btnMoveDown.setEnabled(selIndex >= 0 && selIndex < this.tblOptions.getRowCount() - 1);
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        @Override
        public int getRowCount() {
            return ResizeOptionsCustomizer.this.options.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ResizeOption ro = (ResizeOption)ResizeOptionsCustomizer.this.options.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ro;
                }
                case 1: {
                    return ro.getDisplayName();
                }
                case 2: {
                    return ro.getWidth();
                }
                case 3: {
                    return ro.getHeight();
                }
                case 4: {
                    return ro.isShowInToolbar();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (0 == columnIndex) {
                return ResizeOption.class;
            }
            if (4 == columnIndex) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Col_TYPE");
                }
                case 1: {
                    return NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Col_NAME");
                }
                case 2: {
                    return NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Col_WIDTH");
                }
                case 3: {
                    return NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Col_HEIGHT");
                }
                case 4: {
                    return NbBundle.getMessage(ResizeOptionsCustomizer.class, (String)"Col_TOOLBAR");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (null == aValue) {
                return;
            }
            ResizeOption current = (ResizeOption)ResizeOptionsCustomizer.this.options.get(rowIndex);
            ResizeOption.Type type = current.getType();
            String name = current.getDisplayName();
            int width = current.getWidth();
            int height = current.getHeight();
            boolean toolbar = current.isShowInToolbar();
            boolean isDefault = current.isDefault();
            boolean doSetValue = true;
            switch (columnIndex) {
                case 0: {
                    if (!(aValue instanceof ResizeOption.Type)) break;
                    type = (ResizeOption.Type)((Object)aValue);
                    break;
                }
                case 1: {
                    name = aValue.toString().trim();
                    if (!name.isEmpty()) break;
                    doSetValue = false;
                    break;
                }
                case 2: {
                    int num = -1;
                    try {
                        num = Integer.parseInt(aValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (num > 0) {
                        width = num;
                        break;
                    }
                    doSetValue = false;
                    break;
                }
                case 3: {
                    int num = -1;
                    try {
                        num = Integer.parseInt(aValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (num > 0) {
                        height = num;
                        break;
                    }
                    doSetValue = false;
                    break;
                }
                case 4: {
                    if (!(aValue instanceof Boolean)) break;
                    toolbar = (Boolean)aValue;
                }
            }
            if (doSetValue) {
                ResizeOption newOption = ResizeOption.create(type, name, width, height, toolbar, isDefault);
                ResizeOptionsCustomizer.this.options.set(rowIndex, newOption);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }
    }
}

