/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.intent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.intent.Callback;
import org.netbeans.api.intent.Intent;
import org.netbeans.modules.intent.CallbackResult;
import org.netbeans.modules.intent.IntentHandler;
import org.netbeans.modules.intent.SettableResult;

public final class IntentAction {
    private final Intent intent;
    private final IntentHandler delegate;

    IntentAction(Intent intent, IntentHandler delegate) {
        this.intent = intent;
        this.delegate = delegate;
    }

    int getPosition() {
        return this.delegate.getPosition();
    }

    public void execute(final @NullAllowed Callback callback) {
        IntentHandler.RP.post(new Runnable(){

            @Override
            public void run() {
                CallbackResult result = callback == null ? null : new CallbackResult(callback);
                IntentAction.this.delegate.handle(IntentAction.this.intent, result);
            }
        });
    }

    @NonNull
    public Future<Object> execute() {
        return IntentHandler.RP.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SettableResult result = new SettableResult();
                IntentAction.this.delegate.handle(IntentAction.this.intent, result);
                if (result.getException() != null) {
                    throw result.getException();
                }
                return result.getResult();
            }
        });
    }

    @NonNull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @NonNull
    public String getIcon() {
        return this.delegate.getIcon();
    }
}

