/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.diff.tree.RecursiveDiffer;
import org.netbeans.modules.diff.tree.TreeDiffViewerTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class RecursiveDiffAction
extends NodeAction
implements ActionListener {
    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodes) {
        List<FileObject> dirObjects = this.extractDirectories(nodes);
        if (dirObjects.size() != 2) {
            return;
        }
        RecursiveDiffer differ = new RecursiveDiffer(dirObjects.get(0), dirObjects.get(1));
        TreeDiffViewerTopComponent tdvtc = new TreeDiffViewerTopComponent(differ);
        tdvtc.open();
        tdvtc.requestActive();
        differ.startScan();
    }

    protected boolean enable(Node[] nodes) {
        return this.extractDirectories(nodes).size() == 2;
    }

    private List<FileObject> extractDirectories(Node[] nodes) {
        ArrayList<FileObject> dirObjects = new ArrayList<FileObject>(nodes.length);
        for (Node n : nodes) {
            FileObject backingFile = (FileObject)n.getLookup().lookup(FileObject.class);
            if (backingFile == null || !backingFile.isFolder()) continue;
            dirObjects.add(backingFile);
        }
        return dirObjects;
    }

    public String getName() {
        return NbBundle.getMessage(RecursiveDiffAction.class, (String)"CTL_RecursiveDiffAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.diff.tree.RecursiveDiffAction");
    }
}

