/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.tree.ExclusionPattern;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DiffModuleConfig {
    private static final Logger LOG = Logger.getLogger(DiffModuleConfig.class.getName());
    private static final String PREF_IGNORE_LEADINGTRAILING_WHITESPACE = "ignoreWhitespace";
    private static final String PREF_IGNORE_INNER_WHITESPACE = "ignoreInnerWhitespace";
    private static final String PREF_IGNORE_CASE = "ignoreCase";
    private static final String PREF_ADDED_COLOR = "addedColor";
    private static final String PREF_CHANGED_COLOR = "changedColor";
    private static final String PREF_DELETED_COLOR = "deletedColor";
    private static final String PREF_MERGE_UNRESOLVED_COLOR = "merge.unresolvedColor";
    private static final String PREF_MERGE_APPLIED_COLOR = "merge.appliedColor";
    private static final String PREF_MERGE_NOTAPPLIED_COLOR = "merge.notappliedColor";
    private static final String PREF_SIDEBAR_DELETED_COLOR = "sidebar.deletedColor";
    private static final String PREF_SIDEBAR_CHANGED_COLOR = "sidebar.changedColor";
    private static final String PREF_TREE_EXCLUSION_LIST = "tree.exclusionList";
    private static final String DEFAULT_EXCLUSION_LIST = "<exclusionList version='1'></exclusionList>";
    private static final String ELE_EXCLUSION_LIST = "exclusionList";
    private static final String ELE_EXCLUSION_PATTERN = "exclusionPattern";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_VALUE_VERSION_1 = "1";
    private static final String ATTR_VALUE_DEFAULT = "1";
    private static final DiffModuleConfig INSTANCE = new DiffModuleConfig();
    private final Color defaultAddedColor;
    private final Color defaultChangedColor;
    private final Color defaultDeletedColor;
    private final Color defaultAppliedColor;
    private final Color defaultNotAppliedColor;
    private final Color defaultUnresolvedColor;
    private final Color defaultSidebarDeletedColor;
    private final Color defaultSidebarChangedColor;
    private final DocumentBuilder documentBuilder;

    public static DiffModuleConfig getDefault() {
        return INSTANCE;
    }

    private DiffModuleConfig() {
        Color c = UIManager.getColor("nb.diff.added.color");
        if (null == c) {
            c = new Color(180, 255, 180);
        }
        this.defaultAddedColor = c;
        c = UIManager.getColor("nb.diff.changed.color");
        if (null == c) {
            c = new Color(160, 200, 255);
        }
        this.defaultChangedColor = c;
        c = UIManager.getColor("nb.diff.deleted.color");
        if (null == c) {
            c = new Color(255, 160, 180);
        }
        this.defaultDeletedColor = c;
        c = UIManager.getColor("nb.diff.applied.color");
        if (null == c) {
            c = new Color(180, 255, 180);
        }
        this.defaultAppliedColor = c;
        c = UIManager.getColor("nb.diff.notapplied.color");
        if (null == c) {
            c = new Color(160, 200, 255);
        }
        this.defaultNotAppliedColor = c;
        c = UIManager.getColor("nb.diff.unresolved.color");
        if (null == c) {
            c = new Color(255, 160, 180);
        }
        this.defaultUnresolvedColor = c;
        c = UIManager.getColor("nb.diff.sidebar.deleted.color");
        if (null == c) {
            c = new Color(255, 225, 232);
        }
        this.defaultSidebarDeletedColor = c;
        c = UIManager.getColor("nb.diff.sidebar.changed.color");
        if (null == c) {
            c = new Color(233, 241, 255);
        }
        this.defaultSidebarChangedColor = c;
        DocumentBuilder dbPrep = null;
        try {
            dbPrep = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.log(Level.WARNING, "Failed to build document builder", ex);
        }
        this.documentBuilder = dbPrep;
    }

    public Color getAddedColor() {
        return this.getColor(PREF_ADDED_COLOR, this.defaultAddedColor);
    }

    public Color getDefaultAddedColor() {
        return this.defaultAddedColor;
    }

    public Color getChangedColor() {
        return this.getColor(PREF_CHANGED_COLOR, this.defaultChangedColor);
    }

    public Color getDefaultChangedColor() {
        return this.defaultChangedColor;
    }

    public Color getDeletedColor() {
        return this.getColor(PREF_DELETED_COLOR, this.defaultDeletedColor);
    }

    public Color getDefaultDeletedColor() {
        return this.defaultDeletedColor;
    }

    public Color getAppliedColor() {
        return this.getColor(PREF_MERGE_APPLIED_COLOR, this.defaultAppliedColor);
    }

    public Color getDefaultAppliedColor() {
        return this.defaultAppliedColor;
    }

    public Color getNotAppliedColor() {
        return this.getColor(PREF_MERGE_NOTAPPLIED_COLOR, this.defaultNotAppliedColor);
    }

    public Color getDefaultNotAppliedColor() {
        return this.defaultNotAppliedColor;
    }

    public Color getUnresolvedColor() {
        return this.getColor(PREF_MERGE_UNRESOLVED_COLOR, this.defaultUnresolvedColor);
    }

    public Color getDefaultUnresolvedColor() {
        return this.defaultUnresolvedColor;
    }

    public Color getSidebarDeletedColor() {
        return this.getColor(PREF_SIDEBAR_DELETED_COLOR, this.defaultSidebarDeletedColor);
    }

    public Color getDefaultSidebarDeletedColor() {
        return this.defaultSidebarDeletedColor;
    }

    public Color getSidebarChangedColor() {
        return this.getColor(PREF_SIDEBAR_CHANGED_COLOR, this.defaultSidebarChangedColor);
    }

    public Color getDefaultSidebarChangedColor() {
        return this.defaultSidebarChangedColor;
    }

    public void setChangedColor(Color color) {
        this.putColor(PREF_CHANGED_COLOR, this.defaultChangedColor.equals(color) ? null : color);
    }

    public void setAddedColor(Color color) {
        this.putColor(PREF_ADDED_COLOR, this.defaultAddedColor.equals(color) ? null : color);
    }

    public void setDeletedColor(Color color) {
        this.putColor(PREF_DELETED_COLOR, this.defaultDeletedColor.equals(color) ? null : color);
    }

    public void setNotAppliedColor(Color color) {
        this.putColor(PREF_MERGE_NOTAPPLIED_COLOR, this.defaultNotAppliedColor.equals(color) ? null : color);
    }

    public void setAppliedColor(Color color) {
        this.putColor(PREF_MERGE_APPLIED_COLOR, this.defaultAppliedColor.equals(color) ? null : color);
    }

    public void setUnresolvedColor(Color color) {
        this.putColor(PREF_MERGE_UNRESOLVED_COLOR, this.defaultUnresolvedColor.equals(color) ? null : color);
    }

    public void setSidebarDeletedColor(Color color) {
        this.putColor(PREF_SIDEBAR_DELETED_COLOR, this.defaultSidebarDeletedColor.equals(color) ? null : color);
    }

    public void setSidebarChangedColor(Color color) {
        this.putColor(PREF_SIDEBAR_CHANGED_COLOR, this.defaultSidebarChangedColor.equals(color) ? null : color);
    }

    private void putColor(String key, Color color) {
        if (color == null) {
            this.getPreferences().remove(key);
        } else {
            this.getPreferences().putInt(key, color.getRGB());
        }
    }

    private Color getColor(String key, Color defaultColor) {
        int rgb = this.getPreferences().getInt(key, defaultColor.getRGB());
        return new Color(rgb);
    }

    public DiffProvider getDefaultDiffProvider() {
        Collection providers = Lookup.getDefault().lookup(new Lookup.Template(DiffProvider.class)).allInstances();
        DiffProvider provider = null;
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            DiffProvider p;
            provider = p = (DiffProvider)iterator.next();
            if (!(p instanceof BuiltInDiffProvider)) continue;
            ((BuiltInDiffProvider)p).setOptions(this.getOptions());
            break;
        }
        return provider;
    }

    public void setOptions(BuiltInDiffProvider.Options options) {
        this.getPreferences().putBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, options.ignoreLeadingAndtrailingWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_INNER_WHITESPACE, options.ignoreInnerWhitespace);
        this.getPreferences().putBoolean(PREF_IGNORE_CASE, options.ignoreCase);
        this.getBuiltinProvider().setOptions(options);
    }

    public BuiltInDiffProvider.Options getOptions() {
        BuiltInDiffProvider.Options options = new BuiltInDiffProvider.Options();
        options.ignoreLeadingAndtrailingWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_LEADINGTRAILING_WHITESPACE, true);
        options.ignoreInnerWhitespace = this.getPreferences().getBoolean(PREF_IGNORE_INNER_WHITESPACE, false);
        options.ignoreCase = this.getPreferences().getBoolean(PREF_IGNORE_CASE, false);
        return options;
    }

    public List<ExclusionPattern> getTreeExclusionList() {
        ArrayList<ExclusionPattern> result = new ArrayList<ExclusionPattern>();
        try {
            String version;
            String encodedList = this.getPreferences().get(PREF_TREE_EXCLUSION_LIST, null);
            if (encodedList == null) {
                return List.of();
            }
            Document doc = this.documentBuilder.parse(new InputSource(new StringReader(encodedList)));
            switch (version = doc.getDocumentElement().getAttribute(ATTR_VERSION)) {
                case "1": {
                    NodeList pathPatterns = doc.getDocumentElement().getElementsByTagName(ELE_EXCLUSION_PATTERN);
                    for (int i = 0; i < pathPatterns.getLength(); ++i) {
                        Element pathPattern = (Element)pathPatterns.item(i);
                        ExclusionPattern pattern = new ExclusionPattern();
                        pattern.setPattern(pathPattern.getTextContent());
                        String type = pathPattern.getAttribute("TYPE");
                        if (!type.isEmpty()) {
                            pattern.setType(ExclusionPattern.ExclusionType.valueOf(type));
                        }
                        result.add(pattern);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unkown exclusion list version");
                }
            }
        }
        catch (IOException | IllegalArgumentException | SAXException ex) {
            LOG.log(Level.WARNING, "Failed to parse TreeExclusionList");
        }
        return result;
    }

    public void setTreeExclusionList(List<ExclusionPattern> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            this.getPreferences().remove(PREF_TREE_EXCLUSION_LIST);
            return;
        }
        try {
            Document doc = this.documentBuilder.newDocument();
            Element exclusionList = doc.createElement(ELE_EXCLUSION_LIST);
            exclusionList.setAttribute(ATTR_VERSION, "1");
            doc.appendChild(exclusionList);
            for (ExclusionPattern p : patterns) {
                Element pattern = doc.createElement(ELE_EXCLUSION_PATTERN);
                pattern.setAttribute(ATTR_TYPE, p.getType().name());
                pattern.setTextContent(p.getPattern());
                exclusionList.appendChild(pattern);
            }
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            StringWriter result = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(result));
            this.getPreferences().put(PREF_TREE_EXCLUSION_LIST, result.toString());
        }
        catch (TransformerException ex) {
            LOG.log(Level.WARNING, "Failed to create TreeExclusionList");
        }
    }

    private BuiltInDiffProvider getBuiltinProvider() {
        Collection diffs = Lookup.getDefault().lookupAll(DiffProvider.class);
        for (DiffProvider diff : diffs) {
            if (!(diff instanceof BuiltInDiffProvider)) continue;
            return (BuiltInDiffProvider)diff;
        }
        throw new IllegalStateException("No builtin diff provider");
    }

    public boolean isUseInteralDiff() {
        return true;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(DiffModuleConfig.class);
    }

    public int getSpacesPerTabFor(String mimeType) {
        int spacesPerTab = 1;
        Preferences pref = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        if (pref != null) {
            spacesPerTab = pref.getInt("tab-size", 1);
        }
        return spacesPerTab;
    }
}

