/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.terminal;

import java.io.IOException;
import java.util.Arrays;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.terminal.Terminal;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class TerminalRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Terminal terminal = (Terminal)component;
        if (terminal.isCommandRequest()) {
            this.handleCommand(context, terminal);
        } else {
            this.encodeMarkup(context, terminal);
            this.encodeScript(context, terminal);
        }
    }

    protected void encodeMarkup(FacesContext context, Terminal terminal) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = terminal.getClientId(context);
        String style = terminal.getStyle();
        String styleClass = terminal.getStyleClass();
        styleClass = styleClass == null ? "ui-terminal ui-widget-content ui-corner-all" : "ui-terminal ui-widget-content ui-corner-all " + styleClass;
        String welcomeMessage = terminal.getWelcomeMessage();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)terminal);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (welcomeMessage != null) {
            writer.startElement("div", null);
            writer.writeText((Object)welcomeMessage, null);
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-terminal-content", null);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-terminal-prompt", null);
        writer.writeText((Object)terminal.getPrompt(), null);
        writer.endElement("span");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("class", (Object)"ui-terminal-input", null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Terminal terminal) throws IOException {
        String clientId = terminal.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Terminal", terminal.resolveWidgetVar(), clientId);
        wb.finish();
    }

    protected void handleCommand(FacesContext context, Terminal terminal) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = terminal.getClientId(context);
        String value = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        String[] tokens = value.split(" ");
        String command = tokens[0];
        String[] args = Arrays.copyOfRange(tokens, 1, tokens.length);
        MethodExpression commandHandler = terminal.getCommandHandler();
        String result = (String)commandHandler.invoke(context.getELContext(), new Object[]{command, args});
        writer.write(result);
    }
}

