/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.actions.ImportData;
import org.netbeans.modules.web.jsf.editor.facelets.JsfNamespaceComparator;
import org.netbeans.modules.web.jsf.editor.hints.LibraryDeclarationChecker;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;

class NamespaceProcessor {
    private final HtmlParserResult parserResult;
    private final Snapshot snapshot;
    private final JsfSupport jsfSupport;
    private final ResultCollector resultCollector;
    private final Map<String, Library> supportedLibraries = new HashMap<String, Library>();
    private final List<Library> declaredLibraries;

    NamespaceProcessor(HtmlParserResult parserResult) {
        this.parserResult = parserResult;
        this.snapshot = parserResult.getSnapshot();
        this.jsfSupport = JsfSupportImpl.findFor(this.snapshot.getSource());
        if (this.jsfSupport != null) {
            this.supportedLibraries.putAll(this.jsfSupport.getLibraries());
        }
        this.declaredLibraries = this.getDeclaredLibraries();
        this.resultCollector = new ResultCollector(parserResult);
    }

    ImportData computeImportData() {
        ImportData importData = new ImportData();
        for (Attribute namespaceAttribute : this.resultCollector.getUnusedNamespaces()) {
            importData.addToRemove(namespaceAttribute);
        }
        for (String prefix : this.resultCollector.getUnresolvedPrefixes()) {
            importData.shouldShowNamespacesPanel = true;
            List<ImportData.VariantItem> sortedVariants = this.getSortedVariants(prefix);
            importData.add(new ImportData.DataItem(prefix, sortedVariants, sortedVariants.get(0)));
        }
        return importData;
    }

    private List<Library> getDeclaredLibraries() {
        ArrayList<Library> result = new ArrayList<Library>();
        for (String namespace : this.parserResult.getNamespaces().keySet()) {
            Library lib = (Library)NamespaceUtils.getForNs(this.supportedLibraries, (String)namespace);
            if (lib == null) continue;
            result.add(lib);
        }
        return result;
    }

    private List<ImportData.VariantItem> getSortedVariants(String prefix) {
        ArrayList<ImportData.VariantItem> items = new ArrayList<ImportData.VariantItem>();
        Set namespacesForPrefix = Collections.emptySet();
        Optional<Library> libraryForPrefix = this.supportedLibraries.values().stream().filter(entry -> entry.getDefaultPrefix().equals(prefix)).findFirst();
        if (libraryForPrefix.isPresent()) {
            Library library = libraryForPrefix.get();
            namespacesForPrefix = library.getValidNamespaces();
            namespacesForPrefix.forEach(namespace -> items.add(new ImportData.VariantItem(prefix, (String)namespace, library)));
        }
        ArrayList<String> sortedList = new ArrayList<String>(this.supportedLibraries.keySet());
        sortedList.sort(JsfNamespaceComparator.getInstance());
        sortedList.stream().filter(Predicate.not(namespacesForPrefix::contains)).forEach(additionalNamespaces -> items.add(new ImportData.VariantItem(prefix, (String)additionalNamespaces, this.supportedLibraries.get(additionalNamespaces))));
        return items;
    }

    private class ResultCollector {
        private final Map<String, Boolean> prefixMap = new HashMap<String, Boolean>();
        private final HtmlParserResult parserResult;
        private final NamespaceCollector nsCollector;
        private final ComponentCollector compCollector;
        private final UnresolvedCollector unresolvedCollector;

        private ResultCollector(HtmlParserResult parserResult) {
            this.parserResult = parserResult;
            this.nsCollector = new NamespaceCollector(parserResult);
            this.compCollector = new ComponentCollector(parserResult, this.prefixMap);
            this.unresolvedCollector = new UnresolvedCollector(parserResult);
            this.initialize();
        }

        private void initialize() {
            for (String prefix : this.parserResult.getNamespaces().values()) {
                if (prefix == null) continue;
                this.prefixMap.put(prefix, Boolean.FALSE);
            }
            ElementUtils.visitChildren((Element)this.parserResult.root(), (ElementVisitor)this.compCollector, (ElementType)ElementType.OPEN_TAG);
            for (Library library : NamespaceProcessor.this.declaredLibraries) {
                Node root = JsfUtils.getRoot(this.parserResult, (LibraryInfo)library);
                if (root == null) continue;
                ElementUtils.visitChildren((Element)root, (ElementVisitor)this.compCollector, (ElementType)ElementType.OPEN_TAG);
            }
            ElementUtils.visitChildren((Element)this.parserResult.rootOfUndeclaredTagsParseTree(), (ElementVisitor)this.unresolvedCollector, (ElementType)ElementType.OPEN_TAG);
        }

        public List<Attribute> getUnusedNamespaces() {
            ArrayList<Attribute> toRemove = new ArrayList<Attribute>();
            for (Map.Entry<String, Boolean> prefixEntry : this.prefixMap.entrySet()) {
                if (prefixEntry.getValue().booleanValue()) continue;
                for (Map.Entry<String, String> nsEntry : this.nsCollector.namespaces.entrySet()) {
                    if (!prefixEntry.getKey().equals(nsEntry.getValue())) continue;
                    toRemove.add(this.nsCollector.namespace2Attribute.get(nsEntry.getKey()));
                }
            }
            return toRemove;
        }

        public List<String> getUnresolvedPrefixes() {
            ArrayList<String> prefixes = new ArrayList<String>(this.unresolvedCollector.getUndeclaredPrefixes());
            Collections.sort(prefixes);
            return prefixes;
        }
    }

    private class UnresolvedCollector
    implements ElementVisitor {
        private final HtmlParserResult parserResult;
        private final Set<Named> undeclaredNodes = new HashSet<Named>();

        public UnresolvedCollector(HtmlParserResult result) {
            this.parserResult = result;
        }

        public void visit(Element node) {
            OpenTag openTag = (OpenTag)node;
            this.undeclaredNodes.addAll(LibraryDeclarationChecker.parseForUndeclaredElements(this.parserResult, openTag));
        }

        public Set<String> getUndeclaredPrefixes() {
            HashSet<String> result = new HashSet<String>();
            for (Named named : this.undeclaredNodes) {
                result.add(CharSequenceUtilities.toString((CharSequence)named.namespacePrefix()));
            }
            return result;
        }
    }

    private static class ComponentCollector
    implements ElementVisitor {
        private final Map<String, Boolean> prefixMap;

        public ComponentCollector(HtmlParserResult parserResult, Map<String, Boolean> prefixMap) {
            this.prefixMap = prefixMap;
        }

        public void visit(Element node) {
            OpenTag openTag = (OpenTag)node;
            if (openTag.namespacePrefix() != null) {
                this.prefixMap.put(CharSequenceUtilities.toString((CharSequence)openTag.namespacePrefix()), Boolean.TRUE);
            }
            Collection compAttrs = openTag.attributes(new AttributeFilter(){

                public boolean accepts(Attribute attribute) {
                    if (attribute.unquotedValue() == null) {
                        return false;
                    }
                    CharSequence nsPrefix = attribute.namespacePrefix();
                    return nsPrefix != null;
                }
            });
            for (Attribute attribute : compAttrs) {
                for (Map.Entry<String, Boolean> entry : this.prefixMap.entrySet()) {
                    if (entry.getValue().booleanValue() || !LexerUtils.equals((CharSequence)entry.getKey(), (CharSequence)attribute.namespacePrefix(), (boolean)true, (boolean)true)) continue;
                    entry.setValue(Boolean.TRUE);
                }
            }
        }
    }

    private class NamespaceCollector {
        private final Map<String, String> namespaces;
        private final Map<String, Attribute> namespace2Attribute = new HashMap<String, Attribute>();

        public NamespaceCollector(HtmlParserResult parserResult) {
            this.namespaces = parserResult.getNamespaces();
            this.initializeNs2Attrs(parserResult);
        }

        private void initializeNs2Attrs(HtmlParserResult parserResult) {
            Iterator it = parserResult.getSyntaxAnalyzerResult().getElementsIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (element.type() != ElementType.OPEN_TAG) continue;
                OpenTag tag = (OpenTag)element;
                for (Attribute attr : tag.attributes()) {
                    String key;
                    Attribute attribute;
                    CharSequence value;
                    String attrName = attr.name().toString();
                    if (!attrName.startsWith("xmlns") || (value = attr.unquotedValue()) == null || (attribute = this.namespace2Attribute.get(key = value.toString())) != null) continue;
                    this.namespace2Attribute.put(key, attr);
                }
            }
        }
    }
}

