/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha;

import java.awt.EventQueue;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.mocha.Bundle;
import org.netbeans.modules.selenium2.webclient.mocha.CustomizerMocha;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaJSPreferences;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaSeleniumPreferences;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;

public class CustomizerMochaPanel
implements CustomizerPanelImplementation {
    public static final String IDENTIFIER = "Mocha";
    private final Project project;
    private final boolean isSelenium;
    private volatile CustomizerMocha customizerMocha;

    public CustomizerMochaPanel(Project project, boolean isSelenium) {
        assert (project != null);
        this.project = project;
        this.isSelenium = isSelenium;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.CustomizerMochaPanel_displayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    public synchronized CustomizerMocha getComponent() {
        if (this.customizerMocha == null) {
            this.customizerMocha = new CustomizerMocha(this.project, this.isSelenium);
        }
        return this.customizerMocha;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        return this.getComponent().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getComponent().getWarningMessage();
    }

    public void save() {
        assert (!EventQueue.isDispatchThread());
        assert (this.customizerMocha != null);
        if (this.isSelenium) {
            MochaSeleniumPreferences.setMochaDir(this.project, this.customizerMocha.getMochaInstallFolder());
            MochaSeleniumPreferences.setTimeout(this.project, this.customizerMocha.getTimeout());
        } else {
            MochaJSPreferences.setMochaDir(this.project, this.customizerMocha.getMochaInstallFolder());
            MochaJSPreferences.setTimeout(this.project, this.customizerMocha.getTimeout());
            MochaJSPreferences.setAutoWatch(this.project, this.customizerMocha.getAutoWatch());
        }
    }
}

