/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.WorkRequest;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetWorkRequestResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private Float retryAfter;
    private WorkRequest workRequest;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcClientRequestId", "retryAfter", "workRequest"})
    private GetWorkRequestResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcClientRequestId, Float retryAfter, WorkRequest workRequest) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.retryAfter = retryAfter;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",retryAfter=").append(String.valueOf(this.retryAfter));
        sb.append(",workRequest=").append(String.valueOf((Object)this.workRequest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWorkRequestResponse)) {
            return false;
        }
        GetWorkRequestResponse other = (GetWorkRequestResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.retryAfter, other.retryAfter) && Objects.equals((Object)this.workRequest, (Object)other.workRequest);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.retryAfter == null ? 43 : this.retryAfter.hashCode());
        result = result * 59 + (this.workRequest == null ? 43 : this.workRequest.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetWorkRequestResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcClientRequestId;
        private Float retryAfter;
        private WorkRequest workRequest;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public Builder copy(GetWorkRequestResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.retryAfter(o.getRetryAfter());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcClientRequestId, this.retryAfter, this.workRequest);
        }
    }
}

