/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class QueryBuilderInternalFrame
extends JInternalFrame
implements ActionListener,
KeyListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private boolean DEBUG = false;
    private Object _dragObject = null;
    private DropTarget _dropTarget;
    private JPopupMenu _tableColumnPopup;
    private TableNode _node;
    private QueryBuilder _queryBuilder;
    private QueryBuilderTable _qbTable;
    private QueryBuilderTableModel _queryBuilderTableModel = null;
    private static int _lastX = 0;
    private static int _lastY = 0;

    public QueryBuilderInternalFrame(QueryBuilderTableModel queryBuilderTableModel, QueryBuilder queryBuilder) {
        this._queryBuilderTableModel = queryBuilderTableModel;
        this._queryBuilder = queryBuilder;
        this._node = new TableNode(queryBuilderTableModel.getFullTableName(), queryBuilderTableModel.getCorrName(), this._queryBuilder);
        this.setResizable(true);
        this.setFrameIcon(null);
        this.setIconifiable(false);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                try {
                    QueryBuilderInternalFrame.this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        this.setBackground(Color.white);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.DEBUG) {
            System.out.println(" QBIF : key pressed called. \n");
        }
        this._queryBuilder.handleKeyPress(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void create() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this._qbTable = new QueryBuilderTable(this._queryBuilderTableModel);
        this._qbTable.setBackground(Color.white);
        JScrollPane sp = new JScrollPane(this._qbTable);
        sp.getViewport().setBackground(Color.white);
        mainPanel.add((Component)sp, "Center");
        mainPanel.setBackground(Color.white);
        this.getContentPane().add(mainPanel);
        this.getContentPane().setBackground(Color.white);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this._qbTable, 2, this);
        this._dropTarget = new DropTarget(this._qbTable, 2, this);
        this.pack();
        this.setSize(175, 120);
        this.setVisible(true);
    }

    JPopupMenu createTableColumnPopup() {
        JPopupMenu tableColumnPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"ADD_TO_QUERY"));
        menuItem.addActionListener(this);
        tableColumnPopup.add(menuItem);
        menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"SORT_ASCENDING"));
        menuItem.addActionListener(this);
        tableColumnPopup.add(menuItem);
        menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"SORT_DESCENDING"));
        menuItem.addActionListener(this);
        tableColumnPopup.add(menuItem);
        menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"REMOVE_FILTER"));
        menuItem.addActionListener(this);
        tableColumnPopup.add(menuItem);
        return tableColumnPopup;
    }

    public QueryBuilderTableModel getQueryBuilderTableModel() {
        return this._queryBuilderTableModel;
    }

    public TableNode getNode() {
        return this._node;
    }

    @Override
    public String toString() {
        return "";
    }

    String getTableName() {
        return this._queryBuilderTableModel.getTableName();
    }

    String getTableSpec() {
        return this._queryBuilderTableModel.getTableSpec();
    }

    String getFullTableName() {
        return this._queryBuilderTableModel.getFullTableName();
    }

    static Point getLastLocation() {
        return new Point(_lastX, _lastY);
    }

    static void resetLocation() {
        _lastX = 0;
        _lastY = 0;
    }

    @Override
    public void setLocation(int x, int y) {
        _lastX = x;
        _lastY = y;
        super.setLocation(x, y);
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.DEBUG) {
            JMenuItem source = (JMenuItem)e.getSource();
            String s = "Action event detected.\n    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")";
            System.out.println(s + "\n");
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (this.DEBUG) {
            System.out.println(" Component point " + e.getDragOrigin() + "\n");
        }
        int row = this._qbTable.rowAtPoint(e.getDragOrigin());
        int column = this._qbTable.columnAtPoint(e.getDragOrigin());
        this._dragObject = this;
        if (row < 0 || column < 2) {
            return;
        }
        if (this.DEBUG) {
            System.out.println(" Table row " + row + " Table column " + column + " Object " + this._qbTable.getValueAt(row, column) + "\n");
        }
        String dragTableColumn = this._queryBuilderTableModel.getTableSpec() + "." + (String)this._qbTable.getValueAt(row, column);
        e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(dragTableColumn), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            if (this.DEBUG) {
                System.out.println(" Component point " + e.getLocation() + "\n");
            }
            int row = this._qbTable.rowAtPoint(e.getLocation());
            int column = this._qbTable.columnAtPoint(e.getLocation());
            if (row < 0 || column < 2 || this._dragObject == this) {
                String msg = NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"DRAG_AND_DROP_COLUMNS");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                this._dragObject = null;
                return;
            }
            if (this.DEBUG) {
                System.out.println(" Table row " + row + " Table column " + column + " Object " + this._qbTable.getValueAt(row, column) + "\n");
            }
            String dropTableColumn = this._queryBuilderTableModel.getTableSpec() + "." + (String)this._qbTable.getValueAt(row, column);
            DataFlavor stringFlavor = DataFlavor.stringFlavor;
            Transferable tr = e.getTransferable();
            if (e.isDataFlavorSupported(stringFlavor) && e.isLocalTransfer()) {
                String dragTableColumn = (String)tr.getTransferData(stringFlavor);
                if (this.DEBUG) {
                    System.out.println("dragTableColumnName = " + dragTableColumn + "\n");
                    System.out.println("dropTableColumnName = " + dropTableColumn + "\n");
                }
                String[] rel = new String[4];
                String[] res = dragTableColumn.split("\\.");
                if (res.length == 2) {
                    rel[0] = res[0];
                    rel[1] = res[1];
                } else if (res.length == 3) {
                    rel[0] = res[0] + "." + res[1];
                    rel[1] = res[2];
                } else {
                    String msg = NbBundle.getMessage(QueryBuilderInternalFrame.class, (String)"DRAG_AND_DROP_COLUMNS");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    this._dragObject = null;
                    return;
                }
                rel[2] = this._queryBuilderTableModel.getTableSpec();
                rel[3] = (String)this._qbTable.getValueAt(row, column);
                if (this.DEBUG) {
                    System.out.println(" rel[0] = " + rel[0] + " rel[1] = " + rel[1] + " rel[2] = " + rel[2] + " rel[3] = " + rel[3] + "\n");
                }
                Predicate pred = SQLQueryFactory.createPredicate(rel);
                this._queryBuilder._queryModel.addOrCreateAndExpression(pred);
                if (this.DEBUG) {
                    System.out.println(this._queryBuilder._queryModel.getWhere().genText(null));
                }
                this._queryBuilder.generate();
                e.acceptDrop(2);
                e.dropComplete(true);
            } else {
                e.rejectDrop();
            }
            this._dragObject = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    class TableColumnPopupListener
    extends MouseAdapter {
        TableColumnPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                QueryBuilderInternalFrame.this._tableColumnPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

