/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    @Override
    protected void add(SearchType searchType) {
        boolean ok = false;
        for (Class clazz : searchType.getSearchTypeClasses()) {
            if (clazz != FileObject.class) continue;
            ok = true;
            break;
        }
        if (ok) {
            super.add(searchType);
        }
    }

    @Override
    public void doSearch() {
        FileObject[] rootFolders = this.getFileFolders();
        if (rootFolders == null) {
            return;
        }
        for (FileObject rootFolder : rootFolders) {
            if (this.scanFolder(rootFolder)) continue;
            return;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodes = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[0]));
        ArrayList<FileObject> children = new ArrayList<FileObject>(nodes.length);
        for (Node node : nodes) {
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder == null) continue;
            children.add(dataFolder.getPrimaryFile());
        }
        return children.toArray(new FileObject[0]);
    }

    private boolean scanFolder(FileObject folder) {
        for (FileObject child : folder.getChildren()) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (child.isFolder()) {
                if (this.scanFolder(child)) continue;
                return false;
            }
            this.processSearchObject(child);
        }
        return true;
    }

    @Override
    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dnfe) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : nodes) {
            if (FileObjectSearchGroup.hasParent(node, nodes)) continue;
            ret.add(node);
        }
        return ret.toArray(new Node[0]);
    }

    private static boolean hasParent(Node node, Node[] nodes) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            for (Node n : nodes) {
                if (!n.equals((Object)parent)) continue;
                return true;
            }
        }
        return false;
    }
}

