/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.oracle.bmc.artifacts.Artifacts;
import com.oracle.bmc.artifacts.model.ContainerImageSignatureSummary;
import com.oracle.bmc.artifacts.model.ContainerImageSummary;
import com.oracle.bmc.artifacts.model.ContainerRepositorySummary;
import com.oracle.bmc.artifacts.model.GenericArtifactSummary;
import com.oracle.bmc.artifacts.model.RepositorySummary;
import com.oracle.bmc.artifacts.requests.ListContainerImageSignaturesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerImagesRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.requests.ListGenericArtifactsRequest;
import com.oracle.bmc.artifacts.requests.ListRepositoriesRequest;
import com.oracle.bmc.artifacts.responses.ListContainerImageSignaturesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerImagesResponse;
import com.oracle.bmc.artifacts.responses.ListContainerRepositoriesResponse;
import com.oracle.bmc.artifacts.responses.ListGenericArtifactsResponse;
import com.oracle.bmc.artifacts.responses.ListRepositoriesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArtifactsPaginators {
    private final Artifacts client;

    public ArtifactsPaginators(Artifacts client) {
        this.client = client;
    }

    public Iterable<ListContainerImageSignaturesResponse> listContainerImageSignaturesResponseIterator(final ListContainerImageSignaturesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerImageSignaturesRequest.Builder>(){

            @Override
            public ListContainerImageSignaturesRequest.Builder get() {
                return ListContainerImageSignaturesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImageSignaturesResponse, String>(){

            @Override
            public String apply(ListContainerImageSignaturesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImageSignaturesRequest.Builder>, ListContainerImageSignaturesRequest>(){

            @Override
            public ListContainerImageSignaturesRequest apply(RequestBuilderAndToken<ListContainerImageSignaturesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerImageSignaturesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImageSignaturesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerImageSignaturesRequest, ListContainerImageSignaturesResponse>(){

            @Override
            public ListContainerImageSignaturesResponse apply(ListContainerImageSignaturesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImageSignatures(request);
            }
        });
    }

    public Iterable<ContainerImageSignatureSummary> listContainerImageSignaturesRecordIterator(final ListContainerImageSignaturesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerImageSignaturesRequest.Builder>(){

            @Override
            public ListContainerImageSignaturesRequest.Builder get() {
                return ListContainerImageSignaturesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImageSignaturesResponse, String>(){

            @Override
            public String apply(ListContainerImageSignaturesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImageSignaturesRequest.Builder>, ListContainerImageSignaturesRequest>(){

            @Override
            public ListContainerImageSignaturesRequest apply(RequestBuilderAndToken<ListContainerImageSignaturesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerImageSignaturesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImageSignaturesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerImageSignaturesRequest, ListContainerImageSignaturesResponse>(){

            @Override
            public ListContainerImageSignaturesResponse apply(ListContainerImageSignaturesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImageSignatures(request);
            }
        }, (Function)new Function<ListContainerImageSignaturesResponse, List<ContainerImageSignatureSummary>>(){

            @Override
            public List<ContainerImageSignatureSummary> apply(ListContainerImageSignaturesResponse response) {
                return response.getContainerImageSignatureCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerImagesResponse> listContainerImagesResponseIterator(final ListContainerImagesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerImagesRequest.Builder>(){

            @Override
            public ListContainerImagesRequest.Builder get() {
                return ListContainerImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, String>(){

            @Override
            public String apply(ListContainerImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImagesRequest.Builder>, ListContainerImagesRequest>(){

            @Override
            public ListContainerImagesRequest apply(RequestBuilderAndToken<ListContainerImagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerImagesRequest, ListContainerImagesResponse>(){

            @Override
            public ListContainerImagesResponse apply(ListContainerImagesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImages(request);
            }
        });
    }

    public Iterable<ContainerImageSummary> listContainerImagesRecordIterator(final ListContainerImagesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerImagesRequest.Builder>(){

            @Override
            public ListContainerImagesRequest.Builder get() {
                return ListContainerImagesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, String>(){

            @Override
            public String apply(ListContainerImagesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerImagesRequest.Builder>, ListContainerImagesRequest>(){

            @Override
            public ListContainerImagesRequest apply(RequestBuilderAndToken<ListContainerImagesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerImagesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerImagesRequest, ListContainerImagesResponse>(){

            @Override
            public ListContainerImagesResponse apply(ListContainerImagesRequest request) {
                return ArtifactsPaginators.this.client.listContainerImages(request);
            }
        }, (Function)new Function<ListContainerImagesResponse, List<ContainerImageSummary>>(){

            @Override
            public List<ContainerImageSummary> apply(ListContainerImagesResponse response) {
                return response.getContainerImageCollection().getItems();
            }
        });
    }

    public Iterable<ListContainerRepositoriesResponse> listContainerRepositoriesResponseIterator(final ListContainerRepositoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListContainerRepositoriesRequest.Builder>(){

            @Override
            public ListContainerRepositoriesRequest.Builder get() {
                return ListContainerRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, String>(){

            @Override
            public String apply(ListContainerRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder>, ListContainerRepositoriesRequest>(){

            @Override
            public ListContainerRepositoriesRequest apply(RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse>(){

            @Override
            public ListContainerRepositoriesResponse apply(ListContainerRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listContainerRepositories(request);
            }
        });
    }

    public Iterable<ContainerRepositorySummary> listContainerRepositoriesRecordIterator(final ListContainerRepositoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListContainerRepositoriesRequest.Builder>(){

            @Override
            public ListContainerRepositoriesRequest.Builder get() {
                return ListContainerRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, String>(){

            @Override
            public String apply(ListContainerRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder>, ListContainerRepositoriesRequest>(){

            @Override
            public ListContainerRepositoriesRequest apply(RequestBuilderAndToken<ListContainerRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListContainerRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListContainerRepositoriesRequest, ListContainerRepositoriesResponse>(){

            @Override
            public ListContainerRepositoriesResponse apply(ListContainerRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listContainerRepositories(request);
            }
        }, (Function)new Function<ListContainerRepositoriesResponse, List<ContainerRepositorySummary>>(){

            @Override
            public List<ContainerRepositorySummary> apply(ListContainerRepositoriesResponse response) {
                return response.getContainerRepositoryCollection().getItems();
            }
        });
    }

    public Iterable<ListGenericArtifactsResponse> listGenericArtifactsResponseIterator(final ListGenericArtifactsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGenericArtifactsRequest.Builder>(){

            @Override
            public ListGenericArtifactsRequest.Builder get() {
                return ListGenericArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGenericArtifactsResponse, String>(){

            @Override
            public String apply(ListGenericArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGenericArtifactsRequest.Builder>, ListGenericArtifactsRequest>(){

            @Override
            public ListGenericArtifactsRequest apply(RequestBuilderAndToken<ListGenericArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGenericArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGenericArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGenericArtifactsRequest, ListGenericArtifactsResponse>(){

            @Override
            public ListGenericArtifactsResponse apply(ListGenericArtifactsRequest request) {
                return ArtifactsPaginators.this.client.listGenericArtifacts(request);
            }
        });
    }

    public Iterable<GenericArtifactSummary> listGenericArtifactsRecordIterator(final ListGenericArtifactsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGenericArtifactsRequest.Builder>(){

            @Override
            public ListGenericArtifactsRequest.Builder get() {
                return ListGenericArtifactsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGenericArtifactsResponse, String>(){

            @Override
            public String apply(ListGenericArtifactsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGenericArtifactsRequest.Builder>, ListGenericArtifactsRequest>(){

            @Override
            public ListGenericArtifactsRequest apply(RequestBuilderAndToken<ListGenericArtifactsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGenericArtifactsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGenericArtifactsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGenericArtifactsRequest, ListGenericArtifactsResponse>(){

            @Override
            public ListGenericArtifactsResponse apply(ListGenericArtifactsRequest request) {
                return ArtifactsPaginators.this.client.listGenericArtifacts(request);
            }
        }, (Function)new Function<ListGenericArtifactsResponse, List<GenericArtifactSummary>>(){

            @Override
            public List<GenericArtifactSummary> apply(ListGenericArtifactsResponse response) {
                return response.getGenericArtifactCollection().getItems();
            }
        });
    }

    public Iterable<ListRepositoriesResponse> listRepositoriesResponseIterator(final ListRepositoriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRepositoriesRequest.Builder>(){

            @Override
            public ListRepositoriesRequest.Builder get() {
                return ListRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, String>(){

            @Override
            public String apply(ListRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRepositoriesRequest.Builder>, ListRepositoriesRequest>(){

            @Override
            public ListRepositoriesRequest apply(RequestBuilderAndToken<ListRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRepositoriesRequest, ListRepositoriesResponse>(){

            @Override
            public ListRepositoriesResponse apply(ListRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listRepositories(request);
            }
        });
    }

    public Iterable<RepositorySummary> listRepositoriesRecordIterator(final ListRepositoriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRepositoriesRequest.Builder>(){

            @Override
            public ListRepositoriesRequest.Builder get() {
                return ListRepositoriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, String>(){

            @Override
            public String apply(ListRepositoriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRepositoriesRequest.Builder>, ListRepositoriesRequest>(){

            @Override
            public ListRepositoriesRequest apply(RequestBuilderAndToken<ListRepositoriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRepositoriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRepositoriesRequest, ListRepositoriesResponse>(){

            @Override
            public ListRepositoriesResponse apply(ListRepositoriesRequest request) {
                return ArtifactsPaginators.this.client.listRepositories(request);
            }
        }, (Function)new Function<ListRepositoriesResponse, List<RepositorySummary>>(){

            @Override
            public List<RepositorySummary> apply(ListRepositoriesResponse response) {
                return response.getRepositoryCollection().getItems();
            }
        });
    }
}

