/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugStarterFactory;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.testrunner.ControllableRerunHandler;
import org.netbeans.modules.php.project.ui.testrunner.UnitTestRunner;
import org.netbeans.modules.php.project.util.UsageLogging;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.api.jstesting.TestRunInfo;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

class ConfigActionTest
extends ConfigAction {
    private static final RequestProcessor RP = new RequestProcessor(ConfigActionTest.class);

    protected ConfigActionTest(PhpProject project) {
        super(project);
    }

    private PhpCoverageProvider getCoverageProvider() {
        return (PhpCoverageProvider)this.project.getLookup().lookup(PhpCoverageProvider.class);
    }

    protected List<FileObject> getTestDirectories(boolean showCustomizer) {
        return ProjectPropertiesSupport.getTestDirectories(this.project, showCustomizer);
    }

    @Override
    public boolean isProjectValid() {
        throw new IllegalStateException("Validation is not needed for tests");
    }

    @Override
    public boolean isFileValid() {
        throw new IllegalStateException("Validation is not needed for tests");
    }

    @Override
    public boolean isDebugProjectEnabled() {
        throw new IllegalStateException("Debug project tests action is not supported");
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context);
        return file != null && FileUtils.isPhpFile((FileObject)file);
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (DebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public boolean isRunMethodEnabled(Lookup context) {
        SingleMethod singleMethod = CommandUtils.singleMethodForContext(context);
        if (singleMethod == null) {
            return false;
        }
        FileObject file = singleMethod.getFile();
        if (file == null) {
            return false;
        }
        if (!FileUtils.isPhpFile((FileObject)file)) {
            return false;
        }
        PhpModule phpModule = this.project.getPhpModule();
        for (PhpTestingProvider testingProvider : this.project.getTestingProviders()) {
            if (!testingProvider.isTestFile(phpModule, file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDebugMethodEnabled(Lookup context) {
        if (DebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunMethodEnabled(context);
    }

    @Override
    public void runProject() {
        this.runJsTests();
        this.runPhpTests();
    }

    private void runPhpTests() {
        List<FileObject> testDirs = this.getTestDirectories(true);
        if (testDirs.isEmpty()) {
            return;
        }
        TestRunInfo testRunInfo = this.getTestRunInfoForDirs(testDirs, false);
        assert (testRunInfo != null);
        this.run(testRunInfo);
    }

    protected void runJsTests() {
        final JsTestingProvider jsTestingProvider = JsTestingProviders.getDefault().getJsTestingProvider((Project)this.project, false);
        if (jsTestingProvider != null) {
            UsageLogging.logJsTestRun(this.project, jsTestingProvider);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    org.netbeans.modules.web.clientproject.api.jstesting.TestRunInfo testRunInfo = new TestRunInfo.Builder().build();
                    jsTestingProvider.runTests((Project)ConfigActionTest.this.project, testRunInfo);
                }
            });
        }
    }

    @Override
    public void debugProject() {
        throw new IllegalStateException("Debug project tests action is not supported");
    }

    @Override
    public void runFile(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        assert (fileObj != null) : "Fileobject not found for context: " + context;
        TestRunInfo testRunInfo = this.getTestRunInfoForFile(fileObj, false);
        assert (testRunInfo != null);
        this.run(testRunInfo);
    }

    @Override
    public void debugFile(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        assert (fileObj != null) : "Fileobject not found for context: " + context;
        TestRunInfo testRunInfo = this.getTestRunInfoForFile(fileObj, true);
        assert (testRunInfo != null);
        this.run(testRunInfo);
    }

    @Override
    public void runMethod(Lookup context) {
        SingleMethod singleMethod = CommandUtils.singleMethodForContext(context);
        TestRunInfo testRunInfo = this.getTestRunInfo(singleMethod, false);
        assert (testRunInfo != null);
        this.run(testRunInfo);
    }

    @Override
    public void debugMethod(Lookup context) {
        SingleMethod singleMethod = CommandUtils.singleMethodForContext(context);
        TestRunInfo testRunInfo = this.getTestRunInfo(singleMethod, true);
        assert (testRunInfo != null);
        this.run(testRunInfo);
    }

    void run(TestRunInfo testRunInfo) {
        new UnitTestRunner(this.project, testRunInfo, new RerunUnitTestHandler(testRunInfo)).run();
    }

    private TestRunInfo getTestRunInfo(SingleMethod singleMethod, boolean debug) {
        assert (singleMethod != null);
        FileObject file = singleMethod.getFile();
        assert (file != null);
        TestRunInfo testRunInfo = this.getTestRunInfoForFile(file, debug);
        assert (testRunInfo != null);
        Pair<String, String> method = CommandUtils.decodeMethod(singleMethod.getMethodName());
        TestRunInfo.TestInfo testInfo = new TestRunInfo.TestInfo("UNKNOWN_TYPE", (String)method.second(), (String)method.first(), FileUtil.toFile((FileObject)file).getAbsolutePath());
        testRunInfo.setInitialTests(Collections.singleton(testInfo));
        return testRunInfo;
    }

    @CheckForNull
    private TestRunInfo getTestRunInfoForDirs(List<FileObject> dirs, boolean debug) {
        assert (dirs != null);
        return new TestRunInfo.Builder().setSessionType(debug ? TestRunInfo.SessionType.DEBUG : TestRunInfo.SessionType.TEST).setStartFiles(this.getValidFolders(dirs)).setCoverageEnabled(this.getCoverageProvider().isEnabled()).build();
    }

    private List<FileObject> getValidFolders(List<FileObject> dirs) {
        ArrayList<FileObject> validDirs = new ArrayList<FileObject>(dirs.size());
        for (FileObject dir : dirs) {
            assert (dir.isFolder()) : dir;
            if (!dir.isValid()) continue;
            validDirs.add(dir);
        }
        return validDirs;
    }

    @CheckForNull
    private TestRunInfo getTestRunInfoForFile(FileObject fileObj, boolean debug) {
        assert (fileObj != null);
        if (!fileObj.isValid()) {
            return null;
        }
        String name = fileObj.isFolder() ? fileObj.getNameExt() : fileObj.getName();
        return new TestRunInfo.Builder().setSessionType(debug ? TestRunInfo.SessionType.DEBUG : TestRunInfo.SessionType.TEST).setStartFile(fileObj).setSuiteName(name).setCoverageEnabled(this.getCoverageProvider().isEnabled()).build();
    }

    protected final class RerunUnitTestHandler
    implements ControllableRerunHandler {
        final TestRunInfo info;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private volatile boolean enabled = false;

        public RerunUnitTestHandler(TestRunInfo info) {
            assert (info != null);
            this.info = info;
        }

        public void rerun() {
            this.info.setRerun(true);
            PhpActionProvider.submitTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigActionTest.this.run(RerunUnitTestHandler.this.info);
                    }
                    finally {
                        RerunUnitTestHandler.this.info.setRerun(false);
                        RerunUnitTestHandler.this.info.resetCustomTests();
                    }
                }
            });
        }

        public void rerun(Set<Testcase> tests) {
            this.info.setCustomTests(this.map(tests));
            this.rerun();
        }

        public boolean enabled(RerunType type) {
            boolean supportedType = false;
            switch (type) {
                case ALL: 
                case CUSTOM: {
                    supportedType = true;
                    break;
                }
                default: {
                    assert (false) : "Unknown RerunType: " + type;
                    break;
                }
            }
            return supportedType && this.enabled;
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void enable() {
            if (!this.enabled) {
                this.enabled = true;
                this.changeSupport.fireChange();
            }
        }

        @Override
        public void disable() {
            if (this.enabled) {
                this.enabled = false;
                this.changeSupport.fireChange();
            }
        }

        private Collection<TestRunInfo.TestInfo> map(Set<Testcase> tests) {
            HashSet<TestRunInfo.TestInfo> testCases = new HashSet<TestRunInfo.TestInfo>();
            for (Testcase test : tests) {
                testCases.add(new TestRunInfo.TestInfo(test.getType(), test.getName(), test.getClassName(), test.getLocation()));
            }
            return testCases;
        }
    }
}

