/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model;

import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.model.ModelBuilder;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.api.TypeUsage;

public class SemiTypeResolverVisitor
extends PathNodeVisitor {
    private static final Logger LOGGER = Logger.getLogger(SemiTypeResolverVisitor.class.getName());
    public static final String ST_START_DELIMITER = "@";
    public static final String ST_THIS = "@this;";
    public static final String ST_VAR = "@var;";
    public static final String ST_EXP = "@exp;";
    public static final String ST_PRO = "@pro;";
    public static final String ST_CALL = "@call;";
    public static final String ST_NEW = "@new;";
    public static final String ST_ARR = "@arr;";
    public static final String ST_ANONYM = "@anonym;";
    public static final String ST_WITH = "@with;";
    private static final TypeUsage BOOLEAN_TYPE = new TypeUsage("Boolean", -1, true);
    private static final TypeUsage STRING_TYPE = new TypeUsage("String", -1, true);
    private static final TypeUsage NUMBER_TYPE = new TypeUsage("Number", -1, true);
    private static final TypeUsage ARRAY_TYPE = new TypeUsage("Array", -1, true);
    private static final TypeUsage REGEXP_TYPE = new TypeUsage("RegExp", -1, true);
    private static final TypeUsage UNDEFINED_TYPE = new TypeUsage("undefined", -1, true);
    private Map<String, TypeUsage> result;
    private List<String> exp;
    private int typeOffset;
    private final FinderOffsetTypeVisitor offsetVisitor = new FinderOffsetTypeVisitor();
    private ModelBuilder builder;

    public Set<TypeUsage> getSemiTypes(Node expression, ModelBuilder builder) {
        this.builder = builder;
        this.exp = new ArrayList<String>();
        this.result = new HashMap<String, TypeUsage>();
        this.reset();
        expression.accept((NodeVisitor)this);
        this.add(this.exp, this.typeOffset == -1 ? this.offsetVisitor.findOffset(expression) : this.typeOffset, false);
        return new HashSet<TypeUsage>(this.result.values());
    }

    private void reset() {
        this.exp.clear();
        this.typeOffset = -1;
    }

    private void add(List<String> exp, int offset, boolean resolved) {
        if (exp.isEmpty() || exp.size() == 1 && exp.get(0).startsWith(ST_START_DELIMITER) && !exp.get(0).startsWith(ST_ANONYM) && !ST_THIS.equals(exp.get(0))) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!exp.get(0).startsWith(ST_START_DELIMITER)) {
            if (exp.size() == 1) {
                sb.append(ST_VAR);
            } else {
                sb.append(ST_EXP);
            }
        }
        for (String part : exp) {
            sb.append(part);
        }
        String type = sb.toString();
        if (!this.result.containsKey(type)) {
            this.result.put(type, new TypeUsage(type, offset, resolved));
        }
    }

    private void add(TypeUsage type) {
        if (!this.result.containsKey(type.getType())) {
            this.result.put(type.getType(), type);
        }
    }

    @Override
    public Node leaveAccessNode(AccessNode accessNode) {
        if (!this.exp.isEmpty()) {
            String preType;
            String type = this.exp.get(this.exp.size() - 1);
            String string = preType = this.exp.size() > 1 ? this.exp.get(this.exp.size() - 2) : "";
            if (!(ST_THIS.equals(type) || preType.startsWith(ST_START_DELIMITER) || type.startsWith(ST_ANONYM))) {
                this.exp.add(this.exp.size() - 1, ST_PRO);
            }
        }
        this.exp.add(ST_PRO);
        this.exp.add(accessNode.getProperty());
        return super.leaveAccessNode(accessNode);
    }

    @Override
    public boolean enterCallNode(CallNode callNode) {
        this.addToPath((Node)callNode);
        if (!(callNode.getFunction() instanceof FunctionNode)) {
            callNode.getFunction().accept((NodeVisitor)this);
        }
        if (this.exp.size() == 2 && ST_NEW.equals(this.exp.get(0))) {
            return false;
        }
        if (callNode.getFunction() instanceof AccessNode) {
            int size = this.exp.size();
            if (size > 1 && ST_PRO.equals(this.exp.get(size - 2))) {
                this.exp.remove(size - 2);
            }
        } else if (callNode.getFunction() instanceof FunctionNode) {
            FunctionNode function = (FunctionNode)callNode.getFunction();
            String name = this.builder.getFunctionName(function);
            this.add(new TypeUsage(ST_CALL + name, function.getStart(), false));
            return false;
        }
        if (this.exp.isEmpty()) {
            this.exp.add(ST_CALL);
        } else {
            this.exp.add(this.exp.size() - 1, ST_CALL);
        }
        return false;
    }

    @Override
    public Node leaveCallNode(CallNode callNode) {
        int size;
        if (callNode.getFunction() instanceof AccessNode && (size = this.exp.size()) > 1 && ST_PRO.equals(this.exp.get(size - 2))) {
            this.exp.remove(size - 2);
        }
        this.exp.add(this.exp.size() - 1, ST_CALL);
        return super.leaveCallNode(callNode);
    }

    @Override
    public boolean enterUnaryNode(UnaryNode unaryNode) {
        switch (Token.descType((long)unaryNode.getToken())) {
            case NEW: {
                this.exp.add(ST_NEW);
                SimpleNameResolver snr = new SimpleNameResolver();
                this.exp.add(snr.getFQN((Node)unaryNode.getExpression(), this.builder));
                this.typeOffset = snr.getTypeOffset();
                return false;
            }
            case NOT: {
                this.add(BOOLEAN_TYPE);
                return false;
            }
            case ADD: 
            case SUB: 
            case DECPREFIX: 
            case DECPOSTFIX: 
            case INCPREFIX: 
            case INCPOSTFIX: {
                this.add(NUMBER_TYPE);
                return false;
            }
        }
        return super.enterUnaryNode(unaryNode);
    }

    @Override
    public Node leaveUnaryNode(UnaryNode uNode) {
        if (Token.descType((long)uNode.getToken()) == TokenType.NEW) {
            int size = this.exp.size();
            if (size > 1 && ST_CALL.equals(this.exp.get(size - 2))) {
                this.exp.remove(size - 2);
            }
            this.typeOffset = uNode.getExpression().getStart();
            if (!this.exp.isEmpty()) {
                this.exp.add(this.exp.size() - 1, ST_NEW);
            } else {
                this.exp.add(ST_NEW);
            }
        }
        return super.leaveUnaryNode(uNode);
    }

    @Override
    public boolean enterIdentNode(IdentNode iNode) {
        String name = iNode.getPropertyName();
        if ("this".equals(name)) {
            this.exp.add(ST_THIS);
        } else if ("undefined".equals(name)) {
            this.add(UNDEFINED_TYPE);
        } else {
            if (this.getPath().isEmpty()) {
                this.exp.add(ST_VAR);
            }
            this.exp.add(name);
        }
        return false;
    }

    @Override
    public boolean enterLiteralNode(LiteralNode lNode) {
        Object value = lNode.getObject();
        TypeUsage type = null;
        if (value instanceof Boolean) {
            type = BOOLEAN_TYPE;
        } else if (value instanceof String) {
            type = STRING_TYPE;
        } else if (value instanceof Integer || value instanceof Float || value instanceof Double) {
            type = NUMBER_TYPE;
        } else if (lNode instanceof LiteralNode.ArrayLiteralNode) {
            type = ARRAY_TYPE;
        } else if (value instanceof Lexer.RegexToken) {
            type = REGEXP_TYPE;
        }
        if (type != null) {
            if (this.getPath().size() > 1 && this.getPreviousFromPath(2) instanceof CallNode) {
                this.exp.add(type.getType());
            } else {
                this.add(type);
            }
        }
        return false;
    }

    @Override
    public boolean enterTernaryNode(TernaryNode ternaryNode) {
        ternaryNode.getTrueExpression().accept((NodeVisitor)this);
        this.add(this.exp, this.offsetVisitor.findOffset((Node)ternaryNode.getTrueExpression()), false);
        this.reset();
        JoinPredecessorExpression third = ternaryNode.getFalseExpression();
        third.accept((NodeVisitor)this);
        int typeStart = this.offsetVisitor.findOffset((Node)third);
        this.add(this.exp, typeStart, false);
        this.reset();
        return false;
    }

    @Override
    public boolean enterObjectNode(ObjectNode objectNode) {
        int size = this.getPath().size();
        if (size > 0 && this.getPath().get(size - 1) instanceof AccessNode) {
            this.exp.add(ST_ANONYM + objectNode.getStart());
        } else {
            this.add(new TypeUsage(ST_ANONYM + objectNode.getStart(), objectNode.getStart(), false));
        }
        return false;
    }

    @Override
    public boolean enterIndexNode(IndexNode indexNode) {
        this.addToPath((Node)indexNode);
        indexNode.getBase().accept((NodeVisitor)this);
        int size = this.exp.size();
        if (size > 1 && ST_PRO.equals(this.exp.get(size - 2))) {
            this.exp.remove(size - 2);
        }
        if (this.exp.isEmpty()) {
            this.exp.add(ST_ARR);
        } else {
            LiteralNode lNode;
            boolean propertyAccess = false;
            if (indexNode.getIndex() instanceof LiteralNode && (lNode = (LiteralNode)indexNode.getIndex()).isString()) {
                this.exp.add(ST_PRO);
                this.exp.add(lNode.getPropertyName());
                propertyAccess = true;
            }
            if (!propertyAccess) {
                this.exp.add(this.exp.size() - 1, ST_ARR);
            }
        }
        return false;
    }

    @Override
    public boolean enterBinaryNode(BinaryNode binaryNode) {
        if (!binaryNode.isAssignment()) {
            if (this.isResultString(binaryNode)) {
                this.add(STRING_TYPE);
                return false;
            }
            if (this.isResultNumber(binaryNode)) {
                this.add(NUMBER_TYPE);
                return false;
            }
            TokenType tokenType = binaryNode.tokenType();
            if (tokenType == TokenType.EQ || tokenType == TokenType.EQ_STRICT || tokenType == TokenType.NE || tokenType == TokenType.NE_STRICT || tokenType == TokenType.GE || tokenType == TokenType.GT || tokenType == TokenType.LE || tokenType == TokenType.LT || tokenType == TokenType.AND) {
                if (this.getPath().isEmpty()) {
                    this.add(BOOLEAN_TYPE);
                }
                return false;
            }
            binaryNode.lhs().accept((NodeVisitor)this);
            this.add(this.exp, this.offsetVisitor.findOffset((Node)binaryNode.lhs()), false);
            this.reset();
            binaryNode.rhs().accept((NodeVisitor)this);
            this.add(this.exp, this.offsetVisitor.findOffset((Node)binaryNode.rhs()), false);
            this.reset();
            return false;
        }
        if (binaryNode.rhs() instanceof FunctionNode) {
            binaryNode.lhs().accept((NodeVisitor)this);
            return false;
        }
        if (binaryNode.isAssignment()) {
            binaryNode.rhs().accept((NodeVisitor)this);
            return false;
        }
        return super.enterBinaryNode(binaryNode);
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        List<? extends Node> path = this.getPath();
        boolean functionType = true;
        if (!path.isEmpty()) {
            Node lastNode = path.get(path.size() - 1);
            boolean bl = functionType = !(lastNode instanceof CallNode);
        }
        if (functionType) {
            this.add(new TypeUsage("Function", functionNode.getStart(), true));
        }
        return false;
    }

    private boolean isResultString(BinaryNode binaryNode) {
        boolean bResult = false;
        TokenType tokenType = binaryNode.tokenType();
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        if (tokenType == TokenType.ADD && (lhs instanceof LiteralNode && ((LiteralNode)lhs).isString() || rhs instanceof LiteralNode && ((LiteralNode)rhs).isString())) {
            bResult = true;
        } else {
            if (lhs instanceof JoinPredecessorExpression) {
                lhs = ((JoinPredecessorExpression)lhs).getExpression();
            }
            if (rhs instanceof JoinPredecessorExpression) {
                rhs = ((JoinPredecessorExpression)rhs).getExpression();
            }
            if (lhs instanceof BinaryNode) {
                bResult = this.isResultString((BinaryNode)lhs);
            } else if (rhs instanceof BinaryNode) {
                bResult = this.isResultString((BinaryNode)rhs);
            }
        }
        return bResult;
    }

    private boolean isResultNumber(BinaryNode binaryNode) {
        boolean bResult = false;
        TokenType tokenType = binaryNode.tokenType();
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        if ((tokenType == TokenType.BIT_OR || tokenType == TokenType.BIT_AND) && (lhs instanceof LiteralNode && ((LiteralNode)lhs).isNumeric() || rhs instanceof LiteralNode && ((LiteralNode)rhs).isNumeric())) {
            bResult = true;
        } else if (tokenType == TokenType.DIV || tokenType == TokenType.MUL || tokenType == TokenType.SUB) {
            bResult = true;
        } else if (lhs instanceof BinaryNode) {
            bResult = this.isResultNumber((BinaryNode)lhs);
        } else if (rhs instanceof BinaryNode) {
            bResult = this.isResultNumber((BinaryNode)rhs);
        }
        return bResult;
    }

    private static class FinderOffsetTypeVisitor
    extends NodeVisitor {
        private int typeOffset = -1;

        public FinderOffsetTypeVisitor() {
            super(new LexicalContext());
        }

        int findOffset(Node expression) {
            expression.accept((NodeVisitor)this);
            return this.typeOffset;
        }

        public boolean enterIdentNode(IdentNode identNode) {
            this.typeOffset = identNode.getStart();
            return false;
        }

        public boolean enterAccessNode(AccessNode accessNode) {
            this.typeOffset = accessNode.getStart();
            return false;
        }
    }

    private static class SimpleNameResolver
    extends PathNodeVisitor {
        private List<String> exp = new ArrayList<String>();
        private int typeOffset = -1;
        private ModelBuilder builder;

        private SimpleNameResolver() {
        }

        public String getFQN(Node expression, ModelBuilder builder) {
            this.exp.clear();
            this.builder = builder;
            expression.accept((NodeVisitor)this);
            StringBuilder sb = new StringBuilder();
            for (String part : this.exp) {
                sb.append(part);
                sb.append('.');
            }
            if (sb.length() == 0) {
                LOGGER.log(Level.FINE, "New operator withouth name: {0}", expression.toString());
                return null;
            }
            return sb.toString().substring(0, sb.length() - 1);
        }

        public int getTypeOffset() {
            return this.typeOffset;
        }

        @Override
        public boolean enterAccessNode(AccessNode accessNode) {
            if (this.typeOffset == -1) {
                this.typeOffset = accessNode.getFinish() - accessNode.getProperty().length();
            }
            accessNode.getBase().accept((NodeVisitor)this);
            this.exp.add(accessNode.getProperty());
            return false;
        }

        @Override
        public boolean enterCallNode(CallNode callNode) {
            callNode.getFunction().accept((NodeVisitor)this);
            return false;
        }

        @Override
        public boolean enterFunctionNode(FunctionNode functionNode) {
            String name = this.builder.getFunctionName(functionNode);
            this.exp.add(name);
            if (this.typeOffset == -1) {
                this.typeOffset = functionNode.getIdent().getStart();
            }
            return false;
        }

        @Override
        public boolean enterIndexNode(IndexNode indexNode) {
            indexNode.getBase().accept((NodeVisitor)this);
            return false;
        }

        @Override
        public boolean enterIdentNode(IdentNode identNode) {
            this.exp.add(identNode.getName());
            if (this.typeOffset == -1) {
                this.typeOffset = identNode.getStart();
            }
            return super.enterIdentNode(identNode);
        }
    }
}

