/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

public class FilterMappingData {
    private String name = null;
    private Type type = null;
    private String pattern = null;
    private Dispatcher[] dispatch = new Dispatcher[0];

    FilterMappingData() {
    }

    FilterMappingData(String name) {
        this.name = name;
        this.type = Type.URL;
        this.pattern = "/*";
    }

    FilterMappingData(String name, Type type, String pattern, Dispatcher[] d) {
        this.name = name;
        this.type = type;
        this.pattern = pattern;
        this.dispatch = d;
    }

    public Object clone() {
        return new FilterMappingData(this.name, this.type, this.pattern, this.dispatch);
    }

    String getName() {
        return this.name;
    }

    void setName(String newName) {
        this.name = newName;
    }

    Type getType() {
        return this.type;
    }

    void setType(Type newType) {
        this.type = newType;
    }

    String getPattern() {
        return this.pattern;
    }

    void setPattern(String newPattern) {
        this.pattern = newPattern;
    }

    Dispatcher[] getDispatcher() {
        return this.dispatch;
    }

    void setDispatcher(Dispatcher[] d) {
        this.dispatch = d;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("FilterMapping for filter: ");
        buf.append(this.name);
        buf.append("\nMapping type: ");
        buf.append(this.type.toString());
        buf.append(" for pattern: ");
        buf.append(this.pattern);
        buf.append("\nDispatch conditions: ");
        if (this.dispatch.length == 0) {
            buf.append("REQUEST (not set)\n\n");
        } else {
            for (int i = 0; i < this.dispatch.length; ++i) {
                buf.append(this.dispatch[i].toString());
                buf.append(", ");
            }
            buf.append("\n\n");
        }
        return buf.toString();
    }

    static class Type {
        private String name;
        public static final Type URL = new Type("URL pattern");
        public static final Type SERVLET = new Type("Servlet");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Dispatcher {
        private String name;
        public static final Dispatcher BLANK = new Dispatcher("");
        public static final Dispatcher REQUEST = new Dispatcher("REQUEST");
        public static final Dispatcher INCLUDE = new Dispatcher("INCLUDE");
        public static final Dispatcher FORWARD = new Dispatcher("FORWARD");
        public static final Dispatcher ERROR = new Dispatcher("ERROR");

        private Dispatcher(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static final Dispatcher findDispatcher(String s) {
            if (s.equals(REQUEST.toString())) {
                return REQUEST;
            }
            if (s.equals(INCLUDE.toString())) {
                return INCLUDE;
            }
            if (s.equals(FORWARD.toString())) {
                return FORWARD;
            }
            if (s.equals(ERROR.toString())) {
                return ERROR;
            }
            return BLANK;
        }

        public static final Dispatcher[] getAll() {
            Dispatcher[] d = new Dispatcher[]{REQUEST, FORWARD, INCLUDE, ERROR};
            return d;
        }
    }
}

