/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.tools.Diagnostic;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.EditorUI;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.java.preprocessorbridge.spi.WrapperFactory;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private static final Logger logger = Logger.getLogger(WatchPanel.class.getName());
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public static void setupContext(final JEditorPane editorPane, final Runnable contextSetUp) {
        Context c;
        DebuggerEngine en = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (EventQueue.isDispatchThread() && en != null) {
            RequestProcessor contextRetrievalRP = (RequestProcessor)en.lookupFirst(null, RequestProcessor.class);
            if (contextRetrievalRP != null) {
                final DebuggerEngine den = en;
                contextRetrievalRP.post(new Runnable(){

                    @Override
                    public void run() {
                        Context c = WatchPanel.retrieveContext(den);
                        if (c != null) {
                            WatchPanel.setupContext(editorPane, c.url, c.line, c.column, c.debugger);
                            if (contextSetUp != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        contextSetUp.run();
                                    }
                                });
                            }
                        }
                    }
                });
                Context c2 = WatchPanel.retrieveContext(null);
                if (c2 != null) {
                    WatchPanel.setupContext(editorPane, c2.url, c2.line, c2.column, c2.debugger);
                } else {
                    WatchPanel.setupUI(editorPane);
                }
                return;
            }
            en = null;
        }
        if ((c = WatchPanel.retrieveContext(en)) != null) {
            WatchPanel.setupContext(editorPane, c.url, c.line, c.column, c.debugger);
        } else {
            WatchPanel.setupUI(editorPane);
        }
        if (contextSetUp != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    contextSetUp.run();
                }
            });
        }
    }

    private static Context retrieveContext(DebuggerEngine en) {
        Context c;
        CallStackFrame csf = null;
        JPDADebugger d = null;
        if (en != null && (d = (JPDADebugger)en.lookupFirst(null, JPDADebugger.class)) != null) {
            csf = d.getCurrentCallStackFrame();
        }
        boolean adjustContext = true;
        if (csf != null) {
            Session session = (Session)en.lookupFirst(null, Session.class);
            String language = session.getCurrentLanguage();
            SourcePath sp = (SourcePath)en.lookupFirst(null, SourcePath.class);
            c = new Context();
            c.url = sp.getURL(csf, language);
            c.line = csf.getLineNumber(language);
            c.debugger = d;
            if (c.line > 0) {
                adjustContext = false;
            }
        } else {
            EditorContext context = EditorContextBridge.getContext();
            String url = context.getCurrentURL();
            if (url != null && url.length() > 0) {
                c = new Context();
                c.url = url;
                c.line = context.getCurrentLineNumber();
                c.debugger = d;
            } else {
                url = EditorContextDispatcher.getDefault().getMostRecentURLAsString();
                if (url != null && url.length() > 0) {
                    c = new Context();
                    c.url = url;
                    c.line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
                    c.debugger = d;
                } else {
                    return null;
                }
            }
            c.column = WatchPanel.getRecentColumn();
        }
        if (adjustContext && !EventQueue.isDispatchThread()) {
            WatchPanel.adjustLine(c);
        }
        return c;
    }

    private static int getRecentColumn() {
        Caret caret;
        JEditorPane mostRecentEditor = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (mostRecentEditor != null && (caret = mostRecentEditor.getCaret()) != null) {
            int offset = caret.getDot();
            try {
                int rs = Utilities.getRowStart(mostRecentEditor, offset);
                return offset - rs;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void adjustLine(Context c) {
        BufferedReader br;
        URL url;
        if (c.line == -1) {
            c.line = 1;
        }
        try {
            url = new URL(c.url);
        }
        catch (MalformedURLException ex) {
            return;
        }
        FileObject fo = URLMapper.findFileObject((URL)url);
        if (fo == null) {
            return;
        }
        if (!"java".equalsIgnoreCase(fo.getExt())) {
            return;
        }
        try {
            br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            int line = WatchPanel.findClassLine(br);
            Point lc = WatchPanel.findMethodLineColumn(line, c.column, br);
            if (c.line < lc.x) {
                c.line = lc.x;
                c.column = lc.y;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static int findClassLine(BufferedReader br) throws IOException {
        String line;
        int l = 1;
        boolean comment = false;
        boolean classDecl = false;
        while ((line = br.readLine()) != null) {
            if (classDecl) {
                if (line.indexOf(123) >= 0) {
                    return l + 1;
                }
            } else {
                boolean slash = false;
                boolean asterix = false;
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (comment) {
                        if (asterix && c == '/') {
                            comment = false;
                            asterix = false;
                            continue;
                        }
                        asterix = c == '*';
                        continue;
                    }
                    if (slash && c == '*') {
                        comment = true;
                        slash = false;
                        continue;
                    }
                    if (c == '/') {
                        if (slash) break;
                        slash = true;
                    }
                    if (c != 'c' || line.length() < i + "class".length() || !"lass".equals(line.substring(i + 1, i + 5))) continue;
                    classDecl = true;
                    if (line.indexOf(123, i + 5) <= 0) continue;
                    return l + 1;
                }
            }
            ++l;
        }
        return 1;
    }

    private static Point findMethodLineColumn(int l, int col, BufferedReader br) throws IOException {
        String line;
        int origLine = l;
        boolean isParenthesis = false;
        boolean isThrows = false;
        while ((line = br.readLine()) != null) {
            int i = 0;
            if (!isParenthesis && (i = line.indexOf(41)) >= 0 || isParenthesis) {
                isParenthesis = true;
                if (!isThrows) {
                    ++i;
                    while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                        ++i;
                    }
                    if (i + "throws".length() < line.length() && "throws".equals(line.substring(i, i + "throws".length()))) {
                        isThrows = true;
                    }
                }
                if (isThrows && (i = line.indexOf("{", i)) < 0) {
                    i = line.length();
                }
                if (i < line.length()) {
                    if (line.charAt(i) == '{') {
                        return new Point(l, i + 1);
                    }
                    isParenthesis = false;
                }
            }
            ++l;
        }
        return new Point(origLine, col);
    }

    public static void setupContext(JEditorPane editorPane, String url, int line, int column) {
        WatchPanel.setupContext(editorPane, url, line, column, null);
    }

    public static void setupContext(final JEditorPane editorPane, String url, final int line, final int column, final JPDADebugger debugger) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
            if (file == null) {
                return;
            }
        }
        catch (MalformedURLException e) {
            return;
        }
        if ("text/x-java".equals(file.getMIMEType())) {
            Runnable bindComponentToDocument = new Runnable(){

                @Override
                public void run() {
                    String origText = editorPane.getText();
                    DialogBinding.bindComponentToFile((FileObject)file, (int)(line > 0 ? line - 1 : 0), (int)column, (int)0, (JTextComponent)editorPane);
                    Document editPaneDoc = editorPane.getDocument();
                    editPaneDoc.putProperty("org.netbeans.modules.editor.java.JavaCompletionProvider.skipAccessibilityCheck", "true");
                    editPaneDoc.putProperty(WrapperFactory.class, debugger != null ? new MyWrapperFactory(debugger, file) : null);
                    editorPane.setText(origText);
                }
            };
            if (EventQueue.isDispatchThread()) {
                bindComponentToDocument.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(bindComponentToDocument);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        WatchPanel.setupUI(editorPane);
    }

    private static void setupUI(final JEditorPane editorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorUI eui = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)editorPane);
                if (eui == null) {
                    return;
                }
                editorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                try {
                    Field textLimitLineField = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    textLimitLineField.setAccessible(true);
                    textLimitLineField.set(eui, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                editorPane.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JComponent getPanel() {
        StyledDocument doc;
        String selectedExpression;
        JEditorPane editor;
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)textLabel, (String)bundle.getString("CTL_Watch_Name"));
        if (this.expression != null && this.expression.trim().length() == 0 && (editor = EditorContextDispatcher.getDefault().getMostRecentEditor()) != null && editor.getDocument() instanceof StyledDocument && (selectedExpression = WatchPanel.getSelectedIdentifier(doc = (StyledDocument)editor.getDocument(), editor, editor.getCaret().getDot())) != null) {
            this.expression = selectedExpression;
        }
        JComponent[] editorComponents = org.netbeans.editor.Utilities.createSingleLineEditor((String)"text/plain");
        JScrollPane sp = (JScrollPane)editorComponents[0];
        this.editorPane = (JEditorPane)editorComponents[1];
        int h = sp.getPreferredSize().height;
        int w = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        sp.setPreferredSize(new Dimension(w, h));
        textLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", textLabel);
        this.panel.add("Center", sp);
        this.editorPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        Runnable editorPaneUpdated = new Runnable(){

            @Override
            public void run() {
                WatchPanel.this.editorPane.setText(WatchPanel.this.expression);
                WatchPanel.this.editorPane.selectAll();
            }
        };
        WatchPanel.setupContext(this.editorPane, editorPaneUpdated);
        textLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    private static String getSelectedIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static final class Context {
        public String url;
        public int line;
        public int column;
        public JPDADebugger debugger;

        private Context() {
        }
    }

    public static final class DelegatingBorder
    implements Border {
        private Border delegate;
        private Insets insets;

        public DelegatingBorder(Border delegate, Insets insets) {
            this.delegate = delegate;
            this.insets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    private static class MyTrees
    extends Trees {
        Trees trees;
        private CompilationController controller;
        private JPDADebugger debugger;

        MyTrees(Trees trees, CompilationController controller, JPDADebugger debugger) {
            this.trees = trees;
            this.controller = controller;
            this.debugger = debugger;
        }

        @Override
        public SourcePositions getSourcePositions() {
            return this.trees.getSourcePositions();
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element arg0) {
            return this.trees.getTree(arg0);
        }

        @Override
        public ClassTree getTree(TypeElement arg0) {
            return this.trees.getTree(arg0);
        }

        @Override
        public MethodTree getTree(ExecutableElement arg0) {
            return this.trees.getTree(arg0);
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element arg0, AnnotationMirror arg1) {
            return this.trees.getTree(arg0, arg1);
        }

        @Override
        public Tree getTree(javax.lang.model.element.Element arg0, AnnotationMirror arg1, AnnotationValue arg2) {
            return this.trees.getTree(arg0, arg1, arg2);
        }

        @Override
        public TreePath getPath(CompilationUnitTree arg0, Tree arg1) {
            return this.trees.getPath(arg0, arg1);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element arg0) {
            return this.trees.getPath(arg0);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element arg0, AnnotationMirror arg1) {
            return this.trees.getPath(arg0, arg1);
        }

        @Override
        public TreePath getPath(javax.lang.model.element.Element arg0, AnnotationMirror arg1, AnnotationValue arg2) {
            return this.trees.getPath(arg0, arg1, arg2);
        }

        @Override
        public javax.lang.model.element.Element getElement(TreePath arg0) {
            return this.trees.getElement(arg0);
        }

        @Override
        public TypeMirror getTypeMirror(TreePath arg0) {
            Tree tree = arg0.getLeaf();
            if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                Elements elements;
                TypeElement typeElem;
                String name;
                ObjectVariable var;
                Map map = null;
                try {
                    Method method = this.debugger.getClass().getMethod("getAllLabels", new Class[0]);
                    map = (Map)method.invoke((Object)this.debugger, new Object[0]);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (map != null && (var = (ObjectVariable)map.get(name = ((IdentifierTree)tree).getName().toString())) != null && (typeElem = (elements = this.controller.getElements()).getTypeElement(var.getClassType().getName())) != null) {
                    return typeElem.asType();
                }
            }
            return this.trees.getTypeMirror(arg0);
        }

        @Override
        public Scope getScope(TreePath arg0) {
            return this.trees.getScope(arg0);
        }

        @Override
        public boolean isAccessible(Scope arg0, TypeElement arg1) {
            return this.trees.isAccessible(arg0, arg1);
        }

        @Override
        public boolean isAccessible(Scope arg0, javax.lang.model.element.Element arg1, DeclaredType arg2) {
            return this.trees.isAccessible(arg0, arg1, arg2);
        }

        @Override
        public TypeMirror getOriginalType(ErrorType arg0) {
            return this.trees.getOriginalType(arg0);
        }

        @Override
        public void printMessage(Diagnostic.Kind arg0, CharSequence arg1, Tree arg2, CompilationUnitTree arg3) {
            this.trees.printMessage(arg0, arg1, arg2, arg3);
        }

        @Override
        public String getDocComment(TreePath path) {
            return this.trees.getDocComment(path);
        }

        @Override
        public TypeMirror getLub(CatchTree tree) {
            return this.trees.getLub(tree);
        }
    }

    private static class MyWrapperFactory
    implements WrapperFactory {
        private WeakReference<JPDADebugger> debuggerRef;
        private FileObject fileObject;

        public MyWrapperFactory(JPDADebugger debugger, FileObject file) {
            this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
            this.fileObject = file;
        }

        private CompilationController findController(FileObject fileObj) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObj);
            if (javaSource == null) {
                return null;
            }
            final CompilationController[] result = new CompilationController[]{null};
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        result[0] = ci;
                    }
                }, true);
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return null;
            }
            return result[0];
        }

        public Trees wrapTrees(Trees trees) {
            JPDADebugger debugger = (JPDADebugger)this.debuggerRef.get();
            if (debugger == null) {
                return trees;
            }
            return new MyTrees(trees, this.findController(this.fileObject), debugger);
        }
    }
}

