/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class BreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    public BreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/html", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault()));
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-php5", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault()));
    }

    public void doAction(Object action) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addBreakpoints();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BreakpointActionProvider.this.addBreakpoints();
                }
            });
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    private void addBreakpoints() {
        Line line = MiscEditorUtil.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        boolean add = true;
        for (Breakpoint breakpoint : breakpoints) {
            if (!(breakpoint instanceof JSLineBreakpoint) || !JSUtils.getLine((JSLineBreakpoint)((JSLineBreakpoint)breakpoint)).equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoint);
            add = false;
            break;
        }
        boolean bl = add = add && MiscEditorUtil.isInJavaScript(line);
        if (add) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)JSUtils.createLineBreakpoint((Line)line));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, fo != null && MiscEditorUtil.isJSWrapperSource(fo));
    }
}

