/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLCollection;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLFunction;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLTreeWalker;
import org.netbeans.modules.languages.hcl.ast.HCLVariable;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class HCLSemanticAnalyzer
extends SemanticAnalyzer<HCLParserResult> {
    private volatile boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> highlights = Collections.emptyMap();

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.highlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final void run(HCLParserResult result, SchedulerEvent event) {
        this.resume();
        Highlighter h = this.createHighlighter(result);
        this.highlights = h.process(result.getDocument());
    }

    protected Highlighter createHighlighter(HCLParserResult result) {
        return new DefaultHighlighter(result.getReferences());
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected abstract class Highlighter {
        protected final Map<OffsetRange, Set<ColoringAttributes>> work = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        protected final SourceRef refs;

        protected Highlighter(SourceRef refs) {
            this.refs = refs;
        }

        protected abstract void highlight(HCLTreeWalker.Step var1);

        private boolean cancellableHighlight(HCLTreeWalker.Step step) {
            if (HCLSemanticAnalyzer.this.isCancelled()) {
                return false;
            }
            this.highlight(step);
            return true;
        }

        public Map<OffsetRange, Set<ColoringAttributes>> process(HCLElement element) {
            HCLTreeWalker.depthFirst(element, this::cancellableHighlight);
            return this.work;
        }

        protected final void mark(HCLElement e, Set<ColoringAttributes> attrs) {
            this.refs.getOffsetRange(e).ifPresent(range -> this.work.put((OffsetRange)range, attrs));
        }
    }

    protected class DefaultHighlighter
    extends Highlighter {
        public DefaultHighlighter(SourceRef refs) {
            super(refs);
        }

        @Override
        protected void highlight(HCLTreeWalker.Step step) {
            block8: {
                HCLElement e;
                block7: {
                    e = step.node();
                    if (!(e instanceof HCLBlock)) break block7;
                    HCLBlock block = (HCLBlock)e;
                    if (step.depth() != 1) break block7;
                    List<HCLIdentifier> decl = block.declaration();
                    HCLIdentifier type = decl.get(0);
                    this.mark(type, ColoringAttributes.CLASS_SET);
                    if (decl.size() <= 1) break block8;
                    for (int i = 1; i < decl.size(); ++i) {
                        HCLIdentifier id = decl.get(i);
                        this.mark(id, ColoringAttributes.CONSTRUCTOR_SET);
                    }
                    break block8;
                }
                if (e instanceof HCLAttribute) {
                    HCLAttribute attr = (HCLAttribute)e;
                    this.mark(attr.name(), ColoringAttributes.FIELD_SET);
                } else if (e instanceof HCLFunction) {
                    HCLFunction func = (HCLFunction)e;
                    this.mark(func.name(), ColoringAttributes.CONSTRUCTOR_SET);
                } else if (e instanceof HCLCollection.Object) {
                    HCLCollection.Object obj = (HCLCollection.Object)e;
                    for (HCLCollection.ObjectElement oe : obj.elements()) {
                        if (!(oe.key() instanceof HCLVariable)) continue;
                        this.mark(oe.key(), ColoringAttributes.FIELD_SET);
                    }
                }
            }
        }
    }
}

