/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.completion;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.languages.neon.completion.Bundle;
import org.netbeans.modules.languages.neon.completion.NeonElement;
import org.netbeans.modules.languages.neon.parser.NeonParser;

public abstract class NeonCompletionProposal
implements CompletionProposal {
    private final NeonElement element;
    private final CompletionRequest request;

    public NeonCompletionProposal(NeonElement element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return this.request.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.element.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return this.getName().startsWith(this.request.prefix);
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.name(this.getKind(), true);
        formatter.appendText(this.getName());
        formatter.name(this.getKind(), false);
        return formatter.getText();
    }

    public String getCustomInsertTemplate() {
        return this.element.getTemplate();
    }

    public static class CompletionRequest {
        public int anchorOffset;
        public String prefix;
        public NeonParser.NeonParserResult parserResult;
    }

    static class MethodCompletionProposal
    extends NeonCompletionProposal {
        public MethodCompletionProposal(NeonElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            ElementHandle elementHandle = this.getElement();
            assert (elementHandle != null);
            return ((NeonElement)elementHandle).getType();
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    static class TypeCompletionProposal
    extends NeonCompletionProposal {
        public TypeCompletionProposal(NeonElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            ElementHandle elementHandle = this.getElement();
            assert (elementHandle != null);
            return ((NeonElement)elementHandle).getType();
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }
    }

    static class ServiceConfigOptCompletionProposal
    extends NeonCompletionProposal {
        public ServiceConfigOptCompletionProposal(NeonElement serviceDefinitionSwitch, CompletionRequest request) {
            super(serviceDefinitionSwitch, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.ConfigOptRhs();
        }

        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }
    }
}

