/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.platform;

import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.openide.util.Parameters;

public interface PlatformProvidersListener
extends EventListener {
    public void platformProvidersChanged();

    public void propertyChanged(@NullAllowed Project var1, @NonNull PlatformProvider var2, @NonNull PropertyChangeEvent var3);

    public static final class Support {
        private final List<PlatformProvidersListener> listeners = new CopyOnWriteArrayList<PlatformProvidersListener>();

        public void addPlatformProvidersListener(@NullAllowed PlatformProvidersListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removePlatformProvidersListener(@NullAllowed PlatformProvidersListener listener) {
            if (listener == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        public void firePlatformProvidersChanged() {
            for (PlatformProvidersListener listener : this.listeners) {
                listener.platformProvidersChanged();
            }
        }

        public void firePropertyChanged(@NullAllowed Project project, @NonNull PlatformProvider platformProvider, @NonNull PropertyChangeEvent event) {
            Parameters.notNull((CharSequence)"platformProvider", (Object)platformProvider);
            Parameters.notNull((CharSequence)"event", (Object)event);
            for (PlatformProvidersListener listener : this.listeners) {
                listener.propertyChanged(project, platformProvider, event);
            }
        }

        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }
    }
}

