/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.attach;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.api.DAPConfiguration;
import org.netbeans.modules.lsp.client.debugger.attach.Bundle;
import org.netbeans.modules.lsp.client.debugger.attach.DAPAttachPanel;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class DAPAttachType
extends AttachType {
    private static final RequestProcessor WORKER = new RequestProcessor(DAPAttachType.class.getName(), 1, false, false);
    private DAPAttachPanel panel;

    public JComponent getCustomizer() {
        if (this.panel == null) {
            this.panel = new DAPAttachPanel();
            this.panel.load(DAPAttachType.getPrivateSettings());
        }
        return this.panel;
    }

    public Controller getController() {
        return new PersistentController(){
            private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

            public boolean ok() {
                String hostname = DAPAttachType.this.panel.getHostName();
                int port = DAPAttachType.this.panel.getPort();
                DAPDebugger.Type connectionType = DAPAttachType.this.panel.getConnectionType();
                String configuration = DAPAttachType.this.panel.getJSONConfiguration();
                boolean delay = DAPAttachType.this.panel.getDelay();
                WORKER.post(() -> {
                    try {
                        Socket socket = new Socket(hostname, port);
                        DAPConfiguration dapConfig = DAPConfiguration.create(socket.getInputStream(), socket.getOutputStream());
                        if (!configuration.isBlank()) {
                            Map args = (Map)new Gson().fromJson(configuration, HashMap.class);
                            dapConfig.addConfiguration(args);
                        }
                        if (delay) {
                            dapConfig.delayLaunch();
                        }
                        switch (connectionType) {
                            case ATTACH: {
                                dapConfig.attach();
                                break;
                            }
                            case LAUNCH: {
                                dapConfig.launch();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown connection type: " + connectionType);
                            }
                        }
                    }
                    catch (JsonSyntaxException | IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
                return true;
            }

            public boolean cancel() {
                return true;
            }

            public boolean isValid() {
                return true;
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                this.pcs.addPropertyChangeListener(l);
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                this.pcs.removePropertyChangeListener(l);
            }

            public String getDisplayName() {
                return Bundle.DN_Default();
            }

            public boolean load(Properties props) {
                DAPAttachType.this.panel.load(props);
                return true;
            }

            public void save(Properties props) {
                DAPAttachType.this.panel.save(props);
                DAPAttachType.this.panel.save(DAPAttachType.getPrivateSettings());
            }
        };
    }

    private static Properties getPrivateSettings() {
        return Properties.getDefault().getProperties("debugger").getProperties("dap_attach_configuration");
    }
}

