/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.braces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class TwigBracesMatcher
implements BracesMatcher {
    private static final List<Matcher> MATCHERS = new ArrayList<Matcher>();
    private final MatcherContext context;

    private TwigBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int[] result = null;
        BaseDocument document = (BaseDocument)this.context.getDocument();
        document.readLock();
        try {
            result = this.findOriginUnderLock();
        }
        finally {
            document.readUnlock();
        }
        return result;
    }

    private int[] findOriginUnderLock() {
        int[] result = null;
        TokenSequence<? extends TwigBlockTokenId> ts = TwigLexerUtils.getTwigBlockTokenSequence(this.context.getDocument(), this.context.getSearchOffset());
        if (ts != null) {
            result = this.findOriginInSequence(ts);
        }
        return result;
    }

    private int[] findOriginInSequence(TokenSequence<? extends TwigBlockTokenId> ts) {
        TwigBlockTokenId currentTokenId;
        Token currentToken;
        int[] result = null;
        ts.move(this.context.getSearchOffset());
        if (ts.moveNext() && (currentToken = ts.token()) != null && (currentTokenId = (TwigBlockTokenId)currentToken.id()) == TwigBlockTokenId.T_TWIG_TAG) {
            result = new int[]{ts.offset(), ts.offset() + currentToken.length()};
        }
        return result;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        int[] result = null;
        BaseDocument document = (BaseDocument)this.context.getDocument();
        document.readLock();
        try {
            result = this.findMatchesUnderLock();
        }
        finally {
            document.readUnlock();
        }
        return result;
    }

    private int[] findMatchesUnderLock() {
        int[] result = null;
        TokenSequence<? extends TwigTopTokenId> topTs = TwigLexerUtils.getTwigTokenSequence(this.context.getDocument(), this.context.getSearchOffset());
        if (topTs != null) {
            result = this.findMatchesInTopSequence(topTs);
        }
        return result;
    }

    private int[] findMatchesInTopSequence(TokenSequence<? extends TwigTopTokenId> topTs) {
        assert (topTs != null);
        int[] result = null;
        topTs.move(this.context.getSearchOffset());
        topTs.moveNext();
        TokenSequence ts = topTs.embeddedJoined(TwigBlockTokenId.language());
        if (ts != null) {
            result = this.findMatchesInEmbeddedSequence(topTs, (TokenSequence<TwigBlockTokenId>)ts);
        }
        return result;
    }

    private int[] findMatchesInEmbeddedSequence(TokenSequence<? extends TwigTopTokenId> topTs, TokenSequence<TwigBlockTokenId> embeddedTs) {
        Token currentToken;
        int[] result = null;
        embeddedTs.move(this.context.getSearchOffset());
        if (embeddedTs.moveNext() && (currentToken = embeddedTs.token()) != null) {
            result = this.processMatchers((Token<? extends TwigBlockTokenId>)currentToken, topTs);
        }
        return result;
    }

    private int[] processMatchers(Token<? extends TwigBlockTokenId> currentToken, TokenSequence<? extends TwigTopTokenId> topTs) {
        int[] result = null;
        for (Matcher matcher : MATCHERS) {
            if (!matcher.matches(currentToken)) continue;
            result = matcher.findMatches(currentToken, topTs);
            break;
        }
        return result;
    }

    private static int[] createMatches(List<OffsetRange> offsetRanges) {
        int[] result = null;
        if (!offsetRanges.isEmpty()) {
            int resultSize = offsetRanges.size() * 2;
            result = new int[resultSize];
            int i = 0;
            int j = 0;
            while (i < offsetRanges.size()) {
                result[j] = offsetRanges.get(i).getStart();
                result[j + 1] = offsetRanges.get(i).getEnd();
                ++i;
                j += 2;
            }
        }
        return result;
    }

    static {
        MATCHERS.add(new StartEndBlockMatcher("autoescape"));
        MATCHERS.add(new StartEndBlockMatcher("block"));
        MATCHERS.add(new StartEndBlockMatcher("embed"));
        MATCHERS.add(new StartEndBlockMatcher("filter"));
        MATCHERS.add(new StartEndBlockMatcher("for"));
        MATCHERS.add(new StartEndBlockMatcher("macro"));
        MATCHERS.add(new StartEndBlockMatcher("raw"));
        MATCHERS.add(new StartEndBlockMatcher("sandbox"));
        MATCHERS.add(new StartEndBlockMatcher("set"));
        MATCHERS.add(new StartEndBlockMatcher("spaceless"));
        MATCHERS.add(new StartEndBlockMatcher("verbatim"));
        MATCHERS.add(new IfMatcher());
        MATCHERS.add(new EndIfMatcher());
        MATCHERS.add(new ElseMatcher());
        MATCHERS.add(new ElseIfMatcher());
    }

    private static interface Matcher {
        public boolean matches(Token<? extends TwigBlockTokenId> var1);

        public int[] findMatches(Token<? extends TwigBlockTokenId> var1, TokenSequence<? extends TwigTopTokenId> var2);
    }

    private static final class StartEndBlockMatcher
    implements Matcher {
        private static final String END = "end";
        private final String blockName;

        public StartEndBlockMatcher(String blockName) {
            assert (blockName != null);
            this.blockName = blockName;
        }

        @Override
        public boolean matches(Token<? extends TwigBlockTokenId> token) {
            assert (token != null);
            return token.id() == TwigBlockTokenId.T_TWIG_TAG && (this.blockName.equals(token.text().toString()) || (END + this.blockName).equals(token.text().toString()));
        }

        @Override
        public int[] findMatches(Token<? extends TwigBlockTokenId> token, TokenSequence<? extends TwigTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            int[] result = null;
            String tagText = token.text().toString();
            if (tagText.equals(this.blockName)) {
                List<OffsetRange> offsetRanges = TwigLexerUtils.findForwardMatching(topTs, TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, this.blockName), TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, END + this.blockName));
                result = TwigBracesMatcher.createMatches(offsetRanges);
            } else if (tagText.equals(END + this.blockName)) {
                List<OffsetRange> offsetRanges = TwigLexerUtils.findBackwardMatching(topTs, TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, END + this.blockName), TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, this.blockName));
                result = TwigBracesMatcher.createMatches(offsetRanges);
            }
            return result;
        }
    }

    private static final class IfMatcher
    extends IfConditionMatcher {
        private IfMatcher() {
        }

        @Override
        protected TwigLexerUtils.TwigTokenText matchingToken() {
            return IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends TwigBlockTokenId> token, TokenSequence<? extends TwigTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = TwigLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            return TwigBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class EndIfMatcher
    extends IfConditionMatcher {
        private EndIfMatcher() {
        }

        @Override
        protected TwigLexerUtils.TwigTokenText matchingToken() {
            return END_IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends TwigBlockTokenId> token, TokenSequence<? extends TwigTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = TwigLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            return TwigBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class ElseMatcher
    extends IfConditionMatcher {
        private ElseMatcher() {
        }

        @Override
        protected TwigLexerUtils.TwigTokenText matchingToken() {
            return ELSE_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends TwigBlockTokenId> token, TokenSequence<? extends TwigTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = TwigLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            offsetRanges.addAll(TwigLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(TwigLexerUtils.TwigTokenText.NONE)));
            return TwigBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class ElseIfMatcher
    extends IfConditionMatcher {
        private ElseIfMatcher() {
        }

        @Override
        protected TwigLexerUtils.TwigTokenText matchingToken() {
            return ELSE_IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends TwigBlockTokenId> token, TokenSequence<? extends TwigTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = TwigLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            offsetRanges.addAll(TwigLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN)));
            return TwigBracesMatcher.createMatches(offsetRanges);
        }
    }

    public static final class Factory
    implements BracesMatcherFactory {
        public BracesMatcher createMatcher(MatcherContext context) {
            return new TwigBracesMatcher(context);
        }
    }

    private static abstract class IfConditionMatcher
    implements Matcher {
        protected static final TwigLexerUtils.TwigTokenText IF_TOKEN = TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, "if");
        protected static final TwigLexerUtils.TwigTokenText ELSE_IF_TOKEN = TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, "elseif");
        protected static final TwigLexerUtils.TwigTokenText ELSE_TOKEN = TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, "else");
        protected static final TwigLexerUtils.TwigTokenText END_IF_TOKEN = TwigLexerUtils.TwigTokenTextImpl.create(TwigBlockTokenId.T_TWIG_TAG, "endif");

        private IfConditionMatcher() {
        }

        @Override
        public boolean matches(Token<? extends TwigBlockTokenId> token) {
            return this.matchingToken().matches(token);
        }

        protected abstract TwigLexerUtils.TwigTokenText matchingToken();
    }
}

