/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.AudioUtil;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class AudioMarker
extends ButtonMarker {
    private final URL audioUrl;
    private static volatile AudioMarker recentlyPlayedMarker;
    public double syncOffset;
    public boolean timeFromAudio;

    public AudioMarker(LatLon ll, TemplateEngineDataProvider dataProvider, URL audioUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, dataProvider, "speech", parentLayer, time, offset);
        this.audioUrl = audioUrl;
        this.syncOffset = 0.0;
        this.timeFromAudio = false;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.play();
    }

    public static AudioMarker recentlyPlayedMarker() {
        return recentlyPlayedMarker;
    }

    static void resetRecentlyPlayedMarker() {
        recentlyPlayedMarker = null;
    }

    public URL url() {
        return this.audioUrl;
    }

    public void play(double after) {
        try {
            MainApplication.getMap().mapView.playHeadMarker.animate();
            AudioPlayer.play(this.audioUrl, this.offset + this.syncOffset + after);
            recentlyPlayedMarker = this;
        }
        catch (IOException | InterruptedException e) {
            AudioUtil.audioMalfunction(e);
        }
    }

    public void play() {
        this.play(0.0);
    }

    public void adjustOffset(double adjustment) {
        this.syncOffset = adjustment;
    }

    public double syncOffset() {
        return this.syncOffset;
    }

    @Override
    protected Marker.TemplateEntryProperty getTextTemplate() {
        return Marker.TemplateEntryProperty.forAudioMarker(this.parentLayer.getName());
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wpt = super.convertToWayPoint();
        GpxLink link = new GpxLink(this.audioUrl.toString());
        link.type = "audio";
        wpt.put("meta.links", Collections.singleton(link));
        wpt.addExtension("offset", Double.toString(this.offset));
        wpt.addExtension("sync-offset", Double.toString(this.syncOffset));
        return wpt;
    }
}

