/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

class DataFlowBitSet {
    private int[] itsBits;
    private int itsSize;

    DataFlowBitSet(int n) {
        this.itsSize = n;
        this.itsBits = new int[n + 31 >> 5];
    }

    void set(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] | 1 << (n & 0x1F);
    }

    boolean test(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        return (this.itsBits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    void not() {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            this.itsBits[n2] = ~this.itsBits[n2];
            ++n2;
        }
    }

    void clear(int n) {
        if (n < 0 || n >= this.itsSize) {
            this.badIndex(n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] & ~(1 << (n & 0x1F));
    }

    void clear() {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            this.itsBits[n2] = 0;
            ++n2;
        }
    }

    void or(DataFlowBitSet dataFlowBitSet) {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.itsBits[n3] = this.itsBits[n3] | dataFlowBitSet.itsBits[n2];
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataFlowBitSet, size = ");
        stringBuffer.append(this.itsSize);
        stringBuffer.append('\n');
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Integer.toHexString(this.itsBits[n2]));
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    boolean df(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.itsBits[n2];
            this.itsBits[n2] = (dataFlowBitSet.itsBits[n2] | dataFlowBitSet2.itsBits[n2]) & dataFlowBitSet3.itsBits[n2];
            bl |= n3 != this.itsBits[n2];
            ++n2;
        }
        return bl;
    }

    boolean df2(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.itsBits[n2];
            this.itsBits[n2] = dataFlowBitSet.itsBits[n2] & dataFlowBitSet3.itsBits[n2] | dataFlowBitSet2.itsBits[n2];
            bl |= n3 != this.itsBits[n2];
            ++n2;
        }
        return bl;
    }

    private void badIndex(int n) {
        throw new RuntimeException("DataFlowBitSet bad index " + n);
    }
}

