/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.MissionAIPlayer;
import net.sf.freecol.server.ai.mission.Mission;

public final class IndianDemandMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianDemandMission.class.getName());
    public static final String TAG = "indianDemandMission";
    private static final int GOODS_DEMAND_MIN = 30;
    private static final String tag = "AI native demander";
    private static final List<Predicate<GoodsType>> selectPredicates = new ArrayList<Predicate<GoodsType>>();
    private Colony colony;
    private boolean demanded;
    private boolean succeeded;
    private static final String COLONY_TAG = "colony";
    private static final String DEMANDED_TAG = "demanded";
    private static final String SUCCEEDED_TAG = "succeeded";

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        this.succeeded = false;
        this.demanded = false;
    }

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private boolean hasTribute() {
        return IndianDemandMission.hasMissionTribute(this.getAIUnit());
    }

    private static boolean hasMissionTribute(AIUnit aiUnit) {
        return aiUnit.getUnit().hasGoodsCargo();
    }

    public void setSucceeded(boolean result) {
        this.succeeded = result;
    }

    private Goods selectGoods(Colony target) {
        GoodsType goodsType;
        Specification spec = this.getSpecification();
        List<GoodsType> goodsTypes = CollectionUtils.transform(spec.getGoodsTypeList(), gt -> target.getGoodsCount((GoodsType)gt) > 0);
        int dx = spec.getInteger("model.option.nativeDemands") + 1;
        Game game = target.getGame();
        Market market = target.getOwner().getMarket();
        Comparator<Goods> marketPrice = Comparator.comparingInt(g -> market.getSalePrice(g));
        Function<Goods, Goods> makeGoods = g -> new Goods(game, target, g.getType(), this.capAmount(g.getAmount(), dx));
        Tension.Level tension = this.getUnit().getOwner().getTension(target.getOwner()).getLevel();
        GoodsType food = spec.getPrimaryFoodType();
        int cutoff = this.capAmount(target.getGoodsCount(food), dx);
        Goods goods = null;
        if (tension.compareTo(Tension.Level.CONTENT) <= 0 && target.getGoodsCount(food) >= cutoff) {
            goods = new Goods(this.getGame(), target, food, cutoff);
        }
        if (goods == null && tension.compareTo(Tension.Level.DISPLEASED) <= 0) {
            Predicate<Goods> angryPred = g -> !g.isFoodType() && !g.getType().getMilitary();
            goods = CollectionUtils.maximize(target.getCompactGoodsList(), angryPred, marketPrice);
            if (goods != null) {
                goods = makeGoods.apply(goods);
            }
        }
        if (goods == null && (goodsType = (GoodsType)CollectionUtils.first(CollectionUtils.flatten(selectPredicates, pred -> CollectionUtils.transform(goodsTypes, gt -> pred.test(gt)).stream()))) != null) {
            goods = new Goods(this.getGame(), target, goodsType, this.capAmount(target.getGoodsCount(goodsType), dx));
        }
        if (goods == null && (goods = CollectionUtils.maximize(target.getCompactGoodsList(), marketPrice)) != null) {
            goods = makeGoods.apply(goods);
        }
        return goods;
    }

    private int capAmount(int amount, int difficulty) {
        return Math.min(Math.max(amount * difficulty / 6, 30), 100);
    }

    private static IndianSettlement getHome(AIUnit aiUnit) {
        return aiUnit.getUnit().getHomeIndianSettlement();
    }

    private static String invalidUnitReason(AIUnit aiUnit) {
        IndianSettlement home;
        String reason = IndianDemandMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((home = IndianDemandMission.getHome(aiUnit)) == null || home.isDisposed() ? "home-destroyed" : null);
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        String reason = IndianDemandMission.invalidTargetReason(colony);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        Player owner = unit.getOwner();
        Player targetPlayer = colony.getOwner();
        switch (owner.getStance(targetPlayer)) {
            case UNCONTACTED: 
            case PEACE: 
            case ALLIANCE: {
                return "bad-stance";
            }
            case WAR: 
            case CEASE_FIRE: {
                Tension tension = unit.getHomeIndianSettlement().getAlarm(targetPlayer);
                if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) > 0) break;
                return "happy";
            }
        }
        return null;
    }

    public static String invalidMissionReason(AIUnit aiUnit) {
        return IndianDemandMission.invalidUnitReason(aiUnit);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = IndianDemandMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Colony ? IndianDemandMission.invalidColonyReason(aiUnit, (Colony)loc) : (loc instanceof IndianSettlement ? IndianDemandMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : "target-invalid"));
    }

    @Override
    public Location getTransportDestination() {
        return null;
    }

    @Override
    public Location getTarget() {
        return this.demanded && this.succeeded ? this.getUnit().getHomeIndianSettlement() : this.colony;
    }

    @Override
    public void setTarget(Location target) {
        if (target instanceof Colony) {
            this.colony = (Colony)target;
        }
    }

    @Override
    public Location findTarget() {
        return this.getTarget();
    }

    @Override
    public String invalidReason() {
        return IndianDemandMission.invalidMissionReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        IndianSettlement is = unit.getHomeIndianSettlement();
        if (!this.demanded) {
            int amount;
            Unit.MoveType mt = this.travelToTarget(this.getTarget(), null, lb);
            switch (mt) {
                case MOVE_HIGH_SEAS: 
                case MOVE_NO_MOVES: 
                case MOVE_ILLEGAL: {
                    return this.lbWait(lb, new Object[0]);
                }
                case MOVE_NO_REPAIR: {
                    return this.lbFail(lb, false, "aiUnit-died");
                }
                case MOVE_NO_TILE: {
                    return this;
                }
                case ATTACK_SETTLEMENT: {
                    Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                    if (d != null) break;
                }
                case ATTACK_UNIT: {
                    Location blocker = IndianDemandMission.resolveBlockage(aiUnit, this.getTarget());
                    if (blocker == null) {
                        this.moveRandomly(tag, null);
                        return this.lbWait(lb, new Object[0]);
                    }
                    Direction d = unit.getTile().getDirection(blocker.getTile());
                    return AIMessage.askAttack(aiUnit, d) ? this.lbAttack(lb, blocker) : this.lbWait(lb, new Object[0]);
                }
                default: {
                    return this.lbMove(lb, mt);
                }
            }
            this.lbAt(lb);
            MissionAIPlayer aiPlayer = this.getAIPlayer();
            Colony colony = (Colony)this.getTarget();
            Player enemy = colony.getOwner();
            Goods goods = this.selectGoods(colony);
            GoodsType type = goods == null ? null : goods.getType();
            int n = amount = goods == null ? 0 : goods.getAmount();
            if (goods == null) {
                if (!enemy.checkGold(1)) {
                    return this.lbDone(lb, false, "empty handed");
                }
                amount = enemy.getGold() / 20;
                if (amount == 0) {
                    amount = enemy.getGold();
                }
            }
            this.demanded = AIMessage.askIndianDemand(aiPlayer, unit, colony, type, amount, null);
            lb.add(", demand made ", this.demanded ? "" : "un", "successfully");
            return this.lbWait(lb, new Object[0]);
        }
        if (!this.succeeded) {
            Colony colony = (Colony)this.getTarget();
            Player enemy = colony.getOwner();
            int unitTension = is == null ? 0 : is.getAlarm(enemy).getValue();
            int tension = Math.max(unitTension, unit.getOwner().getTension(enemy).getValue());
            Direction d = unit.getTile().getDirection(colony.getTile());
            if (d != null && tension >= Tension.Level.CONTENT.getLimit() && AIMessage.askAttack(aiUnit, d)) {
                this.lbAttack(lb, colony);
            }
            return this.lbDone(lb, false, "refused at ", colony);
        }
        if (!this.hasTribute()) {
            return this.lbDone(lb, true, "accepted gold at ", this.colony);
        }
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                break;
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_REPAIR: {
                return this.lbFail(lb, false, "aiUnit-died");
            }
            case MOVE_NO_TILE: {
                return this;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        GoodsContainer container = unit.getGoodsContainer();
        for (Goods goods : container.getCompactGoodsList()) {
            Goods tribute = container.removeGoods(goods.getType());
            is.addGoods(tribute);
        }
        return this.lbDone(lb, false, "unloaded tribute");
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.colony != null) {
            xw.writeAttribute(COLONY_TAG, this.colony.getId());
        }
        xw.writeAttribute(DEMANDED_TAG, this.demanded);
        xw.writeAttribute(SUCCEEDED_TAG, this.succeeded);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.getAttribute(this.getGame(), COLONY_TAG, Colony.class, (Colony)null);
        this.demanded = xr.getAttribute(DEMANDED_TAG, false);
        this.succeeded = xr.getAttribute(SUCCEEDED_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    static {
        selectPredicates.add(GoodsType::getMilitary);
        selectPredicates.add(GoodsType::isBuildingMaterial);
        selectPredicates.add(GoodsType::isTradeGoods);
        selectPredicates.add(GoodsType::isRefined);
    }
}

