/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class XPIconPatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsXP() && env.isWindowsLookAndFeel();
    }

    private Object getIcon(Environment env, String baseName) {
        StringBuffer iconName = new StringBuffer(baseName.length() + 16);
        iconName.append("image/");
        iconName.append(baseName);
        if (!env.isAlphaIconCapable()) {
            iconName.append("-8bit.png");
        } else {
            iconName.append(".png");
        }
        return LookAndFeel.makeIcon(this.getClass(), iconName.toString());
    }

    public void patch(Environment env) {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("Tree.openIcon", this.getIcon(env, "xpfolder-open"));
        defaults.put("Tree.closedIcon", this.getIcon(env, "xpfolder"));
        defaults.put("OptionPane.errorIcon", this.getIcon(env, "msgbox-error"));
        defaults.put("OptionPane.warningIcon", this.getIcon(env, "msgbox-warn"));
        defaults.put("OptionPane.informationIcon", this.getIcon(env, "msgbox-info"));
    }

    public void unpatch() {
    }
}

