/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.ThreadStateNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.threads.ThreadStateIcon;

public class ThreadStateNodeRenderer
extends LabelRenderer
implements HeapViewerRenderer {
    private static final Icon ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final int THREAD_ICON_SIZE = 9;
    private static final Map<Thread.State, Icon> STATE_ICONS_CACHE = new HashMap<Thread.State, Icon>();

    public ThreadStateNodeRenderer() {
        this.setIcon(ICON);
        this.setFont(this.getFont().deriveFont(1));
    }

    public void setValue(Object value, int row) {
        ThreadStateNode node = (ThreadStateNode)((Object)value);
        this.setText(node.getName());
        this.setIcon(ThreadStateNodeRenderer.getIcon(node.getState()));
    }

    @Override
    public String getShortName() {
        return this.getText();
    }

    private static Icon getIcon(Thread.State state) {
        Icon icon = STATE_ICONS_CACHE.get((Object)state);
        if (icon == null) {
            int pState;
            switch (state) {
                case RUNNABLE: {
                    pState = 1;
                    break;
                }
                case BLOCKED: {
                    pState = 3;
                    break;
                }
                case WAITING: {
                    pState = 4;
                    break;
                }
                case TIMED_WAITING: {
                    pState = 2;
                    break;
                }
                default: {
                    pState = -1;
                }
            }
            icon = new ThreadStateIcon(pState, 9, 9);
            STATE_ICONS_CACHE.put(state, icon);
        }
        return icon;
    }
}

