/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.TypeConversionHandler;

public class MethodMap {
    private static final int INCOMPARABLE = 0;
    private static final int MORE_SPECIFIC = 1;
    private static final int EQUIVALENT = 2;
    private static final int LESS_SPECIFIC = 3;
    private static final int NOT_CONVERTIBLE = 0;
    private static final int EXPLICITLY_CONVERTIBLE = 1;
    private static final int IMPLCITLY_CONVERTIBLE = 2;
    private static final int STRICTLY_CONVERTIBLE = 3;
    private static final Method TRY_SET_ACCESSIBLE = MethodUtils.getMethodObject(Method.class, (String)"trySetAccessible", (Class[])new Class[0]);
    TypeConversionHandler conversionHandler;
    Map<String, List<Method>> methodByNameMap = new ConcurrentHashMap<String, List<Method>>();

    public MethodMap() {
        this(null);
    }

    public MethodMap(TypeConversionHandler conversionHandler) {
        this.conversionHandler = conversionHandler;
    }

    public void add(Method method) {
        String methodName = method.getName();
        List<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List<Method> get(String key) {
        return this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List<Method> methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        for (int i = 0; i < l; ++i) {
            Object arg = args[i];
            classes[i] = arg == null ? null : arg.getClass();
        }
        return this.getBestMatch(methodList, classes);
    }

    private static boolean onlyNullOrObjects(Class<?>[] args) {
        for (Class<?> cls : args) {
            if (cls == null || cls == Object.class) continue;
            return false;
        }
        return args.length > 0;
    }

    private Method getBestMatch(List<Method> methods, Class<?>[] args) {
        LinkedList<Match> bestMatches = new LinkedList<Match>();
        Class[] unboxedArgs = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            unboxedArgs[i] = IntrospectionUtils.getUnboxedClass(args[i]);
        }
        for (Method method : methods) {
            int applicability = this.getApplicability(method, unboxedArgs);
            if (applicability <= 0) continue;
            Match match = new Match(method, applicability, unboxedArgs);
            if (bestMatches.size() == 0) {
                bestMatches.add(match);
                continue;
            }
            boolean keepMethod = true;
            ListIterator it = bestMatches.listIterator();
            while (keepMethod && it.hasNext()) {
                Match best = (Match)it.next();
                if (best.specificity == 3 && match.specificity < 2) {
                    keepMethod = false;
                    continue;
                }
                if (match.specificity == 3 && best.specificity < 2) {
                    it.remove();
                    continue;
                }
                if (best.applicability > match.applicability) {
                    keepMethod = false;
                    continue;
                }
                if (best.applicability < match.applicability) {
                    it.remove();
                    continue;
                }
                if (MethodMap.onlyNullOrObjects(args)) {
                    if (match.varargs == best.varargs) continue;
                    if (match.varargs) {
                        keepMethod = false;
                        continue;
                    }
                    if (!best.varargs) continue;
                    it.remove();
                    continue;
                }
                switch (this.compare(match.methodTypes, best.methodTypes)) {
                    case 3: {
                        keepMethod = false;
                        break;
                    }
                    case 1: {
                        it.remove();
                        break;
                    }
                    case 0: {
                        if (match.varargs == best.varargs) break;
                        if (match.varargs) {
                            keepMethod = false;
                            break;
                        }
                        if (!best.varargs) break;
                        it.remove();
                        break;
                    }
                }
            }
            if (!keepMethod) continue;
            bestMatches.add(match);
        }
        switch (bestMatches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return MethodMap.getAccessibleMethodDeclaration(((Match)bestMatches.get((int)0)).method);
            }
        }
        throw new AmbiguousException();
    }

    public static Method getAccessibleMethodDeclaration(Method method) {
        if (Modifier.isStatic(method.getModifiers()) || MethodMap.canAccess(method)) {
            return method;
        }
        Class<?> clazz = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] arguments = method.getParameterTypes();
        while (clazz != null) {
            Class<?> superClass = null;
            Method superMethod = null;
            superClass = clazz.getSuperclass();
            if (superClass != null) {
                try {
                    superMethod = superClass.getDeclaredMethod(name, arguments);
                    if (!MethodMap.canAccess(superMethod)) {
                        superMethod = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (superMethod == null) {
                Class<?>[] interfaces;
                for (Class<?> intf : interfaces = clazz.getInterfaces()) {
                    try {
                        superMethod = intf.getDeclaredMethod(name, arguments);
                        if (superMethod == null) continue;
                        superClass = intf;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (superMethod != null) {
                method = superMethod;
            }
            clazz = superClass;
        }
        return method;
    }

    private static boolean canAccess(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            if (method.isAccessible()) {
                return true;
            }
            if (MethodMap.trySetAccessible(method)) {
                method.setAccessible(false);
                return true;
            }
        }
        return false;
    }

    private static boolean trySetAccessible(Method method) {
        boolean accessible = false;
        try {
            if (TRY_SET_ACCESSIBLE != null) {
                accessible = (Boolean)TRY_SET_ACCESSIBLE.invoke((Object)method, new Object[0]);
            } else {
                method.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessible;
    }

    private int compare(Type[] t1, Type[] t2) {
        boolean last2Array;
        int i;
        Type itemType;
        boolean t1IsVararag = false;
        boolean t2IsVararag = false;
        boolean fixedLengths = false;
        if (t1.length > t2.length) {
            int l2 = t2.length;
            if (l2 == 0) {
                return 1;
            }
            itemType = TypeUtils.getArrayComponentType((Type)(t2 = Arrays.copyOf(t2, t1.length))[l2 - 1]);
            if (itemType == null) {
                t1IsVararag = true;
                t2[t1.length - 1] = null;
            } else {
                t2IsVararag = true;
                for (i = l2 - 1; i < t1.length; ++i) {
                    t2[i] = itemType;
                }
            }
            fixedLengths = true;
        } else if (t2.length > t1.length) {
            int l1 = t1.length;
            if (l1 == 0) {
                return 3;
            }
            itemType = TypeUtils.getArrayComponentType((Type)(t1 = Arrays.copyOf(t1, t2.length))[l1 - 1]);
            if (itemType == null) {
                t2IsVararag = true;
                t1[t2.length - 1] = null;
            } else {
                t1IsVararag = true;
                for (i = l1 - 1; i < t2.length; ++i) {
                    t1[i] = itemType;
                }
            }
            fixedLengths = true;
        }
        int fromC1toC2 = 3;
        int fromC2toC1 = 3;
        for (i = 0; i < t1.length; ++i) {
            boolean last;
            Class<?> c1 = t1[i] == null ? null : IntrospectionUtils.getTypeClass(t1[i]);
            Class<?> c2 = t2[i] == null ? null : IntrospectionUtils.getTypeClass(t2[i]);
            boolean bl = last = !fixedLengths && i == t1.length - 1;
            if (!(t1[i] == null && t2[i] != null || t1[i] != null && t2[i] == null) && t1[i].equals(t2[i])) continue;
            if (t1[i] == null) {
                fromC2toC1 = 0;
                if (c2 == null || !c2.isPrimitive()) continue;
                fromC1toC2 = 0;
                continue;
            }
            if (t2[i] == null) {
                fromC1toC2 = 0;
                if (c1 == null || !c1.isPrimitive()) continue;
                fromC2toC1 = 0;
                continue;
            }
            if (c1 != null) {
                switch (fromC1toC2) {
                    case 3: {
                        if (MethodMap.isStrictConvertible(t2[i], c1, last)) break;
                        fromC1toC2 = 2;
                    }
                    case 2: {
                        if (this.isConvertible(t2[i], c1, last)) break;
                        fromC1toC2 = 1;
                    }
                    case 1: {
                        if (this.isExplicitlyConvertible(t2[i], c1, last)) break;
                        fromC1toC2 = 0;
                    }
                }
            } else if (fromC1toC2 > 0) {
                int n = fromC1toC2 = TypeUtils.isAssignable((Type)t1[i], (Type)t2[i]) ? Math.min(fromC1toC2, 2) : 0;
            }
            if (c2 != null) {
                switch (fromC2toC1) {
                    case 3: {
                        if (MethodMap.isStrictConvertible(t1[i], c2, last)) break;
                        fromC2toC1 = 2;
                    }
                    case 2: {
                        if (this.isConvertible(t1[i], c2, last)) break;
                        fromC2toC1 = 1;
                    }
                    case 1: {
                        if (this.isExplicitlyConvertible(t1[i], c2, last)) break;
                        fromC2toC1 = 0;
                    }
                }
                continue;
            }
            if (fromC2toC1 <= 0) continue;
            fromC2toC1 = TypeUtils.isAssignable((Type)t2[i], (Type)t1[i]) ? Math.min(fromC2toC1, 2) : 0;
        }
        if (fromC1toC2 == 0 && fromC2toC1 == 0) {
            return 0;
        }
        if (fromC1toC2 > fromC2toC1) {
            return 1;
        }
        if (fromC2toC1 > fromC1toC2) {
            return 3;
        }
        boolean last1Array = t1IsVararag || !fixedLengths && TypeUtils.isArrayType((Type)t1[t1.length - 1]);
        boolean bl = last2Array = t2IsVararag || !fixedLengths && TypeUtils.isArrayType((Type)t2[t2.length - 1]);
        if (last1Array && !last2Array) {
            return 3;
        }
        if (!last1Array && last2Array) {
            return 1;
        }
        return 2;
    }

    private int getApplicability(Method method, Class<?>[] classes) {
        Type[] methodArgs = method.getGenericParameterTypes();
        int ret = 3;
        if (methodArgs.length > classes.length) {
            if (methodArgs.length == classes.length + 1 && TypeUtils.isArrayType((Type)methodArgs[methodArgs.length - 1])) {
                for (int i = 0; i < classes.length; ++i) {
                    if (MethodMap.isStrictConvertible(methodArgs[i], classes[i], false)) continue;
                    if (this.isConvertible(methodArgs[i], classes[i], false)) {
                        ret = Math.min(ret, 2);
                        continue;
                    }
                    if (this.isExplicitlyConvertible(methodArgs[i], classes[i], false)) {
                        ret = Math.min(ret, 1);
                        continue;
                    }
                    return 0;
                }
                return ret;
            }
            return 0;
        }
        if (methodArgs.length == classes.length) {
            for (int i = 0; i < classes.length; ++i) {
                boolean possibleVararg;
                boolean bl = possibleVararg = i == classes.length - 1 && TypeUtils.isArrayType((Type)methodArgs[i]);
                if (MethodMap.isStrictConvertible(methodArgs[i], classes[i], possibleVararg)) continue;
                if (this.isConvertible(methodArgs[i], classes[i], possibleVararg)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(methodArgs[i], classes[i], possibleVararg)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            return ret;
        }
        if (methodArgs.length > 0) {
            Type lastarg = methodArgs[methodArgs.length - 1];
            if (!TypeUtils.isArrayType((Type)lastarg)) {
                return 0;
            }
            for (int i = 0; i < methodArgs.length - 1; ++i) {
                if (MethodMap.isStrictConvertible(methodArgs[i], classes[i], false)) continue;
                if (this.isConvertible(methodArgs[i], classes[i], false)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(methodArgs[i], classes[i], false)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            Type vararg = TypeUtils.getArrayComponentType((Type)lastarg);
            for (int i = methodArgs.length - 1; i < classes.length; ++i) {
                if (MethodMap.isStrictConvertible(vararg, classes[i], false)) continue;
                if (this.isConvertible(vararg, classes[i], false)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(vararg, classes[i], false)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            return ret;
        }
        return 0;
    }

    private boolean isConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    private static boolean isStrictConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return IntrospectionUtils.isStrictMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    private boolean isExplicitlyConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return this.conversionHandler != null && this.conversionHandler.isExplicitlyConvertible(formal, actual, possibleVarArg);
    }

    private class Match {
        Method method;
        Type[] methodTypes;
        int specificity;
        int applicability;
        boolean varargs;

        Match(Method method, int applicability, Class<?>[] unboxedArgs) {
            this.method = method;
            this.applicability = applicability;
            this.methodTypes = method.getGenericParameterTypes();
            this.specificity = MethodMap.this.compare(this.methodTypes, unboxedArgs);
            this.varargs = this.methodTypes.length > 0 && TypeUtils.isArrayType((Type)this.methodTypes[this.methodTypes.length - 1]);
        }
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551663L;
    }
}

