
use builtin;
use str;

set edit:completion:arg-completer[sq] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'sq'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'sq'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand encrypt 'Encrypt a message'
            cand decrypt 'Decrypt a message'
            cand sign 'Sign messages or data files'
            cand verify 'Verify signed messages or detached signatures'
            cand download 'Download and authenticate the data'
            cand inspect 'Inspect data, like file(1)'
            cand cert 'Manage certificates'
            cand key 'Manage keys'
            cand pki 'Authenticate certs using the Web of Trust'
            cand network 'Retrieve and publish certificates over the network'
            cand keyring 'Manage collections of keys or certs'
            cand packet 'Low-level packet manipulation'
            cand config 'Query, inspect, and create the configuration file'
            cand version 'Detailed version and output version information'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'sq;encrypt'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --for 'Use certificates with the specified fingerprint or key ID'
            cand --for-userid 'Use certificates with the specified user ID'
            cand --for-email 'Use certificates where a user ID includes the specified email address'
            cand --for-file 'Read certificates from PATH'
            cand --with-password-file 'File containing password to encrypt the message'
            cand --set-metadata-filename 'Set the filename of the encrypted file as metadata'
            cand --signer 'Sign the message using the key with the specified fingerprint or key ID'
            cand --signer-userid 'Sign the message using the key with the specified user ID'
            cand --signer-email 'Sign the message using the key where a user ID includes the specified email address'
            cand --signer-file 'Sign the message using the key read from PATH'
            cand --signature-notation 'Add a notation to the signature'
            cand --encrypt-for 'Select what kind of keys are considered for encryption'
            cand --compression 'Select compression scheme to use'
            cand --profile 'Select the default OpenPGP standard for the encryption container'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --binary 'Emit binary data'
            cand --for-self 'Encrypt the message for yourself'
            cand --with-password 'Prompt to add a password to encrypt with'
            cand --signer-self 'Sign using your default signer keys'
            cand --without-signature 'Do not sign the message'
            cand --use-expired-subkey 'Fall back to expired encryption subkeys'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;decrypt'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --signatures 'Set the threshold of valid signatures to N'
            cand --signer 'Require a signature from a certificate with the specified fingerprint or key ID'
            cand --signer-userid 'Require a signature from a certificate with the specified user ID'
            cand --signer-email 'Require a signature from a certificate where a user ID includes the specified email address'
            cand --signer-domain 'Require a signature from a certificate where a user ID includes an email address for the specified domain'
            cand --signer-file 'Require a signature from a certificate read from PATH'
            cand --recipient-file 'Decrypt the message using the key in KEY_FILE'
            cand --session-key 'Decrypt an encrypted message using SESSION-KEY'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --dump-session-key 'Print the session key to stderr'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;sign'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --signature-file 'Create a detached signature file'
            cand --mode 'Select the signature mode'
            cand --merge 'Merge signatures from the input and SIGNED-MESSAGE'
            cand --signer 'Create the signature using the key with the specified fingerprint or key ID'
            cand --signer-userid 'Create the signature using the key with the specified user ID'
            cand --signer-email 'Create the signature using the key where a user ID includes the specified email address'
            cand --signer-file 'Create the signature using the key read from PATH'
            cand --signature-notation 'Add a notation to the signature'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --binary 'Emit binary data'
            cand --message 'Create an inline-signed message'
            cand --cleartext 'Create a cleartext-signed message'
            cand --append 'Append a signature to existing signature'
            cand --notarize 'Sign a message and all existing signatures'
            cand --signer-self 'Sign using your default signer keys'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;verify'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --signature-file 'Verify a detached signature file'
            cand --signatures 'Set the threshold of valid signatures to N'
            cand --signer 'Require a signature from a certificate with the specified fingerprint or key ID'
            cand --signer-userid 'Require a signature from a certificate with the specified user ID'
            cand --signer-email 'Require a signature from a certificate where a user ID includes the specified email address'
            cand --signer-domain 'Require a signature from a certificate where a user ID includes an email address for the specified domain'
            cand --signer-file 'Require a signature from a certificate read from PATH'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --message 'Verify an inline signed message'
            cand --cleartext 'Verify a cleartext-signed message'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;download'= {
            cand --url 'The data to download'
            cand --signature-url 'URL of the signature'
            cand --signer 'Require a signature from a certificate with the specified fingerprint or key ID'
            cand --signer-userid 'Require a signature from a certificate with the specified user ID'
            cand --signer-email 'Require a signature from a certificate where a user ID includes the specified email address'
            cand --signer-domain 'Require a signature from a certificate where a user ID includes an email address for the specified domain'
            cand --signer-file 'Require a signature from a certificate read from PATH'
            cand --signatures 'Set the threshold of valid signatures to N'
            cand --output 'Write to FILE or stdout if FILE is ''-'''
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --message 'Verify an inline signed message'
            cand --cleartext 'Verify a cleartext-signed message'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;inspect'= {
            cand --cert 'Inspect certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Inspect certificates with the specified user ID (note: User IDs are not authenticated)'
            cand --cert-email 'Inspect certificates where a user ID includes the specified email address (note: User IDs are not authenticated)'
            cand --cert-domain 'Inspect certificates where a user ID includes an email address for the specified domain (note: User IDs are not authenticated)'
            cand --cert-grep 'Inspect certificates with a user ID that matches the pattern, case insensitively (note: User IDs are not authenticated)'
            cand --cert-file 'Read certificates from PATH'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --certifications 'Print third-party certifications'
            cand --dump-bad-signatures 'Dump signatures that are definitively bad'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;cert'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand import 'Import certificates into the local certificate store'
            cand export 'Export certificates from the local certificate store'
            cand list 'List certificates and user IDs'
            cand lint 'Check certificates for issues'
        }
        &'sq;cert;import'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;cert;export'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-domain 'Use certificates where a user ID includes an email address for the specified domain'
            cand --cert-grep 'Use certificates with a user ID that matches the pattern, case insensitively'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --local 'Export local (non-exportable) signatures'
            cand --all 'Export all certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;cert;list'= {
            cand --cert 'List certificates with the specified fingerprint or key ID'
            cand --cert-userid 'List bindings with the specified user ID'
            cand --cert-email 'List bindings with user IDs that contain the specified email address'
            cand --cert-domain 'List bindings with user IDs that contain an email address in the specified domain'
            cand --cert-grep 'List bindings with a user ID that contains the pattern'
            cand --amount 'The required amount of trust'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --show-paths 'Show why a binding is authenticated'
            cand --gossip 'Treats all certificates as unreliable trust roots'
            cand --unusable 'Show bindings that are unusable'
            cand --certification-network 'Treats the network as a certification network'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;cert;lint'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-domain 'Use certificates where a user ID includes an email address for the specified domain'
            cand --cert-grep 'Use certificates with a user ID that matches the pattern, case insensitively'
            cand --cert-file 'Read certificates from PATH'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --fix 'Attempts to fix certificates, when possible'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List keys managed by the key store'
            cand generate 'Generate a new key'
            cand rotate 'Rotate a certificate'
            cand import 'Import keys into the key store'
            cand export 'Export keys from the key store'
            cand delete 'Delete a certificate''s secret key material'
            cand password 'Change the password protecting secret key material'
            cand expire 'Change a certificate''s expiration time'
            cand revoke 'Revoke a certificate'
            cand userid 'Manage User IDs'
            cand subkey 'Manage subkeys'
            cand approvals 'Manages certification approvals'
        }
        &'sq;key;list'= {
            cand --cert 'List keys with the specified fingerprint or key ID'
            cand --cert-userid 'List keys with the specified user ID'
            cand --cert-email 'List keys where a user ID includes the specified email address'
            cand --cert-domain 'List keys where a user ID includes an email address for the specified domain'
            cand --cert-grep 'List keys with a user ID that matches the pattern, case insensitively'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;generate'= {
            cand --name 'Add a name as user ID to the key'
            cand --email 'Add an email address as user ID to the key'
            cand --userid 'Add a user ID to the key'
            cand --cipher-suite 'Select the cryptographic algorithms for the key'
            cand --profile 'Select the OpenPGP standard for the key'
            cand --new-password-file 'File containing password to encrypt the secret key material'
            cand --can-encrypt 'Add an encryption-capable subkey [default: universal]'
            cand --output 'Write the key to the specified file'
            cand --rev-cert 'Write the emergency revocation certificate to FILE'
            cand --expiration 'Sets the expiration time'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --own-key 'Mark the key as one''s own key'
            cand --shared-key 'Mark the key as a shared key'
            cand --allow-non-canonical-userids 'Don''t reject user IDs that are not in canonical form'
            cand --no-userids 'Create a key without any user IDs'
            cand --without-password 'Don''t protect the secret key material with a password'
            cand --can-sign 'Add a signing-capable subkey (default)'
            cand --cannot-sign 'Don''t add a signing-capable subkey'
            cand --can-authenticate 'Add an authentication-capable subkey (default)'
            cand --cannot-authenticate 'Don''t add an authentication-capable subkey'
            cand --cannot-encrypt 'Don''t add an encryption-capable subkey'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;rotate'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-file 'Read certificates from PATH'
            cand --cipher-suite 'Select the cryptographic algorithms for the key'
            cand --profile 'Select the OpenPGP standard for the key'
            cand --new-password-file 'File containing password to encrypt the secret key material'
            cand --can-encrypt 'Add an encryption-capable subkey'
            cand --output 'Write the key to the specified file'
            cand --rev-cert 'Write the emergency revocation certificate to FILE'
            cand --expiration 'Sets the expiration time'
            cand --retire-in 'Sets the time at which the certificate should be retired'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --own-key 'Mark the key as one''s own key'
            cand --shared-key 'Mark the key as a shared key'
            cand --without-password 'Don''t protect the secret key material with a password'
            cand --can-sign 'Add a signing-capable subkey'
            cand --cannot-sign 'Don''t add a signing-capable subkey'
            cand --can-authenticate 'Add an authentication-capable subkey'
            cand --cannot-authenticate 'Don''t add an authentication-capable subkey'
            cand --cannot-encrypt 'Don''t add an encryption-capable subkey'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;import'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;export'= {
            cand --cert 'Export keys with the specified fingerprint or key ID'
            cand --cert-userid 'Export keys with the specified user ID'
            cand --cert-email 'Export keys where a user ID includes the specified email address'
            cand --cert-domain 'Export keys where a user ID includes an email address for the specified domain'
            cand --cert-grep 'Export keys with a user ID that matches the pattern, case insensitively'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;delete'= {
            cand --cert 'Delete secret key material from the key with the specified fingerprint or key ID'
            cand --cert-userid 'Delete secret key material from the key with the specified user ID'
            cand --cert-email 'Delete secret key material from the key where a user ID includes the specified email address'
            cand --cert-file 'Delete the secret key material from the key read from PATH'
            cand --output 'Write the stripped certificate to the specified file'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;password'= {
            cand --cert 'Change the password for the secret key material from the key with the specified fingerprint or key ID'
            cand --cert-userid 'Change the password for the secret key material from the key with the specified user ID'
            cand --cert-email 'Change the password for the secret key material from the key where a user ID includes the specified email address'
            cand --cert-file 'Change the password for the secret key material from the key read from PATH'
            cand --new-password-file 'File containing password to encrypt the secret key material'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --clear-password 'Clear the password protecting the secret key material'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;expire'= {
            cand --cert 'Change the expiration of the key with the specified fingerprint or key ID'
            cand --cert-userid 'Change the expiration of the key with the specified user ID'
            cand --cert-email 'Change the expiration of the key where a user ID includes the specified email address'
            cand --cert-file 'Change the expiration of the key read from PATH'
            cand --output 'Write to FILE or stdout if omitted'
            cand --expiration 'Sets the expiration time'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;revoke'= {
            cand --cert 'Revoke the key with the specified fingerprint or key ID'
            cand --cert-userid 'Revoke the key with the specified user ID'
            cand --cert-email 'Revoke the key where a user ID includes the specified email address'
            cand --cert-file 'Revoke the key read from PATH'
            cand --revoker 'Use key with the specified fingerprint or key ID to create the revocation certificate'
            cand --revoker-userid 'Use key with the specified user ID to create the revocation certificate'
            cand --revoker-email 'Use key where a user ID includes the specified email address to create the revocation certificate'
            cand --revoker-file 'Read key from PATH to create the revocation certificate'
            cand --reason 'The reason for the revocation'
            cand --message 'A short, explanatory text'
            cand --signature-notation 'Add a notation to the signature'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;userid'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a user ID'
            cand revoke 'Revoke a user ID'
        }
        &'sq;key;userid;add'= {
            cand --cert 'Add the user ID to the key with the specified fingerprint or key ID'
            cand --cert-userid 'Add the user ID to the key with the specified user ID'
            cand --cert-email 'Add the user ID to the key where a user ID includes the specified email address'
            cand --cert-file 'Add the user ID to the key read from PATH'
            cand --name 'Add a name as user ID to the key'
            cand --email 'Add an email address as user ID to the key'
            cand --userid 'Add a user ID to the key'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --allow-non-canonical-userids 'Don''t reject user IDs that are not in canonical form'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;userid;revoke'= {
            cand --cert 'Revoke the user ID from the key with the specified fingerprint or key ID'
            cand --cert-userid 'Revoke the user ID from the key with the specified user ID'
            cand --cert-email 'Revoke the user ID from the key where a user ID includes the specified email address'
            cand --cert-file 'Revoke the user ID from the key read from PATH'
            cand --revoker 'Use key with the specified fingerprint or key ID to create the revocation certificate'
            cand --revoker-userid 'Use key with the specified user ID to create the revocation certificate'
            cand --revoker-email 'Use key where a user ID includes the specified email address to create the revocation certificate'
            cand --revoker-file 'Read key from PATH to create the revocation certificate'
            cand --userid 'Use the specified self-signed user ID'
            cand --add-userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID consisting of just the email address, if the email address occurs in a self-signed user ID'
            cand --add-email 'Use a user ID with the specified email address'
            cand --reason 'The reason for the revocation'
            cand --message 'A short, explanatory text'
            cand --signature-notation 'Add a notation to the signature'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --allow-non-canonical-userids 'Don''t reject new user IDs that are not in canonical form'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Add a new subkey to a certificate'
            cand export 'Export secret key material from the secret key store'
            cand delete 'Delete a certificate''s secret key material'
            cand password 'Change the password protecting secret key material'
            cand expire 'Change a subkey''s expiration time'
            cand revoke 'Revoke a subkey'
            cand bind 'Bind keys from one certificate to another'
        }
        &'sq;key;subkey;add'= {
            cand --cert 'Add a subkey to the key with the specified fingerprint or key ID'
            cand --cert-userid 'Add a subkey to the key with the specified user ID'
            cand --cert-email 'Add a subkey to the key where a user ID includes the specified email address'
            cand --cert-file 'Add a subkey to the key read from PATH'
            cand --cipher-suite 'Select the cryptographic algorithms for the subkey'
            cand --expiration 'Sets the expiration time'
            cand --can-encrypt 'Add an encryption-capable subkey [default: universal]'
            cand --new-password-file 'File containing password to encrypt the secret key material'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --can-sign 'Add a signing-capable subkey'
            cand --can-authenticate 'Add an authentication-capable subkey'
            cand --without-password 'Don''t protect the subkey''s secret key material with a password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;export'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --key 'Export the secret key material for the specified primary key or subkey'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;delete'= {
            cand --cert 'Delete secret key material from the key with the specified fingerprint or key ID'
            cand --cert-userid 'Delete secret key material from the key with the specified user ID'
            cand --cert-email 'Delete secret key material from the key where a user ID includes the specified email address'
            cand --cert-file 'Delete the secret key material from the key read from PATH'
            cand --key 'Delete the specified key''s secret key material'
            cand --output 'Write the stripped certificate to the specified file'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;password'= {
            cand --cert 'Change the password for the secret key material of the specified (sub)keys from the key with the specified fingerprint or key ID'
            cand --cert-userid 'Change the password for the secret key material of the specified (sub)keys from the key with the specified user ID'
            cand --cert-email 'Change the password for the secret key material of the specified (sub)keys from the key where a user ID includes the specified email address'
            cand --cert-file 'Change the password for the secret key material of the specified (sub)keys from the key read from PATH'
            cand --key 'Change the password protecting the specified key''s secret key material'
            cand --new-password-file 'File containing password to encrypt the secret key material'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --clear-password 'Clear the password protecting the secret key material'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;expire'= {
            cand --cert 'Change the expiration of the specified (sub)keys on the key with the specified fingerprint or key ID'
            cand --cert-userid 'Change the expiration of the specified (sub)keys on the key with the specified user ID'
            cand --cert-email 'Change the expiration of the specified (sub)keys on the key where a user ID includes the specified email address'
            cand --cert-file 'Change the expiration of the specified (sub)keys on the key read from PATH'
            cand --key 'Use the key with the specified fingerprint or key ID'
            cand --output 'Write to the specified FILE'
            cand --expiration 'Sets the expiration time'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;revoke'= {
            cand --cert 'Revoke the specified subkeys on the key with the specified fingerprint or key ID'
            cand --cert-userid 'Revoke the specified subkeys on the key with the specified user ID'
            cand --cert-email 'Revoke the specified subkeys on the key where a user ID includes the specified email address'
            cand --cert-file 'Revoke the specified subkeys on the key read from PATH'
            cand --revoker 'Use key with the specified fingerprint or key ID to create the revocation certificate'
            cand --revoker-userid 'Use key with the specified user ID to create the revocation certificate'
            cand --revoker-email 'Use key where a user ID includes the specified email address to create the revocation certificate'
            cand --revoker-file 'Read key from PATH to create the revocation certificate'
            cand --key 'Revoke the specified subkey'
            cand --reason 'The reason for the revocation'
            cand --message 'A short, explanatory text'
            cand --signature-notation 'Add a notation to the signature'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;subkey;bind'= {
            cand --cert 'Add the specified subkeys on the key with the specified fingerprint or key ID'
            cand --cert-userid 'Add the specified subkeys on the key with the specified user ID'
            cand --cert-email 'Add the specified subkeys on the key where a user ID includes the specified email address'
            cand --cert-file 'Add the specified subkeys to the key read from PATH'
            cand --key 'Add the key or subkey KEY to the certificate'
            cand --creation-time 'Make bound subkeys have the specified creation time'
            cand --expiration 'Sets the expiration time'
            cand --can-encrypt 'Set the encryption-capable flag'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --allow-broken-crypto 'Allow adopting keys from certificates using broken cryptography'
            cand --can-sign 'Set the signing-capable flag'
            cand --cannot-sign 'Don''t set the signing-capable flag'
            cand --can-authenticate 'Set the authentication-capable flag'
            cand --cannot-authenticate 'Don''t set the authentication-capable flag'
            cand --cannot-encrypt 'Don''t set the encryption-capable flag'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;approvals'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Lists third-party certifications and their approval status'
            cand update 'Approves of third-party certifications allowing for their distribution'
        }
        &'sq;key;approvals;list'= {
            cand --cert 'List the approvals on the certificate with the specified fingerprint or key ID'
            cand --cert-userid 'List the approvals on the certificate with the specified user ID'
            cand --cert-email 'List the approvals on the certificate where a user ID includes the specified email address'
            cand --cert-file 'List the approvals on the certificate read from PATH'
            cand --userid 'Use the specified self-signed user ID'
            cand --email 'Use the self-signed user ID with the specified email address'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --pending 'List unapproved certifications'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;key;approvals;update'= {
            cand --cert 'List the approvals on the certificate with the specified fingerprint or key ID'
            cand --cert-userid 'List the approvals on the certificate with the specified user ID'
            cand --cert-email 'List the approvals on the certificate where a user ID includes the specified email address'
            cand --cert-file 'List the approvals on the certificate read from PATH'
            cand --userid 'Use the specified self-signed user ID'
            cand --email 'Use the self-signed user ID with the specified email address'
            cand --remove-by 'Remove all prior approvals of certifications by this certifier'
            cand --add-by 'Approve of all certifications by this certifier'
            cand --output 'Write to the specified FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --remove-all 'Remove all prior approvals'
            cand --add-all 'Approve of all pending certifications'
            cand --add-authenticated 'Approve of all certifications by authenticated certifiers'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand authenticate 'Authenticate a binding'
            cand lookup 'Lookup the certificates associated with a User ID'
            cand identify 'Identify a certificate'
            cand vouch 'Manage certifications'
            cand link 'Manage authenticated certificate and User ID links'
            cand path 'Verify the specified path'
        }
        &'sq;pki;authenticate'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --userid 'Authenticate the specified user ID'
            cand --email 'Authenticate the specified email address'
            cand --amount 'The required amount of trust'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --show-paths 'Show why a binding is authenticated'
            cand --gossip 'Treats all certificates as unreliable trust roots'
            cand --unusable 'Show bindings that are unusable'
            cand --certification-network 'Treats the network as a certification network'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;lookup'= {
            cand --userid 'Find certificates that can be authenticated for the specified user ID'
            cand --email 'Find certificates that can be authenticated for the specified email address'
            cand --amount 'The required amount of trust'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --show-paths 'Show why a binding is authenticated'
            cand --gossip 'Treats all certificates as unreliable trust roots'
            cand --unusable 'Show bindings that are unusable'
            cand --certification-network 'Treats the network as a certification network'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;identify'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --amount 'The required amount of trust'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --show-paths 'Show why a binding is authenticated'
            cand --gossip 'Treats all certificates as unreliable trust roots'
            cand --unusable 'Show bindings that are unusable'
            cand --certification-network 'Treats the network as a certification network'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;vouch'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Certify a User ID for a Certificate'
            cand authorize 'Mark a certificate as a trusted introducer'
            cand list 'List certifications'
            cand replay 'Replays vouches'
        }
        &'sq;pki;vouch;add'= {
            cand --certifier 'Create the certification using the key with the specified fingerprint or key ID'
            cand --certifier-userid 'Create the certification using the key with the specified user ID'
            cand --certifier-email 'Create the certification using the key where a user ID includes the specified email address'
            cand --certifier-file 'Create the certification using the key read from PATH'
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-file 'Read certificates from PATH'
            cand --userid 'Use the specified self-signed user ID'
            cand --add-userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID consisting of just the email address, if the email address occurs in a self-signed user ID'
            cand --add-email 'Use a user ID with the specified email address'
            cand --amount 'Set the amount of trust'
            cand --expiration 'Sets the expiration time'
            cand --signature-notation 'Add a notation to the signature'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --certifier-self 'Create the certification using your default certification key'
            cand --all 'Use all self-signed user IDs'
            cand --allow-non-canonical-userids 'Don''t reject new user IDs that are not in canonical form'
            cand --local 'Make the certification a local certification'
            cand --non-revocable 'Mark the certification as being non-revocable'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;vouch;authorize'= {
            cand --certifier 'Create the certification using the key with the specified fingerprint or key ID'
            cand --certifier-userid 'Create the certification using the key with the specified user ID'
            cand --certifier-email 'Create the certification using the key where a user ID includes the specified email address'
            cand --certifier-file 'Create the certification using the key read from PATH'
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-file 'Read certificates from PATH'
            cand --userid 'Use the specified self-signed user ID'
            cand --add-userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID consisting of just the email address, if the email address occurs in a self-signed user ID'
            cand --add-email 'Use a user ID with the specified email address'
            cand --amount 'Set the amount of trust'
            cand --depth 'Set the trust depth'
            cand --domain 'Add a domain constraint to the introducer'
            cand --regex 'Add a regular expression to constrain the introducer'
            cand --expiration 'Sets the expiration time'
            cand --signature-notation 'Add a notation to the signature'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --certifier-self 'Create the certification using your default certification key'
            cand --all 'Use all self-signed user IDs'
            cand --allow-non-canonical-userids 'Don''t reject new user IDs that are not in canonical form'
            cand --unconstrained 'Don''t constrain the introducer'
            cand --local 'Make the certification a local certification'
            cand --non-revocable 'Mark the certification as being non-revocable'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;vouch;list'= {
            cand --certifier 'Use certificates with the specified fingerprint or key ID'
            cand --certifier-special 'Use certificates identified by the special name'
            cand --certifier-userid 'Use certificates with the specified user ID'
            cand --certifier-email 'Use certificates where a user ID includes the specified email address'
            cand --certifier-file 'Read certificates from PATH'
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-file 'Read certificates from PATH'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --certifier-self 'Create the certification using your default certification key'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;vouch;replay'= {
            cand --source 'Use certificates with the specified fingerprint or key ID'
            cand --source-userid 'Use certificates with the specified user ID'
            cand --source-email 'Use certificates where a user ID includes the specified email address'
            cand --source-file 'Read certificates from PATH'
            cand --target 'Use certificates with the specified fingerprint or key ID'
            cand --target-userid 'Use certificates with the specified user ID'
            cand --target-email 'Use certificates where a user ID includes the specified email address'
            cand --target-file 'Read certificates from PATH'
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --allow-dissimilar-userids 'Don''t check that the source and target share a self-signed user ID'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;link'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand add 'Link a certificate and a user ID'
            cand authorize 'Make a certificate a trusted introducer'
            cand retract 'Retract links'
            cand list 'List links'
        }
        &'sq;pki;link;add'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-special 'Use certificates identified by the special name'
            cand --userid 'Use the specified self-signed user ID'
            cand --add-userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID consisting of just the email address, if the email address occurs in a self-signed user ID'
            cand --add-email 'Use a user ID with the specified email address'
            cand --amount 'Set the amount of trust'
            cand --expiration 'Sets the expiration time'
            cand --signature-notation 'Add a notation to the signature'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Use all self-signed user IDs'
            cand --allow-non-canonical-userids 'Don''t reject new user IDs that are not in canonical form'
            cand --temporary 'Temporarily accepts the binding'
            cand --recreate 'Recreate signature even if the parameters did not change'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;link;authorize'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-special 'Use certificates identified by the special name'
            cand --userid 'Use the specified self-signed user ID'
            cand --add-userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID consisting of just the email address, if the email address occurs in a self-signed user ID'
            cand --add-email 'Use a user ID with the specified email address'
            cand --amount 'Set the amount of trust'
            cand --depth 'Set the trust depth'
            cand --domain 'Add a domain constraint to the introducer'
            cand --regex 'Add a regular expression to constrain the introducer'
            cand --expiration 'Sets the expiration time'
            cand --signature-notation 'Add a notation to the signature'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Use all self-signed user IDs'
            cand --allow-non-canonical-userids 'Don''t reject new user IDs that are not in canonical form'
            cand --unconstrained 'Don''t constrain the introducer'
            cand --recreate 'Recreate the signature even if the parameters did not change'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;link;retract'= {
            cand --signature-notation 'Add a notation to the signature'
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-special 'Use certificates identified by the special name'
            cand --userid 'Use the specified user ID'
            cand --userid-by-email 'Use the self-signed user ID with the specified email address'
            cand --email 'Use a user ID with the specified email address'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --recreate 'Recreate signature even if the parameters did not change'
            cand --all 'Use all self-signed user IDs'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;link;list'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-domain 'Use certificates where a user ID includes an email address for the specified domain'
            cand --cert-grep 'Use certificates with a user ID that matches the pattern, case insensitively'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --ca 'Only lists bindings linked as CAs'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;pki;path'= {
            cand --userid 'Authenticate the specified user ID'
            cand --userid-by-email 'Authenticate the self-signed user ID with the specified email address'
            cand --email 'Authenticate the specified email address'
            cand --amount 'The required amount of trust'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --certification-network 'Treats the network as a certification network'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand search 'Retrieve certificates using all supported network services'
            cand keyserver 'Retrieve and publishes certificates via key servers'
            cand wkd 'Retrieve and publishes certificates via Web Key Directories'
            cand dane 'Retrieve and publishes certificates via DANE'
        }
        &'sq;network;search'= {
            cand --iterations 'Iterate to find related updates and certs'
            cand --server 'Set a key server to use (can be given multiple times)'
            cand --use-wkd 'Use WKD to search for certs'
            cand --use-dane 'Use DANE to search for certs'
            cand --output 'Write to FILE (or stdout when omitted) instead of importing into the certificate store'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Fetch updates for all known certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;keyserver'= {
            cand --server 'Set a key server to use (can be given multiple times)'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand search 'Retrieve certificates from key servers'
            cand publish 'Publish certificates on key servers'
        }
        &'sq;network;keyserver;search'= {
            cand --output 'Write to FILE (or stdout when omitted) instead of importing into the certificate store'
            cand --server 'Set a key server to use (can be given multiple times)'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Fetch updates for all known certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;keyserver;publish'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-domain 'Use certificates where a user ID includes an email address for the specified domain'
            cand --cert-file 'Read certificates from PATH'
            cand --server 'Set a key server to use (can be given multiple times)'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;wkd'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand search 'Retrieve certificates from a Web Key Directory'
            cand publish 'Publish certificates in a Web Key Directory'
        }
        &'sq;network;wkd;search'= {
            cand --output 'Write to FILE (or stdout when omitted) instead of importing into the certificate store'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Fetch updates for all known certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;wkd;publish'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-file 'Read certificates from PATH'
            cand --method 'Select kind of WKD hierarchy to be created'
            cand --rsync-path 'Path to the local rsync command to use, implies --rsync'
            cand --domain 'Generate a WKD for a fully qualified domain name for email'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Publish authenticated certs with a user ID matching domain'
            cand --create 'Create the WKD hierarchy if it does not exist yet'
            cand --rsync 'Use rsync(1) to access DEST'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;dane'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand search 'Retrieve certificates using DANE'
            cand generate 'Generate DANE records for the given domain and certs'
        }
        &'sq;network;dane;search'= {
            cand --output 'Write to FILE (or stdout when omitted) instead of importing into the certificate store'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Fetch updates for all known certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;network;dane;generate'= {
            cand --cert 'Use certificates with the specified fingerprint or key ID'
            cand --cert-userid 'Use certificates with the specified user ID'
            cand --cert-email 'Use certificates where a user ID includes the specified email address'
            cand --cert-file 'Read certificates from PATH'
            cand --domain 'Generate DANE records for this domain name'
            cand --ttl 'Set the TTL (maximum cache duration) of the resource records'
            cand --size-limit 'Try to shrink the certificates to this size'
            cand --type 'Change the emitted resource record type'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all 'Publish authenticated certs with a user ID matching domain'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;keyring'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'List keys in a keyring'
            cand split 'Split a keyring into individual keys'
            cand merge 'Merge keys or keyrings into a single keyring'
            cand filter 'Join keys into a keyring applying a filter'
        }
        &'sq;keyring;list'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --all-userids 'List all user IDs'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;keyring;split'= {
            cand --prefix 'Write to files with PREFIX [defaults: `FILE-` if FILE is set, or `output-` if read from stdin]'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;keyring;merge'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;keyring;filter'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --userid 'Match on USERID'
            cand --name 'Match on NAME'
            cand --email 'Match on email ADDRESS'
            cand --domain 'Match on email domain FQDN'
            cand --cert 'Match on certificate fingerprints and key IDs'
            cand --key 'Match on (sub)key fingerprints and key IDs'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --experimental 'Opt-in to using an experimental feature'
            cand --prune-certs 'Remove certificate components not matching the filter'
            cand --to-cert 'Convert any keys in the input to certificates'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand armor 'Convert binary to ASCII'
            cand dearmor 'Convert ASCII to binary'
            cand dump 'List packets'
            cand decrypt 'Unwrap an encryption container'
            cand split 'Split a message into packets'
            cand join 'Join packets split across files'
        }
        &'sq;packet;armor'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --label 'Select the kind of armor header'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet;dearmor'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet;dump'= {
            cand --cert 'Dump the packets of the certificate with the specified fingerprint or key ID'
            cand --cert-userid 'Dump the packets of the certificate with the specified user ID'
            cand --cert-email 'Dump the packets of the certificate where a user ID includes the specified email address'
            cand --cert-file 'Dump the packets of the cert read from PATH'
            cand --output 'Write to FILE or stdout if omitted'
            cand --session-key 'Decrypt an encrypted message using SESSION-KEY'
            cand --recipient-file 'Decrypt the message using the key in KEY_FILE'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --mpis 'Print cryptographic artifacts'
            cand --hex 'Print a hexdump'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet;decrypt'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --recipient-file 'Decrypt the message using the key in KEY_FILE'
            cand --session-key 'Decrypt an encrypted message using SESSION-KEY'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --binary 'Emit binary data'
            cand --dump-session-key 'Print the session key to stderr'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet;split'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --output-prefix 'Write packets to individual files starting with the given prefix.  The file names are formed by joining the prefix, the path of the packet in the source object (recall: packets can be nested), and a human-readable packet type with dashes (''-''). '
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --binary 'Emit binary data'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;packet;join'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --label 'Select the kind of armor header'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --binary 'Emit binary data'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;config'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand get 'Get configuration options'
            cand inspect 'Inspect effective configuration details'
            cand template 'Write a template configuration file'
        }
        &'sq;config;get'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;config;inspect'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand paths 'Inspect relevant paths'
            cand network 'Inspect the network configuration'
            cand policy 'Inspect the cryptographic policy'
        }
        &'sq;config;inspect;paths'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;config;inspect;network'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;config;inspect;policy'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;config;template'= {
            cand --output 'Write to FILE or stdout if omitted'
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;version'= {
            cand --cli-version 'Select a CLI version'
            cand --home 'Set the home directory'
            cand --key-store 'Override the key store server and its data'
            cand --cert-store 'Specify the location of the certificate store'
            cand --keyring 'Specify the location of a keyring to use'
            cand --known-notation 'Add NOTATION to the list of known notations'
            cand --time 'Set the reference time as an ISO 8601 formatted timestamp'
            cand --policy-as-of 'Select the cryptographic policy as of the specified time'
            cand --trust-root 'Consider the specified certificate to be a trust root'
            cand --password-file 'Seed the password cache with the specified password'
            cand --overwrite 'Overwrite existing files'
            cand -v 'Be more verbose'
            cand --verbose 'Be more verbose'
            cand -q 'Be more quiet'
            cand --quiet 'Be more quiet'
            cand --batch 'Prevents any kind of prompting'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'sq;help'= {
            cand encrypt 'Encrypt a message'
            cand decrypt 'Decrypt a message'
            cand sign 'Sign messages or data files'
            cand verify 'Verify signed messages or detached signatures'
            cand download 'Download and authenticate the data'
            cand inspect 'Inspect data, like file(1)'
            cand cert 'Manage certificates'
            cand key 'Manage keys'
            cand pki 'Authenticate certs using the Web of Trust'
            cand network 'Retrieve and publish certificates over the network'
            cand keyring 'Manage collections of keys or certs'
            cand packet 'Low-level packet manipulation'
            cand config 'Query, inspect, and create the configuration file'
            cand version 'Detailed version and output version information'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'sq;help;encrypt'= {
        }
        &'sq;help;decrypt'= {
        }
        &'sq;help;sign'= {
        }
        &'sq;help;verify'= {
        }
        &'sq;help;download'= {
        }
        &'sq;help;inspect'= {
        }
        &'sq;help;cert'= {
            cand import 'Import certificates into the local certificate store'
            cand export 'Export certificates from the local certificate store'
            cand list 'List certificates and user IDs'
            cand lint 'Check certificates for issues'
        }
        &'sq;help;cert;import'= {
        }
        &'sq;help;cert;export'= {
        }
        &'sq;help;cert;list'= {
        }
        &'sq;help;cert;lint'= {
        }
        &'sq;help;key'= {
            cand list 'List keys managed by the key store'
            cand generate 'Generate a new key'
            cand rotate 'Rotate a certificate'
            cand import 'Import keys into the key store'
            cand export 'Export keys from the key store'
            cand delete 'Delete a certificate''s secret key material'
            cand password 'Change the password protecting secret key material'
            cand expire 'Change a certificate''s expiration time'
            cand revoke 'Revoke a certificate'
            cand userid 'Manage User IDs'
            cand subkey 'Manage subkeys'
            cand approvals 'Manages certification approvals'
        }
        &'sq;help;key;list'= {
        }
        &'sq;help;key;generate'= {
        }
        &'sq;help;key;rotate'= {
        }
        &'sq;help;key;import'= {
        }
        &'sq;help;key;export'= {
        }
        &'sq;help;key;delete'= {
        }
        &'sq;help;key;password'= {
        }
        &'sq;help;key;expire'= {
        }
        &'sq;help;key;revoke'= {
        }
        &'sq;help;key;userid'= {
            cand add 'Add a user ID'
            cand revoke 'Revoke a user ID'
        }
        &'sq;help;key;userid;add'= {
        }
        &'sq;help;key;userid;revoke'= {
        }
        &'sq;help;key;subkey'= {
            cand add 'Add a new subkey to a certificate'
            cand export 'Export secret key material from the secret key store'
            cand delete 'Delete a certificate''s secret key material'
            cand password 'Change the password protecting secret key material'
            cand expire 'Change a subkey''s expiration time'
            cand revoke 'Revoke a subkey'
            cand bind 'Bind keys from one certificate to another'
        }
        &'sq;help;key;subkey;add'= {
        }
        &'sq;help;key;subkey;export'= {
        }
        &'sq;help;key;subkey;delete'= {
        }
        &'sq;help;key;subkey;password'= {
        }
        &'sq;help;key;subkey;expire'= {
        }
        &'sq;help;key;subkey;revoke'= {
        }
        &'sq;help;key;subkey;bind'= {
        }
        &'sq;help;key;approvals'= {
            cand list 'Lists third-party certifications and their approval status'
            cand update 'Approves of third-party certifications allowing for their distribution'
        }
        &'sq;help;key;approvals;list'= {
        }
        &'sq;help;key;approvals;update'= {
        }
        &'sq;help;pki'= {
            cand authenticate 'Authenticate a binding'
            cand lookup 'Lookup the certificates associated with a User ID'
            cand identify 'Identify a certificate'
            cand vouch 'Manage certifications'
            cand link 'Manage authenticated certificate and User ID links'
            cand path 'Verify the specified path'
        }
        &'sq;help;pki;authenticate'= {
        }
        &'sq;help;pki;lookup'= {
        }
        &'sq;help;pki;identify'= {
        }
        &'sq;help;pki;vouch'= {
            cand add 'Certify a User ID for a Certificate'
            cand authorize 'Mark a certificate as a trusted introducer'
            cand list 'List certifications'
            cand replay 'Replays vouches'
        }
        &'sq;help;pki;vouch;add'= {
        }
        &'sq;help;pki;vouch;authorize'= {
        }
        &'sq;help;pki;vouch;list'= {
        }
        &'sq;help;pki;vouch;replay'= {
        }
        &'sq;help;pki;link'= {
            cand add 'Link a certificate and a user ID'
            cand authorize 'Make a certificate a trusted introducer'
            cand retract 'Retract links'
            cand list 'List links'
        }
        &'sq;help;pki;link;add'= {
        }
        &'sq;help;pki;link;authorize'= {
        }
        &'sq;help;pki;link;retract'= {
        }
        &'sq;help;pki;link;list'= {
        }
        &'sq;help;pki;path'= {
        }
        &'sq;help;network'= {
            cand search 'Retrieve certificates using all supported network services'
            cand keyserver 'Retrieve and publishes certificates via key servers'
            cand wkd 'Retrieve and publishes certificates via Web Key Directories'
            cand dane 'Retrieve and publishes certificates via DANE'
        }
        &'sq;help;network;search'= {
        }
        &'sq;help;network;keyserver'= {
            cand search 'Retrieve certificates from key servers'
            cand publish 'Publish certificates on key servers'
        }
        &'sq;help;network;keyserver;search'= {
        }
        &'sq;help;network;keyserver;publish'= {
        }
        &'sq;help;network;wkd'= {
            cand search 'Retrieve certificates from a Web Key Directory'
            cand publish 'Publish certificates in a Web Key Directory'
        }
        &'sq;help;network;wkd;search'= {
        }
        &'sq;help;network;wkd;publish'= {
        }
        &'sq;help;network;dane'= {
            cand search 'Retrieve certificates using DANE'
            cand generate 'Generate DANE records for the given domain and certs'
        }
        &'sq;help;network;dane;search'= {
        }
        &'sq;help;network;dane;generate'= {
        }
        &'sq;help;keyring'= {
            cand list 'List keys in a keyring'
            cand split 'Split a keyring into individual keys'
            cand merge 'Merge keys or keyrings into a single keyring'
            cand filter 'Join keys into a keyring applying a filter'
        }
        &'sq;help;keyring;list'= {
        }
        &'sq;help;keyring;split'= {
        }
        &'sq;help;keyring;merge'= {
        }
        &'sq;help;keyring;filter'= {
        }
        &'sq;help;packet'= {
            cand armor 'Convert binary to ASCII'
            cand dearmor 'Convert ASCII to binary'
            cand dump 'List packets'
            cand decrypt 'Unwrap an encryption container'
            cand split 'Split a message into packets'
            cand join 'Join packets split across files'
        }
        &'sq;help;packet;armor'= {
        }
        &'sq;help;packet;dearmor'= {
        }
        &'sq;help;packet;dump'= {
        }
        &'sq;help;packet;decrypt'= {
        }
        &'sq;help;packet;split'= {
        }
        &'sq;help;packet;join'= {
        }
        &'sq;help;config'= {
            cand get 'Get configuration options'
            cand inspect 'Inspect effective configuration details'
            cand template 'Write a template configuration file'
        }
        &'sq;help;config;get'= {
        }
        &'sq;help;config;inspect'= {
            cand paths 'Inspect relevant paths'
            cand network 'Inspect the network configuration'
            cand policy 'Inspect the cryptographic policy'
        }
        &'sq;help;config;inspect;paths'= {
        }
        &'sq;help;config;inspect;network'= {
        }
        &'sq;help;config;inspect;policy'= {
        }
        &'sq;help;config;template'= {
        }
        &'sq;help;version'= {
        }
        &'sq;help;help'= {
        }
    ]
    $completions[$command]
}
