/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.controller;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MLDeployControllerNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    @Generated
    private static final Logger log = LogManager.getLogger(MLDeployControllerNodeResponse.class);
    private Map<String, String> controllerDeployStatus;

    public MLDeployControllerNodeResponse(DiscoveryNode node, Map<String, String> controllerDeployStatus) {
        super(node);
        this.controllerDeployStatus = controllerDeployStatus;
    }

    public MLDeployControllerNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.controllerDeployStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLDeployControllerNodeResponse readStats(StreamInput in) throws IOException {
        return new MLDeployControllerNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!this.isControllerDeployStatusEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.controllerDeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (!this.isControllerDeployStatusEmpty()) {
            for (Map.Entry<String, String> stat : this.controllerDeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isControllerDeployStatusEmpty() {
        return this.controllerDeployStatus == null || this.controllerDeployStatus.isEmpty();
    }

    @Generated
    public Map<String, String> getControllerDeployStatus() {
        return this.controllerDeployStatus;
    }
}

