/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import lombok.Generated;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.statement.Query;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstBuilder;
import shaded.com.google.common.collect.ImmutableList;

public class AstStatementBuilder
extends OpenSearchPPLParserBaseVisitor<Statement> {
    private final AstBuilder astBuilder;
    private final StatementBuilderContext context;

    @Override
    public Statement visitPplStatement(OpenSearchPPLParser.PplStatementContext ctx) {
        Query query = new Query(this.addSelectAll((UnresolvedPlan)this.astBuilder.visit(ctx)), this.context.getFetchSize(), QueryType.PPL);
        if (ctx.explainStatement() != null) {
            if (ctx.explainStatement().explainMode() == null) {
                return new Explain(query, QueryType.PPL);
            }
            return new Explain(query, QueryType.PPL, ctx.explainStatement().explainMode().getText());
        }
        return this.context.isExplain ? new Explain(query, QueryType.PPL, this.context.format) : query;
    }

    @Override
    protected Statement aggregateResult(Statement aggregate, Statement nextResult) {
        return nextResult != null ? nextResult : aggregate;
    }

    private UnresolvedPlan addSelectAll(UnresolvedPlan plan) {
        if (plan instanceof Project && !((Project)plan).isExcluded()) {
            return plan;
        }
        return new Project(ImmutableList.of(AllFields.of())).attach(plan);
    }

    @Generated
    public AstStatementBuilder(AstBuilder astBuilder, StatementBuilderContext context) {
        this.astBuilder = astBuilder;
        this.context = context;
    }

    public static class StatementBuilderContext {
        private final boolean isExplain;
        private final int fetchSize;
        private final String format;

        @Generated
        StatementBuilderContext(boolean isExplain, int fetchSize, String format) {
            this.isExplain = isExplain;
            this.fetchSize = fetchSize;
            this.format = format;
        }

        @Generated
        public static StatementBuilderContextBuilder builder() {
            return new StatementBuilderContextBuilder();
        }

        @Generated
        public boolean isExplain() {
            return this.isExplain;
        }

        @Generated
        public int getFetchSize() {
            return this.fetchSize;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementBuilderContext)) {
                return false;
            }
            StatementBuilderContext other = (StatementBuilderContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExplain() != other.isExplain()) {
                return false;
            }
            if (this.getFetchSize() != other.getFetchSize()) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatementBuilderContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + (this.isExplain() ? 79 : 97);
            result2 = result2 * 59 + this.getFetchSize();
            String $format = this.getFormat();
            result2 = result2 * 59 + ($format == null ? 43 : $format.hashCode());
            return result2;
        }

        @Generated
        public String toString() {
            return "AstStatementBuilder.StatementBuilderContext(isExplain=" + this.isExplain() + ", fetchSize=" + this.getFetchSize() + ", format=" + this.getFormat() + ")";
        }

        @Generated
        public static class StatementBuilderContextBuilder {
            @Generated
            private boolean isExplain;
            @Generated
            private int fetchSize;
            @Generated
            private String format;

            @Generated
            StatementBuilderContextBuilder() {
            }

            @Generated
            public StatementBuilderContextBuilder isExplain(boolean isExplain) {
                this.isExplain = isExplain;
                return this;
            }

            @Generated
            public StatementBuilderContextBuilder fetchSize(int fetchSize) {
                this.fetchSize = fetchSize;
                return this;
            }

            @Generated
            public StatementBuilderContextBuilder format(String format) {
                this.format = format;
                return this;
            }

            @Generated
            public StatementBuilderContext build() {
                return new StatementBuilderContext(this.isExplain, this.fetchSize, this.format);
            }

            @Generated
            public String toString() {
                return "AstStatementBuilder.StatementBuilderContext.StatementBuilderContextBuilder(isExplain=" + this.isExplain + ", fetchSize=" + this.fetchSize + ", format=" + this.format + ")";
            }
        }
    }
}

