/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.value;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.FormatNames;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchBinaryType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.data.utils.Content;
import org.opensearch.sql.opensearch.data.utils.ObjectContent;
import org.opensearch.sql.opensearch.data.utils.OpenSearchJsonContent;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprBinaryValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprGeoPointValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprTextValue;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.utils.DateTimeFormatters;
import shaded.com.google.common.collect.ImmutableMap;

public class OpenSearchExprValueFactory {
    private final Map<String, OpenSearchDataType> typeMapping;
    private final boolean fieldTypeTolerance;
    private OpenSearchAggregationResponseParser parser;
    private static final String TOP_PATH = "";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<ExprType, BiFunction<Content, ExprType, ExprValue>> typeActionMap = new ImmutableMap.Builder<OpenSearchDataType, BiFunction<Content, ExprType, ExprValue>>().put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Integer), (c, dt) -> new ExprIntegerValue(c.intValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Long), (c, dt) -> new ExprLongValue(c.longValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Short), (c, dt) -> new ExprShortValue(c.shortValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Byte), (c, dt) -> new ExprByteValue(c.byteValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Float), (c, dt) -> new ExprFloatValue(c.floatValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Double), (c, dt) -> new ExprDoubleValue(c.doubleValue())).put(OpenSearchTextType.of(), (c, dt) -> new OpenSearchExprTextValue(c.stringValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Keyword), (c, dt) -> new ExprStringValue(c.stringValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Boolean), (c, dt) -> ExprBooleanValue.of(c.booleanValue())).put(OpenSearchDateType.of(ExprCoreType.TIME), OpenSearchExprValueFactory::createOpenSearchDateType).put(OpenSearchDateType.of(ExprCoreType.DATE), OpenSearchExprValueFactory::createOpenSearchDateType).put(OpenSearchDateType.of(ExprCoreType.TIMESTAMP), OpenSearchExprValueFactory::createOpenSearchDateType).put(OpenSearchDateType.of(OpenSearchDataType.MappingType.Ip), (c, dt) -> new ExprIpValue(c.stringValue())).put(OpenSearchDataType.of(OpenSearchDataType.MappingType.Binary), (c, dt) -> new OpenSearchExprBinaryValue(c.stringValue())).build();

    public void extendTypeMapping(Map<String, OpenSearchDataType> typeMapping) {
        for (String field : typeMapping.keySet()) {
            this.typeMapping.putIfAbsent(field, typeMapping.get(field));
        }
    }

    public OpenSearchExprValueFactory(Map<String, OpenSearchDataType> typeMapping, boolean fieldTypeTolerance) {
        this.typeMapping = OpenSearchDataType.traverseAndFlatten(typeMapping);
        this.fieldTypeTolerance = fieldTypeTolerance;
    }

    public ExprValue construct(String jsonString, boolean supportArrays) {
        try {
            return this.parse(new OpenSearchJsonContent(OBJECT_MAPPER.readTree(jsonString)), TOP_PATH, Optional.of(ExprCoreType.STRUCT), this.fieldTypeTolerance || supportArrays);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("invalid json: %s.", jsonString), e);
        }
    }

    public ExprValue construct(String field, Object value, boolean supportArrays) {
        return this.parse(new ObjectContent(value), field, this.type(field), supportArrays);
    }

    private ExprValue parse(Content content, String field, Optional<ExprType> fieldType, boolean supportArrays) {
        if (content.isNull()) {
            return ExprNullValue.of();
        }
        if (fieldType.isEmpty()) {
            return this.parseContent(content);
        }
        ExprType type2 = fieldType.get();
        if (type2.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.GeoPoint))) {
            return this.parseGeoPoint(content, supportArrays);
        }
        if (type2.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.Nested)) || content.isArray()) {
            return this.parseArray(content, field, type2, supportArrays);
        }
        if (type2.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.Object)) || type2 == ExprCoreType.STRUCT) {
            return this.parseStruct(content, field, supportArrays);
        }
        if (typeActionMap.containsKey(type2)) {
            return typeActionMap.get(type2).apply(content, type2);
        }
        throw new IllegalStateException(String.format("Unsupported type: %s for value: %s.", type2.typeName(), content.objectValue()));
    }

    private ExprValue parseContent(Content content) {
        if (content.isNumber()) {
            if (content.isInt()) {
                return new ExprIntegerValue(content.intValue());
            }
            if (content.isShort()) {
                return new ExprShortValue(content.shortValue());
            }
            if (content.isByte()) {
                return new ExprByteValue(content.byteValue());
            }
            if (content.isLong()) {
                return new ExprLongValue(content.longValue());
            }
            if (content.isFloat()) {
                return new ExprFloatValue(content.floatValue());
            }
            if (content.isDouble()) {
                return new ExprDoubleValue(content.doubleValue());
            }
            return new ExprDoubleValue(content.doubleValue());
        }
        if (content.isString()) {
            return new ExprStringValue(content.stringValue());
        }
        if (content.isBoolean()) {
            return ExprBooleanValue.of(content.booleanValue());
        }
        if (content.isNull()) {
            return ExprNullValue.of();
        }
        return new ExprStringValue(content.objectValue().toString());
    }

    private Optional<ExprType> type(String field) {
        return Optional.ofNullable((ExprType)this.typeMapping.get(field));
    }

    private static ExprValue parseDateTimeString(String value, OpenSearchDateType dataType) {
        List<DateFormatter> formatters = dataType.getAllNamedFormatters();
        formatters.addAll(dataType.getAllCustomFormatters());
        ExprCoreType returnFormat = dataType.getExprCoreType();
        for (DateFormatter formatter : formatters) {
            try {
                TemporalAccessor accessor = formatter.parse(value);
                ZonedDateTime zonedDateTime = DateFormatters.from((TemporalAccessor)accessor);
                switch (returnFormat) {
                    case TIME: {
                        return new ExprTimeValue(zonedDateTime.withZoneSameLocal(ZoneOffset.UTC).toLocalTime());
                    }
                    case DATE: {
                        return new ExprDateValue(zonedDateTime.withZoneSameLocal(ZoneOffset.UTC).toLocalDate());
                    }
                }
                return new ExprTimestampValue(zonedDateTime.withZoneSameLocal(ZoneOffset.UTC).toInstant());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            switch (returnFormat) {
                case TIME: {
                    return new ExprTimeValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.STRICT_HOUR_MINUTE_SECOND_FORMATTER.parse(value)).toLocalTime());
                }
                case DATE: {
                    return new ExprDateValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.STRICT_YEAR_MONTH_DAY_FORMATTER.parse(value)).toLocalDate());
                }
            }
            return new ExprTimestampValue(DateFormatters.from((TemporalAccessor)DateFieldMapper.getDefaultDateTimeFormatter().parse(value)).toInstant());
        }
        catch (IllegalArgumentException | DateTimeParseException runtimeException) {
            throw new IllegalArgumentException(String.format("Construct %s from \"%s\" failed, unsupported format.", returnFormat, value));
        }
    }

    private static ExprValue createOpenSearchDateType(Content value, ExprType type2) {
        OpenSearchDateType dt = (OpenSearchDateType)type2;
        ExprCoreType returnFormat = dt.getExprCoreType();
        if (value.isNumber()) {
            List<DateFormatter> numFormatters = dt.getNumericNamedFormatters();
            if (numFormatters.size() > 0 || !dt.hasFormats()) {
                long epochMillis = 0L;
                epochMillis = numFormatters.contains(DateFormatter.forPattern((String)FormatNames.EPOCH_SECOND.getSnakeCaseName())) ? value.longValue() * 1000L : value.longValue();
                Instant instant = Instant.ofEpochMilli(epochMillis);
                switch (returnFormat) {
                    case TIME: {
                        return new ExprTimeValue(LocalTime.from(instant.atZone(ZoneOffset.UTC)));
                    }
                    case DATE: {
                        return new ExprDateValue(LocalDate.ofInstant(instant, ZoneOffset.UTC));
                    }
                }
                return new ExprTimestampValue(instant);
            }
            return OpenSearchExprValueFactory.parseDateTimeString(value.objectValue().toString(), dt);
        }
        if (value.isString()) {
            return OpenSearchExprValueFactory.parseDateTimeString(value.stringValue(), dt);
        }
        return new ExprTimestampValue((Instant)value.objectValue());
    }

    private ExprValue parseStruct(Content content, String prefix, boolean supportArrays) {
        ExprTupleValue result2 = ExprTupleValue.empty();
        content.map().forEachRemaining(entry -> OpenSearchExprValueFactory.populateValueRecursive(result2, new JsonPath((String)entry.getKey()), this.parse((Content)entry.getValue(), this.makeField(prefix, (String)entry.getKey()), this.type(this.makeField(prefix, (String)entry.getKey())), supportArrays)));
        return result2;
    }

    static void populateValueRecursive(ExprTupleValue result2, JsonPath path, ExprValue value) {
        if (path.getPaths().size() == 1) {
            result2.tupleValue().computeIfPresent(path.getRootPath(), (key, oldValue) -> value.mergeTo((ExprValue)oldValue));
            result2.tupleValue().putIfAbsent(path.getRootPath(), value);
        } else {
            result2.tupleValue().putIfAbsent(path.getRootPath(), ExprTupleValue.empty());
            OpenSearchExprValueFactory.populateValueRecursive((ExprTupleValue)result2.tupleValue().get(path.getRootPath()), path.getChildPath(), value);
        }
    }

    private ExprValue parseArray(Content content, String prefix, ExprType type2, boolean supportArrays) {
        ArrayList<ExprValue> result2 = new ArrayList<ExprValue>();
        if (content.objectValue() instanceof ObjectNode) {
            result2.add(this.parseStruct(content, prefix, supportArrays));
        } else {
            if (!(type2 instanceof OpenSearchDataType && ((OpenSearchDataType)type2).getExprType().equals(ExprCoreType.ARRAY) || supportArrays)) {
                return this.parseInnerArrayValue(content.array().next(), prefix, type2, supportArrays);
            }
            content.array().forEachRemaining(v -> result2.add(this.parseInnerArrayValue((Content)v, prefix, type2, supportArrays)));
        }
        return new ExprCollectionValue(result2);
    }

    private ExprValue parseGeoPoint(Content content, boolean supportArrays) {
        if (!content.isArray()) {
            Pair<Double, Double> pair = content.geoValue();
            return new OpenSearchExprGeoPointValue(pair.getLeft(), pair.getRight());
        }
        Iterator<? extends Content> elements = content.array();
        Content first = elements.next();
        if (first.isNumber()) {
            double lon = first.doubleValue();
            Content second = elements.next();
            if (!second.isNumber()) {
                throw new OpenSearchParseException("lat must be a number, got " + String.valueOf(second.objectValue()), new Object[0]);
            }
            return new OpenSearchExprGeoPointValue(second.doubleValue(), lon);
        }
        Pair<Double, Double> pair = first.geoValue();
        OpenSearchExprGeoPointValue firstPoint = new OpenSearchExprGeoPointValue(pair.getLeft(), pair.getRight());
        if (supportArrays) {
            ArrayList<ExprValue> result2 = new ArrayList<ExprValue>();
            result2.add(firstPoint);
            elements.forEachRemaining(e -> {
                Pair<Double, Double> p = e.geoValue();
                result2.add(new OpenSearchExprGeoPointValue(p.getLeft(), p.getRight()));
            });
            return new ExprCollectionValue(result2);
        }
        return firstPoint;
    }

    private ExprValue parseInnerArrayValue(Content content, String prefix, ExprType type2, boolean supportArrays) {
        if (type2 instanceof OpenSearchBinaryType || type2 instanceof OpenSearchDateType) {
            return this.parse(content, prefix, Optional.of(type2), supportArrays);
        }
        if (content.isString() && type2.equals(OpenSearchDataType.of(ExprCoreType.IP))) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.IP)), supportArrays);
        }
        if (content.isString()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.STRING)), supportArrays);
        }
        if (content.isLong()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.LONG)), supportArrays);
        }
        if (content.isFloat()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.FLOAT)), supportArrays);
        }
        if (content.isDouble()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.DOUBLE)), supportArrays);
        }
        if (content.isNumber()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.INTEGER)), supportArrays);
        }
        if (content.isBoolean()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of(ExprCoreType.BOOLEAN)), supportArrays);
        }
        return this.parse(content, prefix, Optional.of(ExprCoreType.STRUCT), supportArrays);
    }

    private String makeField(String path, String field) {
        return path.equalsIgnoreCase(TOP_PATH) ? field : String.join((CharSequence)".", path, field);
    }

    @Generated
    public OpenSearchAggregationResponseParser getParser() {
        return this.parser;
    }

    @Generated
    public void setParser(OpenSearchAggregationResponseParser parser) {
        this.parser = parser;
    }

    static class JsonPath {
        private final List<String> paths;

        public JsonPath(String rawPath) {
            this.paths = List.of(rawPath.split("\\."));
        }

        public JsonPath(List<String> paths) {
            this.paths = paths;
        }

        public String getRootPath() {
            return this.paths.getFirst();
        }

        public JsonPath getChildPath() {
            return new JsonPath(this.paths.subList(1, this.paths.size()));
        }

        @Generated
        public List<String> getPaths() {
            return this.paths;
        }
    }
}

