/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.Having;
import org.opensearch.sql.legacy.domain.MethodField;
import org.opensearch.sql.legacy.domain.Order;
import org.opensearch.sql.legacy.domain.Query;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.domain.hints.Hint;
import org.opensearch.sql.legacy.parser.SubQueryExpression;
import shaded.com.google.common.collect.ImmutableSet;

public class Select
extends Query {
    private static final Set<String> AGGREGATE_FUNCTIONS = ImmutableSet.of("SUM", "MAX", "MIN", "AVG", "TOPHITS", "COUNT", new String[]{"STATS", "EXTENDED_STATS", "PERCENTILES", "SCRIPTED_METRIC"});
    private final List<Hint> hints = new ArrayList<Hint>();
    private final List<Field> fields = new ArrayList<Field>();
    private final List<List<Field>> groupBys = new ArrayList<List<Field>>();
    private Having having;
    private final List<Order> orderBys = new ArrayList<Order>();
    private int offset;
    private Integer rowCount;
    private boolean containsSubQueries;
    private List<SubQueryExpression> subQueries;
    private boolean selectAll = false;
    private SQLJoinTableSource.JoinType nestedJoinType = SQLJoinTableSource.JoinType.COMMA;
    public boolean isQuery = false;
    public boolean isAggregate = false;
    public static final int DEFAULT_LIMIT = 200;

    public List<Field> getFields() {
        return this.fields;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRowCount(Integer rowCount) {
        this.rowCount = rowCount;
    }

    public void addGroupBy(Field field) {
        ArrayList<Field> wrapper = new ArrayList<Field>();
        wrapper.add(field);
        this.addGroupBy(wrapper);
    }

    public void addGroupBy(List<Field> fields2) {
        this.isAggregate = true;
        this.selectAll = false;
        this.groupBys.add(fields2);
    }

    public List<List<Field>> getGroupBys() {
        return this.groupBys;
    }

    public Having getHaving() {
        return this.having;
    }

    public void setHaving(Having having) {
        this.having = having;
    }

    public List<Order> getOrderBys() {
        return this.orderBys;
    }

    public int getOffset() {
        return this.offset;
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public void addOrderBy(String nestedPath, String name, String type2, Field field) {
        if ("_score".equals(name)) {
            this.isQuery = true;
        }
        this.orderBys.add(new Order(nestedPath, name, type2, field));
    }

    public void addField(Field field) {
        if (field == null) {
            return;
        }
        if (field == Field.STAR && !this.isAggregate) {
            this.selectAll = true;
            return;
        }
        if (field instanceof MethodField && AGGREGATE_FUNCTIONS.contains(field.getName().toUpperCase())) {
            this.isAggregate = true;
        }
        this.fields.add(field);
    }

    public List<Hint> getHints() {
        return this.hints;
    }

    public SQLJoinTableSource.JoinType getNestedJoinType() {
        return this.nestedJoinType;
    }

    public void setNestedJoinType(SQLJoinTableSource.JoinType nestedJoinType) {
        this.nestedJoinType = nestedJoinType;
    }

    public void fillSubQueries() {
        this.subQueries = new ArrayList<SubQueryExpression>();
        Where where = this.getWhere();
        this.fillSubQueriesFromWhereRecursive(where);
    }

    private void fillSubQueriesFromWhereRecursive(Where where) {
        block5: {
            block4: {
                if (where == null) {
                    return;
                }
                if (!(where instanceof Condition)) break block4;
                Condition condition = (Condition)where;
                if (condition.getValue() instanceof SubQueryExpression) {
                    this.subQueries.add((SubQueryExpression)condition.getValue());
                    this.containsSubQueries = true;
                }
                if (!(condition.getValue() instanceof Object[])) break block5;
                for (Object o : (Object[])condition.getValue()) {
                    if (!(o instanceof SubQueryExpression)) continue;
                    this.subQueries.add((SubQueryExpression)o);
                    this.containsSubQueries = true;
                }
                break block5;
            }
            for (Where innerWhere : where.getWheres()) {
                this.fillSubQueriesFromWhereRecursive(innerWhere);
            }
        }
    }

    public boolean containsSubQueries() {
        return this.containsSubQueries;
    }

    public List<SubQueryExpression> getSubQueries() {
        return this.subQueries;
    }

    public boolean isOrderdSelect() {
        return this.getOrderBys() != null && this.getOrderBys().size() > 0;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }
}

