/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.ip;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class CompareIpFunction
extends ImplementorUDF {
    private CompareIpFunction(ComparisonType comparisonType) {
        super(new CompareImplementor(comparisonType), NullPolicy.ANY);
    }

    public static CompareIpFunction less() {
        return new CompareIpFunction(ComparisonType.LESS);
    }

    public static CompareIpFunction greater() {
        return new CompareIpFunction(ComparisonType.GREATER);
    }

    public static CompareIpFunction lessOrEquals() {
        return new CompareIpFunction(ComparisonType.LESS_OR_EQUAL);
    }

    public static CompareIpFunction greaterOrEquals() {
        return new CompareIpFunction(ComparisonType.GREATER_OR_EQUAL);
    }

    public static CompareIpFunction equals() {
        return new CompareIpFunction(ComparisonType.EQUALS);
    }

    public static CompareIpFunction notEquals() {
        return new CompareIpFunction(ComparisonType.NOT_EQUALS);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BOOLEAN_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrapUDT(List.of(List.of(ExprCoreType.IP, ExprCoreType.IP)));
    }

    public static class CompareImplementor
    implements NotNullImplementor {
        private final ComparisonType comparisonType;

        public CompareImplementor(ComparisonType comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            MethodCallExpression compareResult = Expressions.call(CompareImplementor.class, "compareTo", new Expression[]{translatedOperands.get(0), translatedOperands.get(1)});
            return CompareImplementor.generateComparisonExpression(compareResult, this.comparisonType);
        }

        private static Expression generateComparisonExpression(Expression compareResult, ComparisonType comparisonType) {
            ConstantExpression zero2 = Expressions.constant(0);
            return switch (comparisonType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Expressions.equal(compareResult, zero2);
                case 1 -> Expressions.notEqual(compareResult, zero2);
                case 2 -> Expressions.lessThan(compareResult, zero2);
                case 3 -> Expressions.lessThanOrEqual(compareResult, zero2);
                case 4 -> Expressions.greaterThan(compareResult, zero2);
                case 5 -> Expressions.greaterThanOrEqual(compareResult, zero2);
            };
        }

        public static int compareTo(Object obj1, Object obj2) {
            ExprIpValue v1 = CompareImplementor.toExprIpValue(obj1);
            ExprIpValue v2 = CompareImplementor.toExprIpValue(obj2);
            return v1.compare(v2);
        }

        private static ExprIpValue toExprIpValue(Object obj) {
            if (obj instanceof ExprIpValue) {
                return (ExprIpValue)obj;
            }
            if (obj instanceof String) {
                return new ExprIpValue((String)obj);
            }
            throw new IllegalArgumentException("Invalid IP type: " + String.valueOf(obj));
        }
    }

    public static enum ComparisonType {
        EQUALS,
        NOT_EQUALS,
        LESS,
        LESS_OR_EQUAL,
        GREATER,
        GREATER_OR_EQUAL;

    }
}

