/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLUpdateMemoryInput
implements ToXContentObject,
Writeable {
    private String text;

    public MLUpdateMemoryInput(String text) {
        if (StringUtils.isBlank(text)) {
            throw new IllegalArgumentException("Text cannot be null or empty");
        }
        this.text = text.trim();
    }

    public MLUpdateMemoryInput(StreamInput in) throws IOException {
        this.text = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.text);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("text", this.text);
        builder.endObject();
        return builder;
    }

    public static MLUpdateMemoryInput parse(XContentParser parser) throws IOException {
        String text = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if ("text".equals(fieldName)) {
                text = parser.text();
                continue;
            }
            parser.skipChildren();
        }
        return MLUpdateMemoryInput.builder().text(text).build();
    }

    @Generated
    public static MLUpdateMemoryInputBuilder builder() {
        return new MLUpdateMemoryInputBuilder();
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public static class MLUpdateMemoryInputBuilder {
        @Generated
        private String text;

        @Generated
        MLUpdateMemoryInputBuilder() {
        }

        @Generated
        public MLUpdateMemoryInputBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Generated
        public MLUpdateMemoryInput build() {
            return new MLUpdateMemoryInput(this.text);
        }

        @Generated
        public String toString() {
            return "MLUpdateMemoryInput.MLUpdateMemoryInputBuilder(text=" + this.text + ")";
        }
    }
}

