/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;

public class MLMemoryContainer
implements ToXContentObject,
Writeable {
    private String name;
    private String description;
    private User owner;
    private String tenantId;
    private Instant createdTime;
    private Instant lastUpdatedTime;
    private MemoryStorageConfig memoryStorageConfig;

    public MLMemoryContainer(String name, String description2, User owner, String tenantId, Instant createdTime, Instant lastUpdatedTime, MemoryStorageConfig memoryStorageConfig) {
        this.name = name;
        this.description = description2;
        this.owner = owner;
        this.tenantId = tenantId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.memoryStorageConfig = memoryStorageConfig;
    }

    public MLMemoryContainer(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.tenantId = input.readOptionalString();
        this.createdTime = input.readOptionalInstant();
        this.lastUpdatedTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.memoryStorageConfig = new MemoryStorageConfig(input);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdatedTime);
        if (this.memoryStorageConfig != null) {
            out.writeBoolean(true);
            this.memoryStorageConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        }
        if (this.memoryStorageConfig != null) {
            builder.field("memory_storage_config", (ToXContent)this.memoryStorageConfig);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemoryContainer parse(XContentParser parser) throws IOException {
        String name = null;
        String description2 = null;
        User owner = null;
        String tenantId = null;
        Instant createdTime = null;
        Instant lastUpdatedTime = null;
        MemoryStorageConfig memoryStorageConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block18;
                }
                case "description": {
                    description2 = parser.text();
                    continue block18;
                }
                case "owner": {
                    owner = User.parse(parser);
                    continue block18;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block18;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    continue block18;
                }
                case "memory_storage_config": {
                    memoryStorageConfig = MemoryStorageConfig.parse(parser);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return MLMemoryContainer.builder().name(name).description(description2).owner(owner).tenantId(tenantId).createdTime(createdTime).lastUpdatedTime(lastUpdatedTime).memoryStorageConfig(memoryStorageConfig).build();
    }

    @Generated
    public static MLMemoryContainerBuilder builder() {
        return new MLMemoryContainerBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public MemoryStorageConfig getMemoryStorageConfig() {
        return this.memoryStorageConfig;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Generated
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public void setMemoryStorageConfig(MemoryStorageConfig memoryStorageConfig) {
        this.memoryStorageConfig = memoryStorageConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLMemoryContainer)) {
            return false;
        }
        MLMemoryContainer other = (MLMemoryContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        User this$owner = this.getOwner();
        User other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        MemoryStorageConfig this$memoryStorageConfig = this.getMemoryStorageConfig();
        MemoryStorageConfig other$memoryStorageConfig = other.getMemoryStorageConfig();
        return !(this$memoryStorageConfig == null ? other$memoryStorageConfig != null : !((Object)this$memoryStorageConfig).equals(other$memoryStorageConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLMemoryContainer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result2 = result2 * 59 + ($description == null ? 43 : $description.hashCode());
        User $owner = this.getOwner();
        result2 = result2 * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $tenantId = this.getTenantId();
        result2 = result2 * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Instant $createdTime = this.getCreatedTime();
        result2 = result2 * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result2 = result2 * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        MemoryStorageConfig $memoryStorageConfig = this.getMemoryStorageConfig();
        result2 = result2 * 59 + ($memoryStorageConfig == null ? 43 : ((Object)$memoryStorageConfig).hashCode());
        return result2;
    }

    @Generated
    public static class MLMemoryContainerBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private User owner;
        @Generated
        private String tenantId;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private MemoryStorageConfig memoryStorageConfig;

        @Generated
        MLMemoryContainerBuilder() {
        }

        @Generated
        public MLMemoryContainerBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder owner(User owner) {
            this.owner = owner;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLMemoryContainerBuilder memoryStorageConfig(MemoryStorageConfig memoryStorageConfig) {
            this.memoryStorageConfig = memoryStorageConfig;
            return this;
        }

        @Generated
        public MLMemoryContainer build() {
            return new MLMemoryContainer(this.name, this.description, this.owner, this.tenantId, this.createdTime, this.lastUpdatedTime, this.memoryStorageConfig);
        }

        @Generated
        public String toString() {
            return "MLMemoryContainer.MLMemoryContainerBuilder(name=" + this.name + ", description=" + this.description + ", owner=" + String.valueOf(this.owner) + ", tenantId=" + this.tenantId + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", memoryStorageConfig=" + String.valueOf(this.memoryStorageConfig) + ")";
        }
    }
}

