/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.EC;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvECPrivateKey;
import org.bouncycastle.jcajce.provider.ProvECPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509AlgorithmParameters;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.TwoStepKDFParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Properties;

class ProvEC
extends AsymmetricAlgorithmProvider {
    private static AgreementFactory fipsDHFactory;
    private static AgreementFactory fipsDHUFactory;
    private static AgreementFactory fipsMQVFactory;
    private static SignatureOperatorFactory fipsDsaFactory;
    private static final Map<String, String> generalEcAttributes;
    private static final String PREFIX;
    private static SignatureOperatorFactory genDsaFactory;
    private static final PublicKeyConverter<AsymmetricECPublicKey> publicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricECPrivateKey> privateKeyConverter;

    ProvEC() {
    }

    private static AgreementFactory getFipsDHFactory() {
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            fipsDHFactory = new FipsEC.DHAgreementFactory();
        }
        return fipsDHFactory;
    }

    private static AgreementFactory getFipsDHUFactory() {
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            fipsDHUFactory = new FipsEC.DHUAgreementFactory();
        }
        return fipsDHUFactory;
    }

    private static AgreementFactory getFipsMQVFactory() {
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            fipsMQVFactory = Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv") ? null : new FipsEC.MQVAgreementFactory();
        }
        return fipsMQVFactory;
    }

    private static SignatureOperatorFactory getFipsDSAFactory() {
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            fipsDsaFactory = new FipsEC.DSAOperatorFactory();
        }
        return fipsDsaFactory;
    }

    private static SignatureOperatorFactory getGeneralDSAFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (genDsaFactory == null) {
            genDsaFactory = new EC.DSAOperatorFactory();
        }
        return genDsaFactory;
    }

    private static Algorithm getAlgorithm(EC_Algorithm eC_Algorithm) {
        switch (eC_Algorithm) {
            case DSA: {
                return FipsEC.DSA.getAlgorithm();
            }
            case DH: {
                return FipsEC.DH.getAlgorithm();
            }
            case CDH: {
                return FipsEC.CDH.getAlgorithm();
            }
            case MQV: {
                return FipsEC.MQV.getAlgorithm();
            }
        }
        return FipsEC.ALGORITHM;
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.EC", PREFIX + "AlgorithmParametersSpi$EC", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECAlgParams();
            }
        });
        final ParametersCreator parametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.DH;
            }
        };
        final ParametersCreator parametersCreator2 = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECCDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.CDH;
            }
        };
        ParametersCreator parametersCreator3 = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof TwoStepKDFParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("TwoStep KDF requires a TwoStepKDFParameterSpec");
                }
                return FipsEC.CDH;
            }
        };
        DhuParamsCreator dhuParamsCreator = new DhuParamsCreator(false);
        DhuParamsCreator dhuParamsCreator2 = new DhuParamsCreator(true);
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.EC", PREFIX + "KeyFactorySpi$EC", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyFactory(EC_Algorithm.EC);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECDSA", PREFIX + "KeyFactorySpi$ECDSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyFactory(EC_Algorithm.DSA);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECDH", PREFIX + "KeyFactorySpi$ECDH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyFactory(EC_Algorithm.DH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECCDH", PREFIX + "KeyFactorySpi$ECCDH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyFactory(EC_Algorithm.CDH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECMQV", PREFIX + "KeyFactorySpi$ECMQV", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyFactory(EC_Algorithm.MQV);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.EC", PREFIX + "KeyPairGeneratorSpi$EC", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.ALGORITHM);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECDSA", PREFIX + "KeyPairGeneratorSpi$ECDSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.DSA);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECDH", PREFIX + "KeyPairGeneratorSpi$ECDH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.DH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECCDH", PREFIX + "KeyPairGeneratorSpi$ECCDH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.CDH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECMQV", PREFIX + "KeyPairGeneratorSpi$ECMQV", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.MQV);
            }
        });
        this.registerOid(bouncyCastleFipsProvider, X9ObjectIdentifiers.id_ecPublicKey, "EC", new ECKeyFactory(EC_Algorithm.DSA));
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECDH", PREFIX + "KeyAgreementSpi$DH", generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator);
            }
        });
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECCDH", PREFIX + "KeyAgreementSpi$CDH", generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator2);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyAgreement.ECDHC", "ECCDH");
        ECKeyFactory eCKeyFactory = new ECKeyFactory(EC_Algorithm.DH);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, eCKeyFactory, parametersCreator);
        eCKeyFactory = new ECKeyFactory(EC_Algorithm.CDH);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, eCKeyFactory, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.AgreementKDFPRF.SHA224_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.AgreementKDFPRF.SHA256_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.AgreementKDFPRF.SHA384_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.AgreementKDFPRF.SHA512_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512_HMAC, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "KMAC-128", FipsKDF.AgreementKDFPRF.KMAC_128, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "KMAC-256", FipsKDF.AgreementKDFPRF.KMAC_256, parametersCreator2);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "CMAC", FipsKDF.PRF.AES_CMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA1", FipsKDF.PRF.SHA1_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.PRF.SHA224_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.PRF.SHA256_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.PRF.SHA384_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.PRF.SHA512_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.PRF.SHA512_224_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.PRF.SHA512_256_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.PRF.SHA3_224_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.PRF.SHA3_256_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.PRF.SHA3_384_HMAC, parametersCreator3);
        this.addTwoStepCDHAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.PRF.SHA3_512_HMAC, parametersCreator3);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, dhuParamsCreator);
        this.addCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.AgreementKDFPRF.SHA224_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.AgreementKDFPRF.SHA256_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.AgreementKDFPRF.SHA384_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.AgreementKDFPRF.SHA512_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512_HMAC, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "KMAC-128", FipsKDF.AgreementKDFPRF.KMAC_128, dhuParamsCreator);
        this.addConcatCDHUAlgorithm(bouncyCastleFipsProvider, "KMAC-256", FipsKDF.AgreementKDFPRF.KMAC_256, dhuParamsCreator);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "CMAC", FipsKDF.PRF.AES_CMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA1", FipsKDF.PRF.SHA1_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.PRF.SHA224_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.PRF.SHA256_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.PRF.SHA384_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.PRF.SHA512_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.PRF.SHA512_224_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.PRF.SHA512_256_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.PRF.SHA3_224_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.PRF.SHA3_256_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.PRF.SHA3_384_HMAC, dhuParamsCreator2);
        this.addTwoStepCDHUAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.PRF.SHA3_512_HMAC, dhuParamsCreator2);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.NONEWITHECDSA", PREFIX + "SignatureSpi$ecDSAwithNONE", generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(null));
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "NONEWITHECDSA", "RAWECDSA");
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA1WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA224WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA256WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA384WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA384", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(224)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(256)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA3-224WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA3-256WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA3-384WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_384", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA3-512WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_512", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512));
                }
            }));
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.ECDDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.DETECDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA1WITHDETECDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA224WITHDETECDSA", "SHA224WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA256WITHDETECDSA", "SHA256WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA384WITHDETECDSA", "SHA384WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512WITHDETECDSA", "SHA512WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512(224)WITHDETECDSA", "SHA512(224)WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512(256)WITHDETECDSA", "SHA512(256)WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA3-224WITHDETECDSA", "SHA3-224WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA3-256WITHDETECDSA", "SHA3-256WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA3-384WITHDETECDSA", "SHA3-384WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA3-512WITHDETECDSA", "SHA3-512WITHECDDSA");
        }
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA1", "ECDSA", PREFIX + "SignatureSpi$ecDSA1", X9ObjectIdentifiers.ecdsa_with_SHA1, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHECDSA", "ECDSA");
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHECDSA", TeleTrusTObjectIdentifiers.ecSignWithSha1);
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA224", "ECDSA", PREFIX + "SignatureSpi$ecDSA224", X9ObjectIdentifiers.ecdsa_with_SHA224, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA256", "ECDSA", PREFIX + "SignatureSpi$ecDSA256", X9ObjectIdentifiers.ecdsa_with_SHA256, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA384", "ECDSA", PREFIX + "SignatureSpi$ecDSA384", X9ObjectIdentifiers.ecdsa_with_SHA384, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512", "ECDSA", PREFIX + "SignatureSpi$ecDSA512", X9ObjectIdentifiers.ecdsa_with_SHA512, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_224", null, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_256", null, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA3-224", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_224", NISTObjectIdentifiers.id_ecdsa_with_sha3_224, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA3-256", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_256", NISTObjectIdentifiers.id_ecdsa_with_sha3_256, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA3-384", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_384", NISTObjectIdentifiers.id_ecdsa_with_sha3_384, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA3-512", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_512", NISTObjectIdentifiers.id_ecdsa_with_sha3_512, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getFipsDSAFactory(), publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512));
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addSignatureAlgorithm(bouncyCastleFipsProvider, "RIPEMD160", "ECDSA", PREFIX + "SignatureSpi$ecDSARipeMD160", TeleTrusTObjectIdentifiers.ecSignWithRipemd160, generalEcAttributes, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DSA.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160));
                }
            }));
        }
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv")) {
            eCKeyFactory = new ECKeyFactory(EC_Algorithm.MQV);
            final MqvParamsCreator mqvParamsCreator = new MqvParamsCreator(false);
            this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECMQV", PREFIX + "KeyAgreementSpi$ECMQV", generalEcAttributes, new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseAgreement(ProvEC.getFipsMQVFactory(), publicKeyConverter, privateKeyConverter, mqvParamsCreator);
                }
            });
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, eCKeyFactory, mqvParamsCreator);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, eCKeyFactory, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.AgreementKDFPRF.SHA224_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.AgreementKDFPRF.SHA256_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.AgreementKDFPRF.SHA384_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.AgreementKDFPRF.SHA512_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512_HMAC, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "KMAC-128", FipsKDF.AgreementKDFPRF.KMAC_128, mqvParamsCreator);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "KMAC-256", FipsKDF.AgreementKDFPRF.KMAC_256, mqvParamsCreator);
            MqvParamsCreator mqvParamsCreator2 = new MqvParamsCreator(true);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "CMAC", FipsKDF.PRF.AES_CMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA1", FipsKDF.PRF.SHA1_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA224", FipsKDF.PRF.SHA224_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA256", FipsKDF.PRF.SHA256_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA384", FipsKDF.PRF.SHA384_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512", FipsKDF.PRF.SHA512_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(224)", FipsKDF.PRF.SHA512_224_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA512(256)", FipsKDF.PRF.SHA512_256_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-224", FipsKDF.PRF.SHA3_224_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-256", FipsKDF.PRF.SHA3_256_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-384", FipsKDF.PRF.SHA3_384_HMAC, mqvParamsCreator2);
            this.addTwoStepMQVAlgorithm(bouncyCastleFipsProvider, "HMACSHA3-512", FipsKDF.PRF.SHA3_512_HMAC, mqvParamsCreator2);
        }
    }

    private void addDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECDHWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "ECDH", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "ECCDH", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addConcatCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHWITH" + string + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addTwoStepCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.PRF pRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHWITH" + string + "TSKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.TWO_STEP_KEY_BUILDER.withPRF(pRF));
            }
        });
    }

    private void addCDHUAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHUWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHUFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addConcatCDHUAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHUWITH" + string + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHUFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addTwoStepCDHUAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.PRF pRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHUWITH" + string + "TSKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsDHUFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.TWO_STEP_KEY_BUILDER.withPRF(pRF));
            }
        });
    }

    private void addMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECMQVWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsMQVFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "EC", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addConcatMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECMQVWITH" + string + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsMQVFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addTwoStepMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.PRF pRF, final ParametersCreator parametersCreator) {
        String string2 = "ECMQVWITH" + string + "TSKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(ProvEC.getFipsMQVFactory(), publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.TWO_STEP_KEY_BUILDER.withPRF(pRF));
            }
        });
    }

    private static ECDomainParameters getDomainParametersFromName(String string) {
        NamedECDomainParameters namedECDomainParameters;
        try {
            if (string.charAt(0) >= '0' && string.charAt(0) <= '2') {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters(aSN1ObjectIdentifier);
            } else if (string.indexOf(32) > 0) {
                string = string.substring(string.indexOf(32) + 1);
                namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
            } else {
                namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
        }
        return namedECDomainParameters;
    }

    private static NamedECDomainParameters getNamedECDomainParametersFromName(final String string) {
        return ECDomainParametersIndex.lookupDomainParameters(new ECDomainParametersID(){

            @Override
            public String getCurveName() {
                return string;
            }
        });
    }

    static String getNameFrom(final AlgorithmParameterSpec algorithmParameterSpec) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = algorithmParameterSpec.getClass().getMethod("getName", new Class[0]);
                    return method.invoke((Object)algorithmParameterSpec, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static {
        generalEcAttributes = new HashMap<String, String>();
        PREFIX = ProvEC.class.getName() + ".";
        generalEcAttributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalEcAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        publicKeyConverter = new PublicKeyConverter<AsymmetricECPublicKey>(){

            @Override
            public AsymmetricECPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ECPublicKey) {
                    if (publicKey instanceof ProvECPublicKey) {
                        return ((ProvECPublicKey)publicKey).getBaseKey();
                    }
                    return new ProvECPublicKey(algorithm, (ECPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricECPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EC public key: " + exception.getMessage(), exception);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricECPrivateKey>(){

            @Override
            public AsymmetricECPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ECPrivateKey) {
                    if (privateKey instanceof ProvECPrivateKey) {
                        return ((ProvECPrivateKey)privateKey).getBaseKey();
                    }
                    return new ProvECPrivateKey(algorithm, (ECPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricECPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EC private key: " + exception.getMessage(), exception);
                }
            }
        };
    }

    private static class DhuParamsCreator
    implements ParametersCreator {
        private final boolean isTS;

        DhuParamsCreator(boolean bl) {
            this.isTS = bl;
        }

        public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            try {
                if (!(algorithmParameterSpec instanceof DHUParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("ECCDHU can only take an DHUParameterSpec");
                }
                DHUParameterSpec dHUParameterSpec = (DHUParameterSpec)algorithmParameterSpec;
                if (this.isTS && !(dHUParameterSpec.getKdfParameterSpec() instanceof TwoStepKDFParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("ECCDHU with TwoStep needs a TwoStepKDFParameterSpec");
                }
                if (dHUParameterSpec.getEphemeralPublicKey() != null) {
                    return FipsEC.CDHU.using((AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dHUParameterSpec.getEphemeralPublicKey()), (AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dHUParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dHUParameterSpec.getOtherPartyEphemeralKey()));
                }
                return FipsEC.CDHU.using((AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dHUParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dHUParameterSpec.getOtherPartyEphemeralKey()));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + invalidKeyException.getMessage(), invalidKeyException);
            }
        }
    }

    static class ECAlgParams
    extends X509AlgorithmParameters {
        private ECDomainParameters domainParameters = ECDomainParametersIndex.lookupDomainParameters(SECObjectIdentifiers.secp521r1);

        ECAlgParams() {
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (ECParameterSpec.class.isAssignableFrom(clazz) || clazz == AlgorithmParameterSpec.class) {
                return ECUtil.convertToSpec(this.domainParameters);
            }
            if (ECGenParameterSpec.class.isAssignableFrom(clazz)) {
                if (this.domainParameters instanceof NamedECDomainParameters) {
                    return new ECGenParameterSpec(((NamedECDomainParameters)this.domainParameters).getID().getId());
                }
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECDomainParametersIndex.lookupOID(this.domainParameters);
                if (aSN1ObjectIdentifier != null) {
                    return new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
                }
                throw new InvalidParameterSpecException("Cannot identify curve in AlgorithmParameters by name");
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
                this.domainParameters = ProvEC.getDomainParametersFromName(eCGenParameterSpec.getName());
                if (this.domainParameters == null) {
                    throw new InvalidParameterSpecException("EC AlgorithmParameters cannot recognize curve " + eCGenParameterSpec.getName());
                }
            } else if (algorithmParameterSpec instanceof ECDomainParameterSpec) {
                this.domainParameters = ((ECDomainParameterSpec)algorithmParameterSpec).getDomainParameters();
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                this.domainParameters = ECUtil.convertFromSpec((ECParameterSpec)algorithmParameterSpec);
            } else {
                if (algorithmParameterSpec == null) {
                    throw new InvalidParameterSpecException("parameterSpec cannot be null");
                }
                String string = ProvEC.getNameFrom(algorithmParameterSpec);
                if (string != null) {
                    this.domainParameters = ProvEC.getDomainParametersFromName(string);
                    if (this.domainParameters == null) {
                        throw new InvalidParameterSpecException("unknown curve ID: " + string);
                    }
                } else {
                    throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
                }
            }
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            this.domainParameters = ECAlgParams.decodeCurveParameters(byArray);
        }

        @Override
        protected byte[] localGetEncoded() throws IOException {
            X962Parameters x962Parameters;
            if (this.domainParameters instanceof NamedECDomainParameters) {
                x962Parameters = new X962Parameters(((NamedECDomainParameters)this.domainParameters).getID());
            } else if (this.domainParameters instanceof ECImplicitDomainParameters) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                X9ECParameters x9ECParameters = new X9ECParameters(this.domainParameters.getCurve(), new X9ECPoint(this.domainParameters.getG(), false), this.domainParameters.getN(), this.domainParameters.getH(), this.domainParameters.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters.getEncoded();
        }

        private static ECDomainParameters decodeCurveParameters(byte[] byArray) throws IOException {
            X962Parameters x962Parameters = X962Parameters.getInstance(byArray);
            if (x962Parameters.isNamedCurve()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                return ECDomainParametersIndex.lookupDomainParameters(aSN1ObjectIdentifier);
            }
            if (!x962Parameters.isImplicitlyCA()) {
                X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
                return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            }
            ECDomainParameters eCDomainParameters = (ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA);
            if (eCDomainParameters == null) {
                throw new IOException("Encoding indicates implicitlyCA but CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA) returns null");
            }
            return new ECImplicitDomainParameters(eCDomainParameters);
        }

        @Override
        protected String engineToString() {
            return "EC AlgorithmParameters " + this.domainParameters;
        }
    }

    static class ECKeyFactory
    extends BaseKeyFactory
    implements AsymmetricKeyInfoConverter {
        private final EC_Algorithm algorithm;

        ECKeyFactory(EC_Algorithm eC_Algorithm) {
            this.algorithm = eC_Algorithm;
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            Algorithm algorithm = ProvEC.getAlgorithm(this.algorithm);
            if (key instanceof PublicKey) {
                return new ProvECPublicKey((AsymmetricECPublicKey)publicKeyConverter.convertKey(algorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvECPrivateKey((AsymmetricECPrivateKey)privateKeyConverter.convertKey(algorithm, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            ECPrivateKey eCPrivateKey;
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)key;
                if (eCPublicKey.getParams() != null) {
                    return new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
                }
            } else if (clazz.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof ECPrivateKey && (eCPrivateKey = (ECPrivateKey)key).getParams() != null) {
                return new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            Algorithm algorithm = ProvEC.getAlgorithm(this.algorithm);
            if (keySpec instanceof ECPrivateKeySpec) {
                try {
                    return new ProvECPrivateKey(algorithm, (ECPrivateKeySpec)keySpec);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidKeySpecException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            Algorithm algorithm = ProvEC.getAlgorithm(this.algorithm);
            if (keySpec instanceof ECPublicKeySpec) {
                try {
                    return new ProvECPublicKey(algorithm, (ECPublicKeySpec)keySpec);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidKeySpecException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            Algorithm algorithm = ProvEC.getAlgorithm(this.algorithm);
            return new ProvECPrivateKey(new AsymmetricECPrivateKey(algorithm, privateKeyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            Algorithm algorithm = ProvEC.getAlgorithm(this.algorithm);
            return new ProvECPublicKey(new AsymmetricECPublicKey(algorithm, subjectPublicKeyInfo));
        }
    }

    static class ECKeyPairGenerator
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm algorithmType;
        private final Parameters parameters;
        private AsymmetricKeyPairGenerator engine;
        private int strength = 224;
        private boolean initialised = false;
        private static Hashtable ecParameters = new Hashtable();

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm algorithm) {
            this(bouncyCastleFipsProvider, algorithm, null);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters parameters2) {
            this(bouncyCastleFipsProvider, parameters2.getAlgorithm(), parameters2);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm algorithm, Parameters parameters2) {
            super(algorithm.getName());
            this.fipsProvider = bouncyCastleFipsProvider;
            this.algorithmType = algorithm;
            this.parameters = parameters2;
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(n));
            if (eCGenParameterSpec != null) {
                try {
                    this.initialize(eCGenParameterSpec, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("Key size " + n + " bits not available");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            ECDomainParameters eCDomainParameters;
            if (secureRandom == null) {
                secureRandom = this.fipsProvider.getDefaultSecureRandom();
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCDomainParameters = ECUtil.convertFromSpec((ECParameterSpec)algorithmParameterSpec);
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                eCDomainParameters = ProvEC.getDomainParametersFromName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                if (eCDomainParameters == null) {
                    throw new InvalidAlgorithmParameterException("unknown curve ID: " + ((ECGenParameterSpec)algorithmParameterSpec).getName());
                }
            } else if (algorithmParameterSpec == null) {
                eCDomainParameters = (ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA);
                if (eCDomainParameters == null) {
                    throw new InvalidAlgorithmParameterException("null AlgorithmParameterSpec passed but no implicit CA set");
                }
                eCDomainParameters = new ECImplicitDomainParameters(eCDomainParameters);
            } else {
                String string = ProvEC.getNameFrom(algorithmParameterSpec);
                if (string != null) {
                    eCDomainParameters = ProvEC.getDomainParametersFromName(string);
                    if (eCDomainParameters == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve ID: " + string);
                    }
                } else {
                    throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
                }
            }
            this.engine = this.algorithmType instanceof FipsAlgorithm ? (this.parameters != null ? (this.parameters instanceof FipsEC.DSAParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.DSAParameters)this.parameters, eCDomainParameters), secureRandom) : (this.parameters instanceof FipsEC.AgreementParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.AgreementParameters)this.parameters, eCDomainParameters), secureRandom) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.MQVAgreementParametersBuilder)this.parameters, eCDomainParameters), secureRandom))) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(eCDomainParameters), secureRandom)) : (this.parameters != null ? new EC.KeyPairGenerator(new EC.KeyGenParameters((EC.DSAParameters)this.parameters, eCDomainParameters), secureRandom) : new EC.KeyPairGenerator(new EC.KeyGenParameters(eCDomainParameters), secureRandom));
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, this.fipsProvider.getDefaultSecureRandom());
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvECPublicKey(asymmetricECPublicKey), new ProvECPrivateKey(asymmetricECPrivateKey));
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }

    private static enum EC_Algorithm {
        DSA,
        DH,
        EC,
        CDH,
        MQV;

    }

    private static class MqvParamsCreator
    implements ParametersCreator {
        private final boolean isTS;

        MqvParamsCreator(boolean bl) {
            this.isTS = bl;
        }

        public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            try {
                if (!(algorithmParameterSpec instanceof MQVParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("ECMQV can only take an MQVParameterSpec");
                }
                MQVParameterSpec mQVParameterSpec = (MQVParameterSpec)algorithmParameterSpec;
                if (this.isTS && !(mQVParameterSpec.getKdfParameterSpec() instanceof TwoStepKDFParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("ECMQV with TwoStep needs a TwoStepKDFParameterSpec");
                }
                if (mQVParameterSpec.getEphemeralPublicKey() != null) {
                    return FipsEC.MQV.using((AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPublicKey()), (AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
                }
                return FipsEC.MQV.using((AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + invalidKeyException.getMessage(), invalidKeyException);
            }
        }
    }
}

