/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import shaded.com.google.common.collect.ImmutableList;

abstract class ApplySqlType
extends AbstractSqlType {
    protected final ImmutableList<? extends RelDataType> types;

    ApplySqlType(SqlTypeName typeName, boolean isNullable, Iterable<? extends RelDataType> types) {
        super(typeName, isNullable, null);
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append((Object)this.typeName).append('<');
        Ord.forEach(this.types, (type2, i) -> {
            if (i > 0) {
                sb.append(", ");
            }
            if (withDetail) {
                sb.append(type2.getFullTypeString());
            } else {
                sb.append(type2.toString());
            }
        });
        sb.append('>');
    }
}

