/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TransientTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ListTransientTable
extends AbstractQueryableTable
implements TransientTable,
ModifiableTable,
ScannableTable {
    private static final Type TYPE = Object[].class;
    private final List rows = new ArrayList();
    private final String name;
    private final RelDataType protoRowType;

    public ListTransientTable(String name, RelDataType rowType) {
        super(TYPE);
        this.name = name;
        this.protoRowType = rowType;
    }

    @Override
    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened) {
        return LogicalTableModify.create(table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
    }

    @Override
    public Collection getModifiableCollection() {
        return this.rows;
    }

    @Override
    public Enumerable<@Nullable Object[]> scan(DataContext root) {
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            @Override
            public Enumerator<@Nullable Object[]> enumerator() {
                return new Enumerator<Object[]>(){
                    private final List list;
                    private int i;
                    {
                        this.list = new ArrayList(ListTransientTable.this.rows);
                        this.i = -1;
                    }

                    @Override
                    public Object[] current() {
                        Object[] objectArray;
                        Object current = this.list.get(this.i);
                        if (current != null && current.getClass().isArray()) {
                            objectArray = (Object[])current;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = current;
                        }
                        return objectArray;
                    }

                    @Override
                    public boolean moveNext() {
                        if (cancelFlag != null && cancelFlag.get()) {
                            return false;
                        }
                        return ++this.i < this.list.size();
                    }

                    @Override
                    public void reset() {
                        this.i = -1;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    @Override
    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression(schema, this.elementType, tableName, clazz);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

            @Override
            public Enumerator<T> enumerator() {
                return Linq4j.enumerator(ListTransientTable.this.rows);
            }
        };
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return typeFactory.copyType(this.protoRowType);
    }

    @Override
    public Type getElementType() {
        return TYPE;
    }
}

