/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.AbstractList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexVariable;

public abstract class RexSlot
extends RexVariable {
    protected final int index;

    protected RexSlot(String name, int index, RelDataType type2) {
        super(name, type2);
        assert (index >= 0);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    protected static class SelfPopulatingList
    extends CopyOnWriteArrayList<String> {
        private final String prefix;

        SelfPopulatingList(String prefix, int initialSize) {
            super(SelfPopulatingList.fromTo(prefix, 0, initialSize));
            this.prefix = prefix;
        }

        private static AbstractList<String> fromTo(final String prefix, final int start, final int end) {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return prefix + (index + start);
                }

                @Override
                public int size() {
                    return end - start;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get(int index) {
            while (true) {
                try {
                    return (String)super.get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    if (index < 0) {
                        throw new IllegalArgumentException();
                    }
                    SelfPopulatingList selfPopulatingList = this;
                    synchronized (selfPopulatingList) {
                        int size = this.size();
                        if (index >= size) {
                            this.addAll(SelfPopulatingList.fromTo(this.prefix, size, Math.max(index + 1, size * 2)));
                        }
                    }
                }
            }
        }
    }
}

