/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching.pattern;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Match;
import com.facebook.presto.matching.Matcher;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.PatternVisitor;
import java.util.Objects;

public class EqualsPattern<T>
extends Pattern<T> {
    private final T expectedValue;

    public EqualsPattern(T expectedValue, Pattern<?> previous) {
        super(previous);
        this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue can't be null. Use isNull() pattern instead.");
    }

    public T expectedValue() {
        return this.expectedValue;
    }

    @Override
    public Match<T> accept(Matcher matcher, Object object, Captures captures) {
        return matcher.matchEquals(this, object, captures);
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitEquals(this);
    }
}

