/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.opensearch.common.time.DateUtils;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.securityanalytics.threatIntel.action.PutTIFJobRequest;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.model.TIFMetadata;

public class TIFJobParameter
implements Writeable,
ScheduledJobParameter {
    public static final String THREAT_INTEL_DATA_INDEX_NAME_PREFIX = ".opensearch-sap-threat-intel";
    private static final String NAME_FIELD = "name";
    private static final String ENABLED_FIELD = "update_enabled";
    private static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    private static final String LAST_UPDATE_TIME_FIELD_READABLE = "last_update_time_field";
    private static final String SCHEDULE_FIELD = "schedule";
    private static final String ENABLED_TIME_FIELD = "enabled_time";
    private static final String ENABLED_TIME_FIELD_READABLE = "enabled_time_field";
    private static final String STATE_FIELD = "state";
    private static final String INDICES_FIELD = "indices";
    private static final String UPDATE_STATS_FIELD = "update_stats";
    public static final ParseField NAME_PARSER_FIELD = new ParseField("name", new String[0]);
    public static final ParseField ENABLED_PARSER_FIELD = new ParseField("update_enabled", new String[0]);
    public static final ParseField LAST_UPDATE_TIME_PARSER_FIELD = new ParseField("last_update_time", new String[0]);
    public static final ParseField LAST_UPDATE_TIME_FIELD_READABLE_PARSER_FIELD = new ParseField("last_update_time_field", new String[0]);
    public static final ParseField SCHEDULE_PARSER_FIELD = new ParseField("schedule", new String[0]);
    public static final ParseField ENABLED_TIME_PARSER_FIELD = new ParseField("enabled_time", new String[0]);
    public static final ParseField ENABLED_TIME_FIELD_READABLE_PARSER_FIELD = new ParseField("enabled_time_field", new String[0]);
    public static final ParseField STATE_PARSER_FIELD = new ParseField("state", new String[0]);
    public static final ParseField INDICES_PARSER_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField UPDATE_STATS_PARSER_FIELD = new ParseField("update_stats", new String[0]);
    private String name;
    private Instant lastUpdateTime;
    private Instant enabledTime;
    private boolean isEnabled;
    private IntervalSchedule schedule;
    private TIFJobState state;
    private List<String> indices;
    private UpdateStats updateStats;
    public static final ConstructingObjectParser<TIFJobParameter, Void> PARSER = new ConstructingObjectParser("tifjob_metadata", true, args -> {
        String name = (String)args[0];
        Instant lastUpdateTime = Instant.ofEpochMilli((Long)args[1]);
        Instant enabledTime = args[2] == null ? null : Instant.ofEpochMilli((Long)args[2]);
        boolean isEnabled = (Boolean)args[3];
        IntervalSchedule schedule = (IntervalSchedule)args[4];
        TIFJobState state = TIFJobState.valueOf((String)args[5]);
        List indices = (List)args[6];
        UpdateStats updateStats = (UpdateStats)args[7];
        TIFJobParameter parameter = new TIFJobParameter(name, lastUpdateTime, enabledTime, isEnabled, schedule, state, indices, updateStats);
        return parameter;
    });

    public static TIFJobParameter parseFromParser(XContentParser xcp, String id, Long version) throws IOException {
        String name = null;
        Instant lastUpdateTime = null;
        Boolean isEnabled = null;
        TIFJobState state = null;
        Instant enabledTime = null;
        IntervalSchedule schedule = null;
        ArrayList<String> indices = new ArrayList<String>();
        UpdateStats updateStats = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (true) {
            String fieldName;
            switch (fieldName = xcp.currentName()) {
                case "name": {
                    name = xcp.text();
                    break;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(xcp.longValue());
                    break;
                }
                case "enabled_time": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        enabledTime = null;
                        break;
                    }
                    if (xcp.currentToken().isValue()) {
                        enabledTime = Instant.ofEpochMilli(xcp.longValue());
                        break;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    enabledTime = null;
                    break;
                }
                case "update_enabled": {
                    isEnabled = xcp.booleanValue();
                    break;
                }
                case "schedule": {
                    schedule = (IntervalSchedule)ScheduleParser.parse((XContentParser)xcp);
                    break;
                }
                case "state": {
                    state = TIFJobParameter.toState(xcp.text());
                    break;
                }
                case "indices": {
                    indices = new ArrayList();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        indices.add(xcp.text());
                    }
                    break;
                }
                case "update_stats": {
                    updateStats = (UpdateStats)UpdateStats.PARSER.parse(xcp, null);
                    break;
                }
                default: {
                    xcp.skipChildren();
                }
            }
            if (xcp.nextToken() == XContentParser.Token.END_OBJECT) break;
            xcp.nextToken();
        }
        return new TIFJobParameter(name, lastUpdateTime, enabledTime, isEnabled, schedule, state, indices, updateStats);
    }

    public static TIFJobParameter parse(XContentParser xcp, String id, Long version) throws IOException {
        String name = null;
        Instant lastUpdateTime = null;
        Boolean isEnabled = null;
        TIFJobState state = null;
        xcp.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    name = xcp.text();
                    continue block12;
                }
                case "last_update_time": {
                    lastUpdateTime = Instant.ofEpochMilli(xcp.longValue());
                    continue block12;
                }
                case "update_enabled": {
                    isEnabled = xcp.booleanValue();
                    continue block12;
                }
                case "state": {
                    state = TIFJobParameter.toState(xcp.text());
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new TIFJobParameter(name, lastUpdateTime, isEnabled, state);
    }

    public static TIFJobState toState(String stateName) {
        if (stateName.equals("CREATING")) {
            return TIFJobState.CREATING;
        }
        if (stateName.equals("AVAILABLE")) {
            return TIFJobState.AVAILABLE;
        }
        if (stateName.equals("CREATE_FAILED")) {
            return TIFJobState.CREATE_FAILED;
        }
        if (stateName.equals("DELETING")) {
            return TIFJobState.DELETING;
        }
        return null;
    }

    public TIFJobParameter(String name, Instant lastUpdateTime, Boolean isEnabled, TIFJobState state) {
        this.name = name;
        this.lastUpdateTime = lastUpdateTime;
        this.isEnabled = isEnabled;
        this.state = state;
    }

    public TIFJobParameter() {
        this(null, null);
    }

    public TIFJobParameter(String name, Instant lastUpdateTime, Instant enabledTime, Boolean isEnabled, IntervalSchedule schedule, TIFJobState state, List<String> indices, UpdateStats updateStats) {
        this.name = name;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.isEnabled = isEnabled;
        this.schedule = schedule;
        this.state = state;
        this.indices = indices;
        this.updateStats = updateStats;
    }

    public TIFJobParameter(String name, IntervalSchedule schedule) {
        this(name, Instant.now().truncatedTo(ChronoUnit.MILLIS), null, false, schedule, TIFJobState.CREATING, new ArrayList<String>(), new UpdateStats());
    }

    public TIFJobParameter(StreamInput in) throws IOException {
        this.name = in.readString();
        this.lastUpdateTime = DateUtils.toInstant((long)in.readVLong());
        this.enabledTime = DateUtils.toInstant((long)in.readOptionalVLong());
        this.isEnabled = in.readBoolean();
        this.schedule = new IntervalSchedule(in);
        this.state = TIFJobState.valueOf(in.readString());
        this.indices = in.readStringList();
        this.updateStats = new UpdateStats(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.lastUpdateTime.toEpochMilli());
        out.writeOptionalVLong(this.enabledTime == null ? null : Long.valueOf(this.enabledTime.toEpochMilli()));
        out.writeBoolean(this.isEnabled);
        this.schedule.writeTo(out);
        out.writeString(this.state.name());
        out.writeStringCollection(this.indices);
        this.updateStats.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_PARSER_FIELD.getPreferredName(), this.name);
        builder.timeField(LAST_UPDATE_TIME_PARSER_FIELD.getPreferredName(), LAST_UPDATE_TIME_FIELD_READABLE_PARSER_FIELD.getPreferredName(), this.lastUpdateTime.toEpochMilli());
        if (this.enabledTime != null) {
            builder.timeField(ENABLED_TIME_PARSER_FIELD.getPreferredName(), ENABLED_TIME_FIELD_READABLE_PARSER_FIELD.getPreferredName(), this.enabledTime.toEpochMilli());
        }
        builder.field(ENABLED_PARSER_FIELD.getPreferredName(), this.isEnabled);
        builder.field(SCHEDULE_PARSER_FIELD.getPreferredName(), (ToXContent)this.schedule);
        builder.field(STATE_PARSER_FIELD.getPreferredName(), this.state.name());
        builder.field(INDICES_PARSER_FIELD.getPreferredName(), this.indices);
        builder.field(UPDATE_STATS_PARSER_FIELD.getPreferredName(), (ToXContent)this.updateStats);
        builder.endObject();
        return builder;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabledTime(Instant enabledTime) {
        this.enabledTime = enabledTime;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setIndices(List<String> indices) {
        this.indices = indices;
    }

    public String getName() {
        return this.name;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public IntervalSchedule getSchedule() {
        return this.schedule;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Long getLockDurationSeconds() {
        return 300L;
    }

    public void enable() {
        if (this.isEnabled) {
            return;
        }
        this.enabledTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.isEnabled = true;
    }

    public void disable() {
        this.enabledTime = null;
        this.isEnabled = false;
    }

    public void setSchedule(IntervalSchedule schedule) {
        this.schedule = schedule;
    }

    public String newIndexName(TIFJobParameter jobSchedulerParameter, TIFMetadata tifMetadata) {
        List<String> indices = jobSchedulerParameter.getIndices();
        Optional<String> nameOptional = indices.stream().filter(name -> name.contains(tifMetadata.getFeedId())).findAny();
        String suffix = "1";
        if (nameOptional.isPresent()) {
            String lastChar = "" + nameOptional.get().charAt(nameOptional.get().length() - 1);
            suffix = lastChar.equals("1") ? "2" : suffix;
        }
        return String.format(Locale.ROOT, "%s-%s%s", THREAT_INTEL_DATA_INDEX_NAME_PREFIX, tifMetadata.getFeedId(), suffix);
    }

    public TIFJobState getState() {
        return this.state;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public void setState(TIFJobState previousState) {
        this.state = previousState;
    }

    public UpdateStats getUpdateStats() {
        return this.updateStats;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_PARSER_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_UPDATE_TIME_PARSER_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ENABLED_TIME_PARSER_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_PARSER_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ScheduleParser.parse((XContentParser)p), SCHEDULE_PARSER_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATE_PARSER_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDICES_PARSER_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), UpdateStats.PARSER, UPDATE_STATS_PARSER_FIELD);
    }

    public static class UpdateStats
    implements Writeable,
    ToXContent {
        private static final ParseField LAST_SUCCEEDED_AT_FIELD = new ParseField("last_succeeded_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_SUCCEEDED_AT_FIELD_READABLE = new ParseField("last_succeeded_at", new String[0]);
        private static final ParseField LAST_PROCESSING_TIME_IN_MILLIS_FIELD = new ParseField("last_processing_time_in_millis", new String[0]);
        private static final ParseField LAST_FAILED_AT_FIELD = new ParseField("last_failed_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_FAILED_AT_FIELD_READABLE = new ParseField("last_failed_at", new String[0]);
        private static final ParseField LAST_SKIPPED_AT = new ParseField("last_skipped_at_in_epoch_millis", new String[0]);
        private static final ParseField LAST_SKIPPED_AT_READABLE = new ParseField("last_skipped_at", new String[0]);
        private Instant lastSucceededAt;
        private Long lastProcessingTimeInMillis;
        private Instant lastFailedAt;
        private Instant lastSkippedAt;
        private static final ConstructingObjectParser<UpdateStats, Void> PARSER = new ConstructingObjectParser("tifjob_metadata_update_stats", true, args -> {
            Instant lastSucceededAt = args[0] == null ? null : Instant.ofEpochMilli((Long)args[0]);
            Long lastProcessingTimeInMillis = (Long)args[1];
            Instant lastFailedAt = args[2] == null ? null : Instant.ofEpochMilli((Long)args[2]);
            Instant lastSkippedAt = args[3] == null ? null : Instant.ofEpochMilli((Long)args[3]);
            return new UpdateStats(lastSucceededAt, lastProcessingTimeInMillis, lastFailedAt, lastSkippedAt);
        });

        public Instant getLastSucceededAt() {
            return this.lastSucceededAt;
        }

        public Long getLastProcessingTimeInMillis() {
            return this.lastProcessingTimeInMillis;
        }

        public Instant getLastFailedAt() {
            return this.lastFailedAt;
        }

        public Instant getLastSkippedAt() {
            return this.lastSkippedAt;
        }

        private UpdateStats() {
        }

        public void setLastSkippedAt(Instant lastSkippedAt) {
            this.lastSkippedAt = lastSkippedAt;
        }

        public void setLastSucceededAt(Instant lastSucceededAt) {
            this.lastSucceededAt = lastSucceededAt;
        }

        public void setLastProcessingTimeInMillis(Long lastProcessingTimeInMillis) {
            this.lastProcessingTimeInMillis = lastProcessingTimeInMillis;
        }

        public UpdateStats(StreamInput in) throws IOException {
            this.lastSucceededAt = DateUtils.toInstant((long)in.readOptionalVLong());
            this.lastProcessingTimeInMillis = in.readOptionalVLong();
            this.lastFailedAt = DateUtils.toInstant((long)in.readOptionalVLong());
            this.lastSkippedAt = DateUtils.toInstant((long)in.readOptionalVLong());
        }

        public UpdateStats(Instant lastSucceededAt, Long lastProcessingTimeInMillis, Instant lastFailedAt, Instant lastSkippedAt) {
            this.lastSucceededAt = lastSucceededAt;
            this.lastProcessingTimeInMillis = lastProcessingTimeInMillis;
            this.lastFailedAt = lastFailedAt;
            this.lastSkippedAt = lastSkippedAt;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVLong(this.lastSucceededAt == null ? null : Long.valueOf(this.lastSucceededAt.toEpochMilli()));
            out.writeOptionalVLong(this.lastProcessingTimeInMillis);
            out.writeOptionalVLong(this.lastFailedAt == null ? null : Long.valueOf(this.lastFailedAt.toEpochMilli()));
            out.writeOptionalVLong(this.lastSkippedAt == null ? null : Long.valueOf(this.lastSkippedAt.toEpochMilli()));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.lastSucceededAt != null) {
                builder.timeField(LAST_SUCCEEDED_AT_FIELD.getPreferredName(), LAST_SUCCEEDED_AT_FIELD_READABLE.getPreferredName(), this.lastSucceededAt.toEpochMilli());
            }
            if (this.lastProcessingTimeInMillis != null) {
                builder.field(LAST_PROCESSING_TIME_IN_MILLIS_FIELD.getPreferredName(), this.lastProcessingTimeInMillis);
            }
            if (this.lastFailedAt != null) {
                builder.timeField(LAST_FAILED_AT_FIELD.getPreferredName(), LAST_FAILED_AT_FIELD_READABLE.getPreferredName(), this.lastFailedAt.toEpochMilli());
            }
            if (this.lastSkippedAt != null) {
                builder.timeField(LAST_SKIPPED_AT.getPreferredName(), LAST_SKIPPED_AT_READABLE.getPreferredName(), this.lastSkippedAt.toEpochMilli());
            }
            builder.endObject();
            return builder;
        }

        public void setLastFailedAt(Instant now) {
            this.lastFailedAt = now;
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_SUCCEEDED_AT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_PROCESSING_TIME_IN_MILLIS_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_FAILED_AT_FIELD);
            PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_SKIPPED_AT);
        }
    }

    public static class Builder {
        public static TIFJobParameter build(PutTIFJobRequest request) {
            long minutes = request.getUpdateInterval().minutes();
            String name = request.getName();
            IntervalSchedule schedule = new IntervalSchedule(Instant.now().truncatedTo(ChronoUnit.MILLIS), (int)minutes, ChronoUnit.MINUTES);
            return new TIFJobParameter(name, schedule);
        }
    }
}

