/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.model.Detector;

public class IndexDetectorRequest
extends ActionRequest {
    private String detectorId;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private RestRequest.Method method;
    private Detector detector;

    public IndexDetectorRequest(String detectorId, WriteRequest.RefreshPolicy refreshPolicy, RestRequest.Method method, Detector detector) {
        this.detectorId = detectorId;
        this.refreshPolicy = refreshPolicy;
        this.method = method;
        this.detector = detector;
    }

    public IndexDetectorRequest(StreamInput sin) throws IOException {
        this(sin.readString(), WriteRequest.RefreshPolicy.readFrom((StreamInput)sin), (RestRequest.Method)sin.readEnum(RestRequest.Method.class), Detector.readFrom(sin));
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        this.refreshPolicy.writeTo(out);
        out.writeEnum((Enum)this.method);
        this.detector.writeTo(out);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }
}

