/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.BooleanProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Dataset;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.sequence.MutableSequenceDataset;
import org.tribuo.sequence.SequenceDataset;

public class DatasetProvenance
implements DataProvenance,
ObjectProvenance {
    private static final long serialVersionUID = 1L;
    static final String DATASOURCE = "datasource";
    static final String TRANSFORMATIONS = "transformations";
    static final String IS_DENSE = "is-dense";
    static final String IS_SEQUENCE = "is-sequence";
    static final String NUM_EXAMPLES = "num-examples";
    static final String NUM_FEATURES = "num-features";
    static final String NUM_OUTPUTS = "num-outputs";
    private static final String TRIBUO_VERSION_STRING = "tribuo-version";
    private final String className;
    private final DataProvenance sourceProvenance;
    private final ListProvenance<ObjectProvenance> transformationProvenance;
    private final boolean isDense;
    private final boolean isSequence;
    private final int numExamples;
    private final int numFeatures;
    private final int numOutputs;
    private final String versionString;

    public <T extends Output<T>> DatasetProvenance(DataProvenance sourceProvenance, ListProvenance<ObjectProvenance> transformationProvenance, Dataset<T> dataset) {
        this(sourceProvenance, transformationProvenance, dataset.getClass().getName(), dataset instanceof MutableDataset && ((MutableDataset)dataset).isDense(), false, dataset.size(), dataset.getFeatureMap().size(), dataset.getOutputInfo().size());
    }

    public <T extends Output<T>> DatasetProvenance(DataProvenance sourceProvenance, ListProvenance<ObjectProvenance> transformationProvenance, SequenceDataset<T> dataset) {
        this(sourceProvenance, transformationProvenance, dataset.getClass().getName(), dataset instanceof MutableSequenceDataset && ((MutableSequenceDataset)dataset).isDense(), true, dataset.size(), dataset.getFeatureMap().size(), dataset.getOutputInfo().size());
    }

    protected DatasetProvenance(DataProvenance sourceProvenance, ListProvenance<ObjectProvenance> transformationProvenance, String datasetClassName, boolean isDense, boolean isSequence, int numExamples, int numFeatures, int numOutputs) {
        this.className = datasetClassName;
        this.sourceProvenance = sourceProvenance;
        this.transformationProvenance = transformationProvenance;
        this.isDense = isDense;
        this.isSequence = isSequence;
        this.numExamples = numExamples;
        this.numFeatures = numFeatures;
        this.numOutputs = numOutputs;
        this.versionString = "4.2.1";
    }

    public DatasetProvenance(Map<String, Provenance> map) {
        this.className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.sourceProvenance = (DataProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DATASOURCE, DataProvenance.class, (String)DatasetProvenance.class.getSimpleName());
        this.transformationProvenance = (ListProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRANSFORMATIONS, ListProvenance.class, (String)DatasetProvenance.class.getSimpleName());
        this.isDense = ((BooleanProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)IS_DENSE, BooleanProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.isSequence = ((BooleanProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)IS_SEQUENCE, BooleanProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.numExamples = ((IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)NUM_EXAMPLES, IntProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.numFeatures = ((IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)NUM_FEATURES, IntProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.numOutputs = ((IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)NUM_OUTPUTS, IntProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
        this.versionString = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRIBUO_VERSION_STRING, StringProvenance.class, (String)DatasetProvenance.class.getSimpleName())).getValue();
    }

    public String getClassName() {
        return this.className;
    }

    public DataProvenance getSourceProvenance() {
        return this.sourceProvenance;
    }

    public ListProvenance<ObjectProvenance> getTransformationProvenance() {
        return this.transformationProvenance;
    }

    public boolean isDense() {
        return this.isDense;
    }

    public boolean isSequence() {
        return this.isSequence;
    }

    public int getNumExamples() {
        return this.numExamples;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public String getTribuoVersion() {
        return this.versionString;
    }

    public Iterator<Pair<String, Provenance>> iterator() {
        List<Pair<String, Provenance>> iterable = this.allProvenances();
        return iterable.iterator();
    }

    protected List<Pair<String, Provenance>> allProvenances() {
        ArrayList<Pair<String, Provenance>> provenances = new ArrayList<Pair<String, Provenance>>();
        provenances.add(new Pair((Object)"class-name", (Object)new StringProvenance("class-name", this.className)));
        provenances.add(new Pair((Object)DATASOURCE, (Object)this.sourceProvenance));
        provenances.add(new Pair((Object)TRANSFORMATIONS, this.transformationProvenance));
        provenances.add(new Pair((Object)IS_SEQUENCE, (Object)new BooleanProvenance(IS_SEQUENCE, this.isSequence)));
        provenances.add(new Pair((Object)IS_DENSE, (Object)new BooleanProvenance(IS_DENSE, this.isDense)));
        provenances.add(new Pair((Object)NUM_EXAMPLES, (Object)new IntProvenance(NUM_EXAMPLES, this.numExamples)));
        provenances.add(new Pair((Object)NUM_FEATURES, (Object)new IntProvenance(NUM_FEATURES, this.numFeatures)));
        provenances.add(new Pair((Object)NUM_OUTPUTS, (Object)new IntProvenance(NUM_OUTPUTS, this.numOutputs)));
        provenances.add(new Pair((Object)TRIBUO_VERSION_STRING, (Object)new StringProvenance(TRIBUO_VERSION_STRING, this.versionString)));
        return provenances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatasetProvenance)) {
            return false;
        }
        DatasetProvenance pairs = (DatasetProvenance)o;
        return this.isDense == pairs.isDense && this.isSequence == pairs.isSequence && this.numExamples == pairs.numExamples && this.numFeatures == pairs.numFeatures && this.numOutputs == pairs.numOutputs && this.className.equals(pairs.className) && this.sourceProvenance.equals(pairs.sourceProvenance) && this.transformationProvenance.equals(pairs.transformationProvenance) && this.versionString.equals(pairs.versionString);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.sourceProvenance, this.transformationProvenance, this.isDense, this.isSequence, this.numExamples, this.numFeatures, this.numOutputs, this.versionString);
    }

    public String toString() {
        if (this.isSequence) {
            return this.generateString("SequenceDataset");
        }
        return this.generateString("Dataset");
    }
}

