/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.store.PointStoreLarge;
import com.amazon.randomcutforest.store.PointStoreSmall;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.MultiCenter;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.util.ArrayUtils;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.function.BiFunction;

public abstract class PointStore
implements IPointStore<Integer, float[]> {
    public static int INFEASIBLE_POINTSTORE_INDEX = -1;
    public static int INFEASIBLE_LOCN = -1;
    protected IndexIntervalManager indexManager;
    protected float[] store;
    protected float[] internalShingle;
    boolean rotationEnabled;
    protected long nextSequenceIndex;
    protected byte[] refCount;
    protected HashMap<Integer, Integer> refCountMap;
    int startOfFreeSegment;
    int dimensions;
    int shingleSize;
    int baseDimension;
    int capacity;
    int currentStoreCapacity;
    boolean internalShinglingEnabled;

    abstract void setInfeasiblePointstoreLocationIndex(int var1);

    abstract void extendLocationList(int var1);

    abstract void setLocation(int var1, int var2);

    abstract int getLocation(int var1);

    @Override
    public int decrementRefCount(int index) {
        CommonUtils.checkArgument(index >= 0 && index < this.locationListLength(), " index not supported by store");
        CommonUtils.checkArgument((this.refCount[index] & 0xFF) > 0, " cannot decrement index");
        Integer value = this.refCountMap.remove(index);
        if (value == null) {
            if ((this.refCount[index] & 0xFF) == 1) {
                this.indexManager.releaseIndex(index);
                this.refCount[index] = 0;
                this.setInfeasiblePointstoreLocationIndex(index);
                return 0;
            }
            byte newVal = (byte)((this.refCount[index] & 0xFF) - 1);
            this.refCount[index] = newVal;
            return newVal;
        }
        if (value > 1) {
            this.refCountMap.put(index, value - 1);
        }
        return value - 1 + (this.refCount[index] & 0xFF);
    }

    int takeIndex() {
        if (this.indexManager.isEmpty()) {
            if (this.indexManager.getCapacity() < this.capacity) {
                int oldCapacity = this.indexManager.getCapacity();
                int newCapacity = Math.min(this.capacity, 1 + (int)Math.floor(1.1 * (double)oldCapacity));
                this.indexManager.extendCapacity(newCapacity);
                this.refCount = Arrays.copyOf(this.refCount, newCapacity);
                this.extendLocationList(newCapacity);
            } else {
                throw new IllegalStateException(" index manager in point store is full ");
            }
        }
        return this.indexManager.takeIndex();
    }

    protected int getAmountToWrite(float[] tempPoint) {
        if (this.checkShingleAlignment(this.startOfFreeSegment, tempPoint)) {
            if (!this.rotationEnabled || (long)(this.startOfFreeSegment % this.dimensions) == (this.nextSequenceIndex - 1L) * (long)this.baseDimension % (long)this.dimensions) {
                return this.baseDimension;
            }
        } else if (!this.rotationEnabled) {
            return this.dimensions;
        }
        return this.dimensions + (this.dimensions - this.startOfFreeSegment % this.dimensions + (int)(this.nextSequenceIndex * (long)this.baseDimension) % this.dimensions) % this.dimensions;
    }

    @Override
    public int add(double[] point, long sequenceNum) {
        return this.add(CommonUtils.toFloatArray(point), sequenceNum, false);
    }

    @Override
    public Integer add(float[] point, long sequenceNum, boolean updateShingleOnly) {
        int amountToWrite;
        CommonUtils.checkArgument(this.internalShinglingEnabled || point.length == this.dimensions, "point.length must be equal to dimensions");
        CommonUtils.checkArgument(!this.internalShinglingEnabled || point.length == this.baseDimension, "point.length must be equal to dimensions");
        float[] tempPoint = point;
        ++this.nextSequenceIndex;
        if (this.internalShinglingEnabled) {
            tempPoint = this.constructShingleInPlace(this.internalShingle, point, false);
            if (this.nextSequenceIndex < (long)this.shingleSize || updateShingleOnly) {
                return INFEASIBLE_POINTSTORE_INDEX;
            }
        }
        if (this.startOfFreeSegment > this.currentStoreCapacity * this.dimensions - (amountToWrite = this.getAmountToWrite(tempPoint))) {
            this.compact();
            amountToWrite = this.getAmountToWrite(tempPoint);
            if (this.startOfFreeSegment > this.currentStoreCapacity * this.dimensions - amountToWrite) {
                this.resizeStore();
                CommonUtils.checkState(this.startOfFreeSegment + amountToWrite <= this.currentStoreCapacity * this.dimensions, "out of space");
            }
        }
        int nextIndex = this.takeIndex();
        this.setLocation(nextIndex, this.startOfFreeSegment - this.dimensions + amountToWrite);
        if (amountToWrite <= this.dimensions) {
            this.copyPoint(tempPoint, this.dimensions - amountToWrite, this.startOfFreeSegment, amountToWrite);
        } else {
            this.copyPoint(tempPoint, 0, this.startOfFreeSegment + amountToWrite - this.dimensions, this.dimensions);
        }
        this.startOfFreeSegment += amountToWrite;
        this.refCount[nextIndex] = 1;
        return nextIndex;
    }

    @Override
    public int incrementRefCount(int index) {
        CommonUtils.checkArgument(index >= 0 && index < this.locationListLength(), " index not supported by store");
        CommonUtils.checkArgument((this.refCount[index] & 0xFF) > 0, " not in use");
        Integer value = this.refCountMap.remove(index);
        if (value == null) {
            if ((this.refCount[index] & 0xFF) == 255) {
                this.refCountMap.put(index, 1);
                return 256;
            }
            byte newVal = (byte)((this.refCount[index] & 0xFF) + 1);
            this.refCount[index] = newVal;
            return newVal;
        }
        this.refCountMap.put(index, value + 1);
        return value + 1;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public int getIndexCapacity() {
        return this.indexManager.getCapacity();
    }

    @Override
    public int getShingleSize() {
        return this.shingleSize;
    }

    public int getCurrentStoreCapacity() {
        return this.currentStoreCapacity;
    }

    public float[] getStore() {
        return this.store;
    }

    public int[] getRefCount() {
        int[] newarray = new int[this.refCount.length];
        for (int i = 0; i < this.refCount.length; ++i) {
            newarray[i] = this.refCount[i] & 0xFF;
            Integer value = this.refCountMap.get(i);
            if (value == null) continue;
            int n = i;
            newarray[n] = newarray[n] + value;
        }
        return newarray;
    }

    public int getStartOfFreeSegment() {
        return this.startOfFreeSegment;
    }

    @Override
    public boolean isInternalShinglingEnabled() {
        return this.internalShinglingEnabled;
    }

    @Override
    public long getNextSequenceIndex() {
        return this.nextSequenceIndex;
    }

    @Override
    public float[] getInternalShingle() {
        CommonUtils.checkState(this.internalShinglingEnabled, "internal shingling is not enabled");
        return this.copyShingle();
    }

    abstract int locationListLength();

    void alignBoundaries(int initial, int freshStart) {
        int locn = freshStart;
        for (int i = 0; i < initial; ++i) {
            this.store[locn] = 0.0f;
            ++locn;
        }
    }

    public void compact() {
        Vector<Integer[]> reverseReference = new Vector<Integer[]>();
        for (int i = 0; i < this.locationListLength(); ++i) {
            int locn = this.getLocation(i);
            if (locn >= this.currentStoreCapacity * this.dimensions || locn < 0) continue;
            reverseReference.add(new Integer[]{locn, i});
        }
        reverseReference.sort((o1, o2) -> o1[0].compareTo(o2[0]));
        int freshStart = 0;
        int jStatic = 0;
        int jDynamic = 0;
        int jEnd = reverseReference.size();
        while (jStatic < jEnd) {
            int blockStart = ((Integer[])reverseReference.get(jStatic))[0];
            int blockEnd = blockStart + this.dimensions;
            int initial = 0;
            if (this.rotationEnabled) {
                initial = (this.dimensions - freshStart + blockStart) % this.dimensions;
            }
            int k = jStatic + 1;
            jDynamic = jStatic + 1;
            while (k < jEnd) {
                int newElem = ((Integer[])reverseReference.get(k))[0];
                if (blockEnd >= newElem) {
                    ++k;
                    ++jDynamic;
                    blockEnd = Math.max(blockEnd, newElem + this.dimensions);
                    continue;
                }
                k = jEnd;
            }
            this.alignBoundaries(initial, freshStart);
            int start = freshStart += initial;
            for (int i = blockStart; i < blockEnd; ++i) {
                int locn;
                assert (!this.rotationEnabled || freshStart % this.dimensions == i % this.dimensions);
                if (jStatic < jEnd && i == (locn = ((Integer[])reverseReference.get(jStatic))[0].intValue())) {
                    int newIdx = ((Integer[])reverseReference.get(jStatic))[1];
                    this.setLocation(newIdx, freshStart);
                    ++jStatic;
                }
                ++freshStart;
            }
            this.copyTo(start, blockStart, blockEnd - blockStart);
            if (jStatic == jDynamic) continue;
            throw new IllegalStateException("There is discepancy in indices");
        }
        this.startOfFreeSegment = freshStart;
    }

    public int getRefCount(int i) {
        int val = this.refCount[i] & 0xFF;
        Integer value = this.refCountMap.get(i);
        if (value != null) {
            val += value.intValue();
        }
        return val;
    }

    @Override
    public boolean isInternalRotationEnabled() {
        return this.rotationEnabled;
    }

    public abstract int size();

    public abstract int[] getLocationList();

    @Override
    public float[] transformToShingledPoint(float[] point) {
        CommonUtils.checkNotNull(point, "point must not be null");
        if (this.internalShinglingEnabled && point.length == this.baseDimension) {
            return this.constructShingleInPlace(this.copyShingle(), point, this.rotationEnabled);
        }
        return ArrayUtils.cleanCopy(point);
    }

    private float[] copyShingle() {
        if (!this.rotationEnabled) {
            return Arrays.copyOf(this.internalShingle, this.dimensions);
        }
        float[] answer = new float[this.dimensions];
        int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension);
        for (int i = 0; i < this.dimensions; ++i) {
            answer[(offset + i) % this.dimensions] = this.internalShingle[i];
        }
        return answer;
    }

    protected float[] constructShingleInPlace(float[] target, float[] point, boolean rotationEnabled) {
        if (!rotationEnabled) {
            int i;
            for (i = 0; i < this.dimensions - this.baseDimension; ++i) {
                target[i] = target[i + this.baseDimension];
            }
            for (i = 0; i < this.baseDimension; ++i) {
                target[this.dimensions - this.baseDimension + i] = (double)point[i] == 0.0 ? 0.0f : point[i];
            }
        } else {
            int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension) % this.dimensions;
            for (int i = 0; i < this.baseDimension; ++i) {
                target[offset + i] = (double)point[i] == 0.0 ? 0.0f : point[i];
            }
        }
        return target;
    }

    @Override
    public int[] transformIndices(int[] indexList) {
        CommonUtils.checkArgument(this.internalShinglingEnabled, " only allowed for internal shingling");
        CommonUtils.checkArgument(indexList.length <= this.baseDimension, " incorrect length");
        int[] results = Arrays.copyOf(indexList, indexList.length);
        if (!this.rotationEnabled) {
            int i = 0;
            while (i < indexList.length) {
                CommonUtils.checkArgument(results[i] < this.baseDimension, "incorrect index");
                int n = i++;
                results[n] = results[n] + (this.dimensions - this.baseDimension);
            }
        } else {
            int offset = (int)(this.nextSequenceIndex * (long)this.baseDimension) % this.dimensions;
            for (int i = 0; i < indexList.length; ++i) {
                CommonUtils.checkArgument(results[i] < this.baseDimension, "incorrect index");
                results[i] = (results[i] + offset) % this.dimensions;
            }
        }
        return results;
    }

    public PointStore(Builder builder) {
        CommonUtils.checkArgument(builder.dimensions > 0, "dimensions must be greater than 0");
        CommonUtils.checkArgument(builder.capacity > 0, "capacity must be greater than 0");
        CommonUtils.checkArgument(builder.shingleSize == 1 || builder.dimensions == builder.shingleSize || builder.dimensions % builder.shingleSize == 0, "incorrect use of shingle size");
        if (builder.refCount != null || builder.locationList != null || builder.knownShingle != null) {
            CommonUtils.checkArgument(builder.refCount != null, "reference count must be present");
            CommonUtils.checkArgument(builder.locationList != null, "location list must be present");
            CommonUtils.checkArgument(builder.refCount.length == builder.indexCapacity, "incorrect reference count length");
            CommonUtils.checkArgument(builder.locationList.length == builder.indexCapacity, " incorrect length of locations");
            CommonUtils.checkArgument(builder.knownShingle == null || builder.internalShinglingEnabled && builder.knownShingle.length == builder.dimensions, "incorrect shingling information");
        }
        this.shingleSize = builder.shingleSize;
        this.dimensions = builder.dimensions;
        this.internalShinglingEnabled = builder.internalShinglingEnabled;
        this.rotationEnabled = builder.internalRotationEnabled;
        this.baseDimension = this.dimensions / this.shingleSize;
        this.capacity = builder.capacity;
        this.refCountMap = new HashMap();
        if (builder.refCount == null) {
            int size;
            this.currentStoreCapacity = size = builder.initialPointStoreSize.orElse(builder.capacity).intValue();
            this.indexManager = new IndexIntervalManager(size);
            this.startOfFreeSegment = 0;
            this.refCount = new byte[size];
            if (this.internalShinglingEnabled) {
                this.nextSequenceIndex = 0L;
                this.internalShingle = new float[this.dimensions];
            }
            this.store = new float[this.currentStoreCapacity * this.dimensions];
        } else {
            this.refCount = new byte[builder.refCount.length];
            for (int i = 0; i < this.refCount.length; ++i) {
                if (builder.refCount[i] >= 0 && builder.refCount[i] <= 255) {
                    this.refCount[i] = (byte)builder.refCount[i];
                    continue;
                }
                if (builder.refCount[i] <= 255) continue;
                this.refCount[i] = -1;
                this.refCountMap.put(i, builder.refCount[i] - 255);
            }
            this.startOfFreeSegment = builder.startOfFreeSegment;
            this.nextSequenceIndex = builder.nextTimeStamp;
            this.currentStoreCapacity = builder.currentStoreCapacity;
            if (this.internalShinglingEnabled) {
                this.internalShingle = builder.knownShingle != null ? Arrays.copyOf(CommonUtils.toFloatArray(builder.knownShingle), this.dimensions) : new float[this.dimensions];
            }
            this.indexManager = new IndexIntervalManager(builder.refCount, builder.indexCapacity);
            this.store = builder.store == null ? new float[this.currentStoreCapacity * this.dimensions] : builder.store;
        }
    }

    void resizeStore() {
        int maxCapacity = this.rotationEnabled ? 2 * this.capacity : this.capacity;
        int newCapacity = (int)Math.floor(Math.min(1.1 * (double)this.currentStoreCapacity, (double)maxCapacity));
        if (newCapacity > this.currentStoreCapacity) {
            float[] newStore = new float[newCapacity * this.dimensions];
            System.arraycopy(this.store, 0, newStore, 0, this.currentStoreCapacity * this.dimensions);
            this.currentStoreCapacity = newCapacity;
            this.store = newStore;
        }
    }

    boolean checkShingleAlignment(int location, float[] point) {
        boolean test = location - this.dimensions + this.baseDimension >= 0;
        for (int i = 0; i < this.dimensions - this.baseDimension && test; ++i) {
            test = point[i] == this.store[location - this.dimensions + this.baseDimension + i];
        }
        return test;
    }

    void copyPoint(float[] point, int src, int location, int length) {
        for (int i = 0; i < length; ++i) {
            this.store[location + i] = point[src + i];
        }
    }

    protected abstract void checkFeasible(int var1);

    @Override
    public float[] getNumericVector(int index) {
        CommonUtils.checkArgument(index >= 0 && index < this.locationListLength(), " index not supported by store");
        int address = this.getLocation(index);
        this.checkFeasible(index);
        if (!this.rotationEnabled) {
            return Arrays.copyOfRange(this.store, address, address + this.dimensions);
        }
        float[] answer = new float[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            answer[(address + i) % this.dimensions] = this.store[address + i];
        }
        return answer;
    }

    @Override
    public String toString(int index) {
        return Arrays.toString(this.getNumericVector(index));
    }

    void copyTo(int dest, int source, int length) {
        if (dest < source) {
            for (int i = 0; i < length; ++i) {
                this.store[dest + i] = this.store[source + i];
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<ICluster<float[]>> summarize(int maxAllowed, double shrinkage, int numberOfRepresentatives, double separationRatio, BiFunction<float[], float[], Double> distance, List<ICluster<float[]>> previous) {
        int[] counts = this.getRefCount();
        ArrayList<Weighted<Integer>> refs = new ArrayList<Weighted<Integer>>();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == 0) continue;
            refs.add(new Weighted<Integer>(i, counts[i]));
        }
        BiFunction<float[], Float, ICluster> clusterInitializer = (a, b) -> MultiCenter.initialize(a, b.floatValue(), shrinkage, numberOfRepresentatives);
        return Summarizer.iterativeClustering(maxAllowed, 4 * maxAllowed, 1, refs, this::getNumericVector, distance, clusterInitializer, 42L, false, true, separationRatio, previous);
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int shingleSize = 1;
        protected int baseDimension;
        protected boolean internalRotationEnabled = false;
        protected boolean internalShinglingEnabled = false;
        protected int capacity;
        protected Optional<Integer> initialPointStoreSize = Optional.empty();
        protected int currentStoreCapacity = 0;
        protected int indexCapacity = 0;
        protected float[] store = null;
        protected double[] knownShingle = null;
        protected int[] locationList = null;
        protected int[] refCount = null;
        protected long nextTimeStamp = 0L;
        protected int startOfFreeSegment = 0;

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T initialSize(int initialPointStoreSize) {
            this.initialPointStoreSize = Optional.of(initialPointStoreSize);
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = internalShinglingEnabled;
            return (T)this;
        }

        public T internalRotationEnabled(boolean internalRotationEnabled) {
            this.internalRotationEnabled = internalRotationEnabled;
            return (T)this;
        }

        @Deprecated
        public T directLocationEnabled(boolean value) {
            return (T)this;
        }

        @Deprecated
        public T dynamicResizingEnabled(boolean value) {
            return (T)this;
        }

        public T currentStoreCapacity(int currentStoreCapacity) {
            this.currentStoreCapacity = currentStoreCapacity;
            return (T)this;
        }

        public T indexCapacity(int indexCapacity) {
            this.indexCapacity = indexCapacity;
            return (T)this;
        }

        public T knownShingle(double[] knownShingle) {
            this.knownShingle = knownShingle;
            return (T)this;
        }

        public T refCount(int[] refCount) {
            this.refCount = refCount;
            return (T)this;
        }

        public T locationList(int[] locationList) {
            this.locationList = locationList;
            return (T)this;
        }

        public T store(float[] store) {
            this.store = store;
            return (T)this;
        }

        public T startOfFreeSegment(int startOfFreeSegment) {
            this.startOfFreeSegment = startOfFreeSegment;
            return (T)this;
        }

        public T nextTimeStamp(long nextTimeStamp) {
            this.nextTimeStamp = nextTimeStamp;
            return (T)this;
        }

        public PointStore build() {
            if (this.shingleSize * this.capacity < 65535) {
                return new PointStoreSmall(this);
            }
            return new PointStoreLarge(this);
        }
    }
}

