/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.LabelTarget;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.storage.script.aggregation.CalciteAggregationScriptFactory;
import org.opensearch.sql.opensearch.storage.script.filter.CalciteFilterScriptFactory;
import org.opensearch.sql.opensearch.storage.serde.RelJsonSerializer;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class CalciteScriptEngine
implements ScriptEngine {
    private final RelJsonSerializer relJsonSerializer;
    public static final String EXPRESSION_LANG_NAME = "opensearch_calcite_expression";
    private static final Map<ScriptContext<?>, BiFunction<Function1<DataContext, Object[]>, RelDataType, Object>> CONTEXTS = new ImmutableMap.Builder().put((Object)FilterScript.CONTEXT, CalciteFilterScriptFactory::new).put((Object)AggregationScript.CONTEXT, CalciteAggregationScriptFactory::new).build();

    public CalciteScriptEngine(RelOptCluster relOptCluster) {
        this.relJsonSerializer = new RelJsonSerializer(relOptCluster);
    }

    public String getType() {
        return EXPRESSION_LANG_NAME;
    }

    public <T> T compile(String scriptName, String scriptCode, ScriptContext<T> context, Map<String, String> options) {
        Map<String, Object> objectMap = this.relJsonSerializer.deserialize(scriptCode);
        RexNode rexNode = (RexNode)objectMap.get("expr");
        RelDataType rowType = (RelDataType)objectMap.get("rowType");
        Map fieldTypes = (Map)objectMap.get("fieldTypes");
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(this.relJsonSerializer.getCluster().getTypeFactory().getTypeSystem());
        ScriptInputGetter getter = new ScriptInputGetter((RelDataTypeFactory)typeFactory, rowType, fieldTypes);
        String code = CalciteScriptEngine.translate(this.relJsonSerializer.getCluster().getRexBuilder(), List.of(rexNode), getter, rowType);
        Function1 function = new RexExecutable(code, (Object)"generated Rex code").getFunction();
        if (CONTEXTS.containsKey(context)) {
            return context.factoryClazz.cast(CONTEXTS.get(context).apply((Function1<DataContext, Object[]>)function, rexNode.getType()));
        }
        throw new IllegalStateException(String.format("Script context is currently not supported: all supported contexts [%s], given context [%s] ", CONTEXTS, context));
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return CONTEXTS.keySet();
    }

    public static String translate(RexBuilder rexBuilder, List<RexNode> constExps, RexToLixTranslator.InputGetter getter, RelDataType rowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(rowType, rexBuilder);
        for (RexNode node : constExps) {
            programBuilder.addProject(node, "c" + programBuilder.getProjectList().size());
        }
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        JavaTypeFactory javaTypeFactory = typeFactory instanceof JavaTypeFactory ? (JavaTypeFactory)typeFactory : new JavaTypeFactoryImpl(typeFactory.getTypeSystem());
        BlockBuilder blockBuilder = new BlockBuilder();
        ParameterExpression root0_ = Expressions.parameter(Object.class, (String)"root0");
        ParameterExpression root_ = DataContext.ROOT;
        blockBuilder.add((Statement)Expressions.declare((int)16, (ParameterExpression)root_, (Expression)Expressions.convert_((Expression)root0_, DataContext.class)));
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        RexProgram program = programBuilder.getProgram();
        List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)javaTypeFactory, (SqlConformance)conformance, (BlockBuilder)blockBuilder, (BlockBuilder)null, (PhysType)null, (Expression)root_, (RexToLixTranslator.InputGetter)getter, (Function1)null);
        blockBuilder.add((Statement)Expressions.return_((LabelTarget)null, (Expression)Expressions.newArrayInit(Object[].class, (Iterable)expressions)));
        MethodDeclaration methodDecl = Expressions.methodDecl((int)1, Object[].class, (String)BuiltInMethod.FUNCTION1_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)root0_), (BlockStatement)blockBuilder.toBlock());
        String code = Expressions.toString((Node)methodDecl);
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            Util.debugCode((PrintStream)System.out, (String)code);
        }
        return code;
    }

    private static Pair<String, ExprType> getValidatedReferenceNameAndType(RelDataType rowType, int index, Map<String, ExprType> fieldTypes) {
        String fieldName = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
        ExprType exprType = fieldTypes.get(fieldName);
        if (exprType == ExprCoreType.STRUCT) {
            throw new UnsupportedScriptException("Script query does not support fields of struct type: " + fieldName);
        }
        PredicateAnalyzer.NamedFieldExpression expression = new PredicateAnalyzer.NamedFieldExpression(fieldName, exprType);
        String referenceField = expression.getReferenceForTermQuery();
        if (StringUtils.isEmpty((CharSequence)referenceField)) {
            throw new UnsupportedScriptException("Field name cannot be empty for expression: " + expression.getRootName());
        }
        return Pair.of((Object)referenceField, (Object)exprType);
    }

    @Generated
    public CalciteScriptEngine(RelJsonSerializer relJsonSerializer) {
        this.relJsonSerializer = relJsonSerializer;
    }

    /*
     * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
     */
    public static class ScriptInputGetter
    implements RexToLixTranslator.InputGetter {
        private final RelDataTypeFactory typeFactory;
        private final RelDataType rowType;
        private final Map<String, ExprType> fieldTypes;

        public ScriptInputGetter(RelDataTypeFactory typeFactory, RelDataType rowType, Map<String, ExprType> fieldTypes) {
            this.typeFactory = typeFactory;
            this.rowType = rowType;
            this.fieldTypes = fieldTypes;
        }

        public Expression field(BlockBuilder list, int index, @Nullable Type storageType) {
            Pair<String, ExprType> refTypePair = CalciteScriptEngine.getValidatedReferenceNameAndType(this.rowType, index, this.fieldTypes);
            MethodCallExpression fieldValueExpr = Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)refTypePair.getKey())});
            if (storageType == null) {
                RelDataType fieldType = ((RelDataTypeField)this.rowType.getFieldList().get(index)).getType();
                storageType = ((JavaTypeFactory)this.typeFactory).getJavaClass(fieldType);
            }
            return EnumUtils.convert((Expression)this.tryConvertDocValue((Expression)fieldValueExpr, (ExprType)refTypePair.getValue()), (Type)storageType);
        }

        /*
         * Exception decompiling
         */
        private Expression tryConvertDocValue(Expression docValueExpr, ExprType exprType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,171
             *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static final class UnsupportedScriptException
    extends RuntimeException {
        public UnsupportedScriptException(String message) {
            super(message);
        }

        public UnsupportedScriptException(Throwable cause) {
            super(cause);
        }
    }

    public static class ScriptDataContext
    implements DataContext {
        private final Supplier<Map<String, ScriptDocValues<?>>> docProvider;
        private final Map<String, Object> params;

        public ScriptDataContext(Supplier<Map<String, ScriptDocValues<?>>> docProvider, Map<String, Object> params) {
            this.docProvider = docProvider;
            this.params = params;
        }

        public @Nullable SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            if (DataContext.Variable.UTC_TIMESTAMP.camelName.equals(name)) {
                return this.params.get(DataContext.Variable.UTC_TIMESTAMP.camelName);
            }
            ScriptDocValues<?> docValue = this.docProvider.get().get(name);
            if (docValue == null || docValue.isEmpty()) {
                return null;
            }
            Object value = docValue.get(0);
            if (value instanceof ChronoZonedDateTime) {
                return new ExprTimestampValue(((ChronoZonedDateTime)value).toInstant()).value();
            }
            return value;
        }
    }

    public static class ReferenceFieldVisitor
    extends RexVisitorImpl<Pair<String, ExprType>> {
        private final RelDataType rowType;
        private final Map<String, ExprType> fieldTypes;

        public ReferenceFieldVisitor(RelDataType rowType, Map<String, ExprType> fieldTypes, boolean deep) {
            super(deep);
            this.rowType = rowType;
            this.fieldTypes = fieldTypes;
        }

        public Pair<String, ExprType> visitInputRef(RexInputRef inputRef) {
            return CalciteScriptEngine.getValidatedReferenceNameAndType(this.rowType, inputRef.getIndex(), this.fieldTypes);
        }
    }
}

