/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client.impl;

import java.util.Map;
import org.opensearch.OpenSearchException;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.core.common.Strings;
import org.opensearch.remote.metadata.client.impl.RemoteClusterIndicesClient;
import org.opensearch.remote.metadata.common.CommonValue;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;

public class AOSOpenSearchClient
extends RemoteClusterIndicesClient {
    public boolean supportsMetadataType(String metadataType) {
        return "AWSOpenSearchService".equals(metadataType);
    }

    public void initialize(Map<String, String> metadataSettings) {
        super.initialize(metadataSettings);
        this.openSearchAsyncClient = this.createOpenSearchAsyncClient();
        this.mapper = ((OpenSearchTransport)this.openSearchAsyncClient._transport()).jsonpMapper();
    }

    private void validateAwsParams() {
        if (Strings.isNullOrEmpty((String)this.remoteMetadataEndpoint) || Strings.isNullOrEmpty((String)this.region)) {
            throw new OpenSearchException(this.remoteMetadataType + " client requires a metadata endpoint and region.", new Object[0]);
        }
        if (!CommonValue.VALID_AWS_OPENSEARCH_SERVICE_NAMES.contains(this.serviceName)) {
            throw new OpenSearchException(this.remoteMetadataType + " client only supports service names " + String.valueOf(CommonValue.VALID_AWS_OPENSEARCH_SERVICE_NAMES), new Object[0]);
        }
    }

    protected OpenSearchAsyncClient createOpenSearchAsyncClient() {
        this.validateAwsParams();
        return this.createAwsOpenSearchServiceAsyncClient();
    }

    private OpenSearchAsyncClient createAwsOpenSearchServiceAsyncClient() {
        SdkHttpClient httpClient = ApacheHttpClient.builder().build();
        return new OpenSearchAsyncClient((OpenSearchTransport)ThreadContextAccess.doPrivileged(() -> new AwsSdk2Transport(httpClient, this.remoteMetadataEndpoint.replaceAll("^https?://", ""), this.serviceName, Region.of((String)this.region), AwsSdk2TransportOptions.builder().setCredentials(AOSOpenSearchClient.createCredentialsProvider()).build())));
    }

    private static AwsCredentialsProvider createCredentialsProvider() {
        return AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ContainerCredentialsProvider.builder().build()).addCredentialsProvider((AwsCredentialsProvider)InstanceProfileCredentialsProvider.create()).build();
    }

    public void close() throws Exception {
        if (this.openSearchAsyncClient != null && this.openSearchAsyncClient._transport() != null) {
            ((OpenSearchTransport)this.openSearchAsyncClient._transport()).close();
        }
    }
}

