/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.action.mcpserver.OpenSearchMcpServerTransportProvider;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.rest.StreamingRestChannel;

public class McpAsyncServerHolder {
    public static Map<String, StreamingRestChannel> CHANNELS = new ConcurrentHashMap<String, StreamingRestChannel>();
    public static Map<String, Long> IN_MEMORY_MCP_TOOLS = new ConcurrentHashMap<String, Long>();
    private static volatile MLIndicesHandler mlIndicesHandler;
    private static volatile McpToolsHelper mcpToolsHelper;
    private static volatile OpenSearchMcpServerTransportProvider mcpServerTransportProvider;
    private static volatile McpAsyncServer asyncServer;

    public static void init(MLIndicesHandler mlIndicesHandler, McpToolsHelper mcpToolsHelper) {
        McpAsyncServerHolder.mlIndicesHandler = mlIndicesHandler;
        McpAsyncServerHolder.mcpToolsHelper = mcpToolsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenSearchMcpServerTransportProvider getMcpServerTransportProviderInstance() {
        if (mcpServerTransportProvider != null) {
            return mcpServerTransportProvider;
        }
        Class<McpAsyncServerHolder> clazz = McpAsyncServerHolder.class;
        synchronized (McpAsyncServerHolder.class) {
            if (mcpServerTransportProvider != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mcpServerTransportProvider;
            }
            mcpServerTransportProvider = new OpenSearchMcpServerTransportProvider(mlIndicesHandler, mcpToolsHelper, new ObjectMapper());
            if (asyncServer == null) {
                asyncServer = McpAsyncServerHolder.createMcpAsyncServer(mcpServerTransportProvider);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mcpServerTransportProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static McpAsyncServer getMcpAsyncServerInstance() {
        if (asyncServer != null) return asyncServer;
        Class<McpAsyncServerHolder> clazz = McpAsyncServerHolder.class;
        synchronized (McpAsyncServerHolder.class) {
            McpAsyncServerHolder.getMcpServerTransportProviderInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return asyncServer;
        }
    }

    private static McpAsyncServer createMcpAsyncServer(OpenSearchMcpServerTransportProvider provider) {
        return McpServer.async((McpServerTransportProvider)provider).capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).logging().build()).serverInfo("OpenSearch-MCP-Server", "0.1.0").build();
    }
}

