/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrap;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations_KmsPrivateKeyToStaticPublicKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations_KmsPublicKeyDiscovery;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsPrivateKeyToStaticPublicKeyInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsPublicKeyDiscoveryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, Error>> {
    public DecryptionMaterials _materials = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public IKMSClient _client = null;
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Byte> recipientPublicKey, IKMSClient client, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, KmsEcdhStaticConfigurations keyAgreementScheme, ECDHCurveSpec curveSpec) {
        this._materials = materials;
        this._cryptoPrimitives = cryptoPrimitives;
        this._recipientPublicKey = recipientPublicKey;
        this._keyAgreementScheme = keyAgreementScheme;
        this._client = client;
        this._curveSpec = curveSpec;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<DecryptionMaterials, Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _out5;
        Result<DecryptionMaterials, Error> res = null;
        AlgorithmSuiteInfo _0_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _2_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _3_ciphertext = edk.dtor_ciphertext();
        Result<DafnySequence, Error> _4_valueOrError0 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _4_valueOrError0 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_3_ciphertext, _0_suite);
        if (_4_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _4_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _5_providerWrappedMaterial = _4_valueOrError0.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_2_providerInfo.cardinalityInt(), Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())) <= 0 && RawECDHKeyring_Compile.__default.ValidProviderInfoLength(_2_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        byte _7_keyringVersion = (Byte)_2_providerInfo.select(0);
        Outcome<Error> _8_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_7_keyringVersion}).equals(__default.AWS__KMS__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_8_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        int _9_recipientPublicKeyLength = StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_2_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()));
        long _10_recipientPublicKeyLengthIndex = Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()) + Integer.toUnsignedLong(_9_recipientPublicKeyLength);
        long _11_senderPublicKeyIndex = _10_recipientPublicKeyLengthIndex + Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN();
        Outcome<Error> _12_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _12_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_10_recipientPublicKeyLengthIndex + 4L, _2_providerInfo.cardinalityInt()) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_12_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _12_valueOrError3.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _13_providerInfoRecipientPublicKey = _2_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.unsignedToInt((long)_10_recipientPublicKeyLengthIndex));
        DafnySequence _14_providerInfoSenderPublicKey = _2_providerInfo.drop(_11_senderPublicKeyIndex);
        Result<DafnySequence, Error> _15_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_14_providerInfoSenderPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _15_valueOrError4 = _out0;
        if (_15_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _15_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _16_senderPublicKey = _15_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<DafnySequence, Error> _17_valueOrError5 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out1 = RawECDHKeyring_Compile.__default.DecompressPublicKey((DafnySequence<? extends Byte>)_13_providerInfoRecipientPublicKey, this.curveSpec(), this.cryptoPrimitives());
        _17_valueOrError5 = _out1;
        if (_17_valueOrError5.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _17_valueOrError5.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _18_recipientPublicKey = _17_valueOrError5.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Result<Boolean, Error> _19_valueOrError6 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out2 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_16_senderPublicKey);
        _19_valueOrError6 = _out2;
        if (_19_valueOrError6.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _19_valueOrError6.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _20___v0 = _19_valueOrError6.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Result<Boolean, Error> _21_valueOrError7 = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        Result<Boolean, Error> _out3 = RawECDHKeyring_Compile.__default.ValidatePublicKey(this.cryptoPrimitives(), this.curveSpec(), (DafnySequence<? extends Byte>)_18_recipientPublicKey);
        _21_valueOrError7 = _out3;
        if (_21_valueOrError7.IsFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor())) {
            res = _21_valueOrError7.PropagateFailure((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        boolean _22___v1 = _21_valueOrError7.Extract((TypeDescriptor<Boolean>)TypeDescriptor.BOOLEAN, Error._typeDescriptor());
        Outcome<Error> _23_valueOrError8 = Outcome.Default(Error._typeDescriptor());
        _23_valueOrError8 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType((DafnySequence<? extends Byte>)_16_senderPublicKey) && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType(this.recipientPublicKey()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received serialized sender public key of incorrect length")));
        if (_23_valueOrError8.IsFailure(Error._typeDescriptor())) {
            res = _23_valueOrError8.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _24_sharedSecretPublicKey = DafnySequence.empty(uint8._typeDescriptor());
        DafnySequence<? extends Character> _25_sharedSecretKmsKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        KmsEcdhStaticConfigurations _source0 = this.keyAgreementScheme();
        if (_source0.is_KmsPublicKeyDiscovery()) {
            KmsPublicKeyDiscoveryInput _26___mcc_h0;
            KmsPublicKeyDiscoveryInput _27_kmsPublicKeyDiscovery = _26___mcc_h0 = ((KmsEcdhStaticConfigurations_KmsPublicKeyDiscovery)_source0)._KmsPublicKeyDiscovery;
            Result<Tuple0, Error> _28_valueOrError9 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            _28_valueOrError9 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(_27_kmsPublicKeyDiscovery.dtor_recipientKmsIdentifier());
            if (_28_valueOrError9.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _28_valueOrError9.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _29___v2 = _28_valueOrError9.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _24_sharedSecretPublicKey = _16_senderPublicKey;
            _25_sharedSecretKmsKeyId = _27_kmsPublicKeyDiscovery.dtor_recipientKmsIdentifier();
        } else {
            KmsPrivateKeyToStaticPublicKeyInput _30___mcc_h1;
            KmsPrivateKeyToStaticPublicKeyInput _31_kmsPrivateKeyToStaticPublicKey = _30___mcc_h1 = ((KmsEcdhStaticConfigurations_KmsPrivateKeyToStaticPublicKey)_source0)._KmsPrivateKeyToStaticPublicKey;
            Result<Tuple0, Error> _32_valueOrError10 = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
            _32_valueOrError10 = AwsKmsUtils_Compile.__default.ValidateKmsKeyId(_31_kmsPrivateKeyToStaticPublicKey.dtor_senderKmsIdentifier());
            if (_32_valueOrError10.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor())) {
                res = _32_valueOrError10.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
                return res;
            }
            Tuple0 _33___v3 = _32_valueOrError10.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), Error._typeDescriptor());
            _25_sharedSecretKmsKeyId = _31_kmsPrivateKeyToStaticPublicKey.dtor_senderKmsIdentifier();
            _24_sharedSecretPublicKey = _31_kmsPrivateKeyToStaticPublicKey.dtor_recipientPublicKey().equals((Object)_18_recipientPublicKey) ? _18_recipientPublicKey : _16_senderPublicKey;
        }
        Outcome<Error> _34_valueOrError11 = Outcome.Default(Error._typeDescriptor());
        _34_valueOrError11 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PublicKeyType((DafnySequence<? extends Byte>)_24_sharedSecretPublicKey), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received Recipient Public Key of incorrect expected length")));
        if (_34_valueOrError11.IsFailure(Error._typeDescriptor())) {
            res = _34_valueOrError11.PropagateFailure(Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        Result<DafnySequence, Error> _35_valueOrError12 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out4 = __default.DeriveSharedSecret(this.client(), _25_sharedSecretKmsKeyId, (DafnySequence<? extends Byte>)_24_sharedSecretPublicKey, this.grantTokens());
        _35_valueOrError12 = _out4;
        if (_35_valueOrError12.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            res = _35_valueOrError12.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _36_sharedSecret = _35_valueOrError12.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        EcdhUnwrap _nw0 = new EcdhUnwrap();
        _nw0.__ctor((DafnySequence<? extends Byte>)_14_providerInfoSenderPublicKey, (DafnySequence<? extends Byte>)_13_providerInfoRecipientPublicKey, (DafnySequence<? extends Byte>)_36_sharedSecret, __default.AWS__KMS__ECDH__KEYRING__VERSION(), this.curveSpec(), this.cryptoPrimitives());
        EcdhUnwrap _37_ecdhUnwrap = _nw0;
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _38_unwrapOutputRes = _out5 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(EcdhUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _37_ecdhUnwrap);
        Result<UnwrapEdkMaterialOutput<EcdhUnwrapInfo>, Error> _39_valueOrError13 = Result.Default(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), UnwrapEdkMaterialOutput.Default(EcdhUnwrapInfo._typeDescriptor(), EcdhUnwrapInfo.Default()));
        _39_valueOrError13 = _38_unwrapOutputRes;
        if (_39_valueOrError13.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _39_valueOrError13.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<EcdhUnwrapInfo> _40_unwrapOutput = _39_valueOrError13.Extract(UnwrapEdkMaterialOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), Error._typeDescriptor());
        Result<DecryptionMaterials, Error> _41_valueOrError14 = null;
        _41_valueOrError14 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _40_unwrapOutput.dtor_plaintextDataKey(), _40_unwrapOutput.dtor_symmetricSigningKey());
        if (_41_valueOrError14.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _41_valueOrError14.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _42_result = _41_valueOrError14.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _42_result);
        return res;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public IKMSClient client() {
        return this._client;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.DecryptSingleEncryptedDataKey";
    }
}

